/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.com.android.sdklib.internal.repository;

import com.crashlytics.reloc.com.android.sdklib.internal.repository.AddonPackage;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.DocPackage;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.ExtraPackage;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.IDescription;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.ITaskMonitor;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.Package;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.PlatformPackage;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.PlatformToolPackage;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.SamplePackage;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.SourcePackage;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.SystemImagePackage;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.ToolPackage;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.UrlOpener;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLKeyException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SdkSource
implements IDescription,
Comparable<SdkSource> {
    private String mUrl;
    private Package[] mPackages;
    private String mDescription;
    private String mFetchError;
    private final String mUiName;

    public SdkSource(String string, String string2) {
        String[] stringArray;
        if (string == null) {
            string = "";
        }
        if ((string = string.trim()).endsWith("/") && (stringArray = this.getDefaultXmlFileUrls()).length > 0) {
            string = string + stringArray[0];
        }
        this.mUrl = string;
        this.mUiName = string2;
        this.setDefaultDescription();
    }

    public abstract boolean isAddonSource();

    protected abstract String[] getDefaultXmlFileUrls();

    protected abstract int getNsLatestVersion();

    protected abstract String getNsUri();

    protected abstract String getNsPattern();

    protected abstract String getSchemaUri(int var1);

    protected abstract String getRootElementName();

    protected abstract InputStream getXsdStream(int var1);

    protected abstract Document findAlternateToolsXml(InputStream var1) throws IOException;

    public boolean equals(Object object) {
        if (object instanceof SdkSource) {
            SdkSource sdkSource = (SdkSource)object;
            return sdkSource.getUrl().equals(this.getUrl());
        }
        return false;
    }

    public int hashCode() {
        return this.mUrl.hashCode();
    }

    @Override
    public int compareTo(SdkSource sdkSource) {
        return this.getUrl().compareTo(sdkSource.getUrl());
    }

    public String getUiName() {
        return this.mUiName;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public Package[] getPackages() {
        return this.mPackages;
    }

    protected void setPackages(Package[] packageArray) {
        this.mPackages = packageArray;
        if (this.mPackages != null) {
            Arrays.sort(this.mPackages, null);
        }
    }

    public void clearPackages() {
        this.setPackages(null);
    }

    public String toString() {
        String string = this.getShortDescription();
        if (string != null) {
            return string;
        }
        return super.toString();
    }

    @Override
    public String getShortDescription() {
        if (this.mUiName != null && this.mUiName.length() > 0) {
            String string = "malformed URL";
            try {
                URL uRL = new URL(this.mUrl);
                string = uRL.getHost();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            return String.format("%1$s (%2$s)", this.mUiName, string);
        }
        return this.mUrl;
    }

    @Override
    public String getLongDescription() {
        return this.mDescription == null ? "" : this.mDescription;
    }

    public String getFetchError() {
        return this.mFetchError;
    }

    public void load(ITaskMonitor iTaskMonitor, boolean bl) {
        int n;
        iTaskMonitor.setProgressMax(7);
        this.setDefaultDescription();
        String string = this.mUrl;
        if (bl) {
            string = string.replaceAll("https://", "http://");
        }
        iTaskMonitor.setDescription("Fetching URL: %1$s", string);
        iTaskMonitor.incProgress(1);
        this.mFetchError = null;
        Boolean[] booleanArray = new Boolean[]{Boolean.FALSE};
        String[] stringArray = new String[]{null};
        Exception[] exceptionArray = new Exception[]{null};
        Document document = null;
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = null;
        String[] stringArray2 = this.getDefaultXmlFileUrls();
        String string3 = stringArray2.length > 0 ? stringArray2[0] : "";
        InputStream inputStream = this.fetchUrl(string, iTaskMonitor.createSubMonitor(1), exceptionArray);
        if (inputStream != null && (n = this.getXmlSchemaVersion(inputStream)) == 0) {
            inputStream = null;
        }
        if (inputStream == null && stringArray2.length > 0) {
            int n2;
            ITaskMonitor iTaskMonitor2 = iTaskMonitor.createSubMonitor(1);
            iTaskMonitor2.setProgressMax(stringArray2.length);
            String string4 = string;
            if (!string4.endsWith("/") && (n2 = string4.lastIndexOf(47)) > 0) {
                string4 = string4.substring(0, n2 + 1);
            }
            for (String string5 : stringArray2) {
                String string6 = string4 + string5;
                if (string6.equals(string) || (inputStream = this.fetchUrl(string6, iTaskMonitor2.createSubMonitor(1), exceptionArray)) == null) continue;
                int n3 = this.getXmlSchemaVersion(inputStream);
                if (n3 == 0) {
                    inputStream = null;
                    continue;
                }
                string = string6;
                iTaskMonitor2.incProgress(iTaskMonitor2.getProgressMax() - iTaskMonitor2.getProgress());
                break;
            }
        } else {
            iTaskMonitor.incProgress(1);
        }
        if (inputStream == null && !string.endsWith(string3) && !(exceptionArray[0] instanceof UrlOpener.CanceledByUserException)) {
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            string = string + string3;
            inputStream = this.fetchUrl(string, iTaskMonitor.createSubMonitor(1), exceptionArray);
            bl3 = true;
        } else {
            iTaskMonitor.incProgress(1);
        }
        if (inputStream != null) {
            iTaskMonitor.setDescription("Validate XML: %1$s", string);
            ITaskMonitor iTaskMonitor3 = iTaskMonitor.createSubMonitor(2);
            iTaskMonitor3.setProgressMax(2);
            for (int i = 0; i < 2; ++i) {
                int n4 = this.getXmlSchemaVersion(inputStream);
                if (n4 >= 1 && n4 <= this.getNsLatestVersion()) {
                    String string7 = this.validateXml(inputStream, string, n4, stringArray, booleanArray);
                    if (string7 != null) {
                        document = this.getDocument(inputStream, iTaskMonitor);
                        string2 = string7;
                        if (!bl3 || document == null) break;
                        iTaskMonitor.log("Repository found at %1$s", string);
                        this.mUrl = string;
                        break;
                    }
                    if (!booleanArray[0].equals(Boolean.FALSE)) break;
                    this.mFetchError = stringArray[0];
                    break;
                }
                if (n4 > this.getNsLatestVersion()) {
                    try {
                        document = this.findAlternateToolsXml(inputStream);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (document == null) break;
                    stringArray[0] = null;
                    string2 = this.getNsUri();
                    bl2 = true;
                    break;
                }
                if (n4 < 1 && i == 0 && !bl3) {
                    this.mFetchError = String.format("Failed to validate the XML for the repository at URL '%1$s'", string);
                    if (string.endsWith(string3)) break;
                    if (!string.endsWith("/")) {
                        string = string + "/";
                    }
                    string = string + string3;
                    inputStream = this.fetchUrl(string, iTaskMonitor3.createSubMonitor(1), null);
                    iTaskMonitor3.incProgress(1);
                    if (inputStream == null) break;
                } else {
                    if (n4 >= 1 || !bl3 || this.mFetchError != null) break;
                    this.mFetchError = String.format("Failed to validate the XML for the repository at URL '%1$s'", string);
                    break;
                }
                bl3 = true;
            }
        }
        if (exceptionArray[0] != null) {
            this.mFetchError = "Failed to fetch URL";
            String string8 = null;
            if (exceptionArray[0] instanceof FileNotFoundException) {
                string8 = "File not found";
                this.mFetchError = this.mFetchError + ": " + string8;
            } else if (exceptionArray[0] instanceof SSLKeyException) {
                string8 = "HTTPS SSL error. You might want to force download through HTTP in the settings.";
                this.mFetchError = this.mFetchError + ": HTTPS SSL error";
            } else {
                string8 = exceptionArray[0].getMessage() != null ? exceptionArray[0].getMessage() : String.format("Unknown (%1$s)", exceptionArray[0].getClass().getName());
            }
            iTaskMonitor.logError("Failed to fetch URL %1$s, reason: %2$s", string, string8);
        }
        if (stringArray[0] != null) {
            iTaskMonitor.logError("%s", stringArray[0]);
        }
        if (document == null) {
            return;
        }
        if (bl2) {
            Object object;
            boolean bl4 = false;
            try {
                object = Class.forName("com.crashlytics.reloc.com.android.ide.eclipse.adt.AdtPlugin");
                bl4 = object != null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (bl4) {
                object = "This repository requires a more recent version of ADT. Please update the Eclipse Android plugin.";
                this.mDescription = "This repository requires a more recent version of ADT, the Eclipse Android plugin.\nYou must update it before you can see other new packages.";
            } else {
                object = "This repository requires a more recent version of the Tools. Please update.";
                this.mDescription = "This repository requires a more recent version of the Tools.\nYou must update it before you can see other new packages.";
            }
            this.mFetchError = this.mFetchError == null ? object : this.mFetchError + ". " + (String)object;
        }
        iTaskMonitor.incProgress(1);
        if (inputStream != null) {
            iTaskMonitor.setDescription("Parse XML:    %1$s", string);
            iTaskMonitor.incProgress(1);
            this.parsePackages(document, string2, iTaskMonitor);
            this.mDescription = this.mPackages == null || this.mPackages.length == 0 ? this.mDescription + "\nNo packages found." : (this.mPackages.length == 1 ? this.mDescription + "\nOne package found." : this.mDescription + String.format("\n%1$d packages found.", this.mPackages.length));
        }
        iTaskMonitor.incProgress(1);
    }

    private void setDefaultDescription() {
        if (this.isAddonSource()) {
            String string = "";
            if (this.mUiName != null) {
                string = string + "Add-on Provider: " + this.mUiName;
                string = string + "\n";
            }
            this.mDescription = string = string + "Add-on URL: " + this.mUrl;
        } else {
            this.mDescription = String.format("SDK Source: %1$s", this.mUrl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream fetchUrl(String string, ITaskMonitor iTaskMonitor, Exception[] exceptionArray) {
        Object object;
        block12: {
            InputStream inputStream = null;
            int n = 65536;
            int n2 = 0;
            Object object2 = new byte[n];
            try {
                int n3;
                inputStream = UrlOpener.openUrl(string, iTaskMonitor);
                while ((n3 = inputStream.read((byte[])object2, n2, ((byte[])object2).length - n2)) != -1) {
                    if ((n2 += n3) != ((byte[])object2).length) continue;
                    object = new byte[n2 + n];
                    System.arraycopy(object2, 0, object, 0, n2);
                    object2 = object;
                }
                object = new ByteArrayInputStream((byte[])object2, 0, n2);
                if (inputStream == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    if (exceptionArray != null) {
                        exceptionArray[0] = exception;
                    }
                    return null;
                }
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return object;
    }

    protected String validateXml(InputStream inputStream, String string, int n, String[] stringArray, Boolean[] booleanArray) {
        if (inputStream == null) {
            return null;
        }
        try {
            Validator validator = this.getValidator(n);
            if (validator == null) {
                booleanArray[0] = Boolean.FALSE;
                stringArray[0] = String.format("XML verification failed for %1$s.\nNo suitable XML Schema Validator could be found in your Java environment. Please consider updating your version of Java.", string);
                return null;
            }
            booleanArray[0] = Boolean.TRUE;
            inputStream.reset();
            validator.validate(new StreamSource(inputStream));
            return this.getSchemaUri(n);
        }
        catch (SAXParseException sAXParseException) {
            stringArray[0] = String.format("XML verification failed for %1$s.\nLine %2$d:%3$d, Error: %4$s", string, sAXParseException.getLineNumber(), sAXParseException.getColumnNumber(), sAXParseException.toString());
        }
        catch (Exception exception) {
            stringArray[0] = String.format("XML verification failed for %1$s.\nError: %2$s", string, exception.toString());
        }
        return null;
    }

    protected int getXmlSchemaVersion(InputStream inputStream) {
        Object object;
        Object object2;
        if (inputStream == null) {
            return 0;
        }
        Node node = null;
        try {
            inputStream.reset();
            object2 = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object2).setIgnoringComments(false);
            ((DocumentBuilderFactory)object2).setValidating(false);
            ((DocumentBuilderFactory)object2).setNamespaceAware(false);
            object = ((DocumentBuilderFactory)object2).newDocumentBuilder();
            ((DocumentBuilder)object).setErrorHandler(new ErrorHandler(){

                public void warning(SAXParseException sAXParseException) throws SAXException {
                }

                public void fatalError(SAXParseException sAXParseException) throws SAXException {
                    throw sAXParseException;
                }

                public void error(SAXParseException sAXParseException) throws SAXException {
                    throw sAXParseException;
                }
            });
            node = ((DocumentBuilder)object).parse(inputStream);
            ((DocumentBuilderFactory)object2).setNamespaceAware(true);
            object = ((DocumentBuilderFactory)object2).newDocumentBuilder();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (node == null) {
            return 0;
        }
        object2 = Pattern.compile(this.getNsPattern());
        object = null;
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Matcher matcher;
            String string;
            Node node3;
            if (node2.getNodeType() != 1) continue;
            object = null;
            String string2 = node2.getNodeName();
            int n = string2.indexOf(58);
            if (n > 0 && n < string2.length() - 1) {
                object = string2.substring(0, n);
                string2 = string2.substring(n + 1);
            }
            if (!this.getRootElementName().equals(string2)) continue;
            NamedNodeMap namedNodeMap = node2.getAttributes();
            String string3 = "xmlns";
            if (object != null) {
                string3 = string3 + ":" + (String)object;
            }
            if ((node3 = namedNodeMap.getNamedItem(string3)) == null || (string = node3.getNodeValue()) == null || !(matcher = ((Pattern)object2).matcher(string)).matches()) continue;
            String string4 = matcher.group(1);
            try {
                return Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
        return 0;
    }

    private Validator getValidator(int n) throws SAXException {
        InputStream inputStream = this.getXsdStream(n);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        if (schemaFactory == null) {
            return null;
        }
        Schema schema = schemaFactory.newSchema(new StreamSource(inputStream));
        Validator validator = schema == null ? null : schema.newValidator();
        validator.setErrorHandler(new ErrorHandler(){

            public void warning(SAXParseException sAXParseException) throws SAXException {
            }

            public void fatalError(SAXParseException sAXParseException) throws SAXException {
                throw sAXParseException;
            }

            public void error(SAXParseException sAXParseException) throws SAXException {
                throw sAXParseException;
            }
        });
        return validator;
    }

    protected boolean parsePackages(Document document, String string, ITaskMonitor iTaskMonitor) {
        Node node = this.getFirstChild(document, string, this.getRootElementName());
        if (node != null) {
            Object object;
            Node node2;
            ArrayList<AddonPackage> arrayList = new ArrayList<AddonPackage>();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                if (node2.getNodeType() != 1 || !string.equals(node2.getNamespaceURI()) || !node2.getLocalName().equals("license") || (object = node2.getAttributes().getNamedItem("id")) == null) continue;
                hashMap.put(object.getNodeValue(), node2.getTextContent());
            }
            for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                if (node2.getNodeType() != 1 || !string.equals(node2.getNamespaceURI())) continue;
                object = node2.getLocalName();
                Package package_ = null;
                try {
                    if ("add-on".equals(object)) {
                        package_ = new AddonPackage(this, node2, string, hashMap);
                    } else if ("extra".equals(object)) {
                        package_ = new ExtraPackage(this, node2, string, hashMap);
                    } else if (!this.isAddonSource()) {
                        if ("platform".equals(object)) {
                            package_ = new PlatformPackage(this, node2, string, hashMap);
                        } else if ("doc".equals(object)) {
                            package_ = new DocPackage(this, node2, string, hashMap);
                        } else if ("tool".equals(object)) {
                            package_ = new ToolPackage(this, node2, string, hashMap);
                        } else if ("platform-tool".equals(object)) {
                            package_ = new PlatformToolPackage(this, node2, string, hashMap);
                        } else if ("sample".equals(object)) {
                            package_ = new SamplePackage(this, node2, string, hashMap);
                        } else if ("system-image".equals(object)) {
                            package_ = new SystemImagePackage(this, node2, string, hashMap);
                        } else if ("source".equals(object)) {
                            package_ = new SourcePackage(this, node2, string, hashMap);
                        }
                    }
                    if (package_ == null) continue;
                    arrayList.add((AddonPackage)package_);
                    iTaskMonitor.logVerbose("Found %1$s", package_.getShortDescription());
                    continue;
                }
                catch (Exception exception) {
                    iTaskMonitor.logError("Ignoring invalid %1$s element: %2$s", object, exception.toString());
                }
            }
            this.setPackages(arrayList.toArray(new Package[arrayList.size()]));
            return true;
        }
        return false;
    }

    private Node getFirstChild(Node node, String string, String string2) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1 || !string.equals(node2.getNamespaceURI()) || string2 != null && !node2.getLocalName().equals(string2)) continue;
            return node2;
        }
        return null;
    }

    protected Document getDocument(InputStream inputStream, ITaskMonitor iTaskMonitor) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringComments(true);
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            inputStream.reset();
            Document document = documentBuilder.parse(new InputSource(inputStream));
            return document;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            iTaskMonitor.logError("Failed to create XML document builder", new Object[0]);
        }
        catch (SAXException sAXException) {
            iTaskMonitor.logError("Failed to parse XML document", new Object[0]);
        }
        catch (IOException iOException) {
            iTaskMonitor.logError("Failed to read XML document", new Object[0]);
        }
        return null;
    }
}

