/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.api;

import org.json.simple.JSONObject;

public class Organization {
    private final String _id;
    private final String _alias;
    private final String _name;
    private final String _apiKey;
    private int _appCount;

    public Organization(String string, String string2, String string3, String string4, int n) {
        if (string2.isEmpty() || string3.isEmpty() || string4.isEmpty()) {
            throw new IllegalArgumentException("Unexpected empty parameter: " + string2 + ", " + string3 + ", " + string4);
        }
        this._id = string;
        this._alias = string2;
        this._name = string3;
        this._apiKey = string4;
        this._appCount = n;
    }

    public Organization(JSONObject jSONObject) {
        this((String)jSONObject.get("id"), (String)jSONObject.get("alias"), (String)jSONObject.get("name"), (String)jSONObject.get("api_key"), 0);
        int n = 0;
        JSONObject jSONObject2 = (JSONObject)jSONObject.get("apps_counts");
        for (Object v : jSONObject2.values()) {
            n += ((Number)v).intValue();
        }
        this._appCount = n;
    }

    public String getAlias() {
        return this._alias;
    }

    public String getName() {
        return this._name;
    }

    public String getApiKey() {
        return this._apiKey;
    }

    public int getAppCount() {
        return this._appCount;
    }

    public String getId() {
        return this._id;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this._alias == null ? 0 : this._alias.hashCode());
        n = 31 * n + (this._apiKey == null ? 0 : this._apiKey.hashCode());
        n = 31 * n + (this._name == null ? 0 : this._name.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Organization organization = (Organization)object;
        return this._alias.equals(organization._alias) && this._apiKey.equals(organization._apiKey) && this._name.equals(organization._name);
    }

    public String toString() {
        return this._name;
    }
}

