/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.api;

import com.crashlytics.api.App;
import com.crashlytics.api.Issue;
import com.crashlytics.api.Organization;
import com.crashlytics.api.Software;
import com.crashlytics.api.User;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.utils.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class WebApi {
    public static final String JSON_USER_EMAIL = "email";
    public static final String JSON_USER_NAME = "name";
    public static final String JSON_USER_PASSWORD = "password";
    public static final String JSON_SESSION_TOKEN = "token";
    public static final String JSON_ORGS_ARRAY = "organizations";
    public static final String JSON_ORG_ID = "id";
    public static final String JSON_ORG_ALIAS = "alias";
    public static final String JSON_ORG_APPS_COUNTS = "apps_counts";
    public static final String JSON_ORG_NAME = "name";
    public static final String JSON_ORG_API_KEY = "api_key";
    public static final String JSON_PLATFORM_ANDROID = "android";
    public static final String DEFAULT_BASE_API_URL = "https://api.crashlytics.com";
    public static final String URL_SIGNUP = "http://www.crashlytics.com";
    public static final String URL_FORGOT_PW = "http://www.crashlytics.com/accounts/password/new";
    public static final String URL_SECURITY = "http://crash.io/LKHyRj";
    public static final String MIME_TYPE_ZIP = "application/zip";
    public static final String MIME_TYPE_JSON = "application/json";
    private static final String DEV_TOKEN_HEADER = "X-CRASHLYTICS-DEVELOPER-TOKEN";
    private static final String ACCESS_TOKEN_HEADER = "X-CRASHLYTICS-ACCESS-TOKEN";
    private static final String DEV_TOKEN = "ed8fc3dc68a7475cc970eb1e9c0cb6603b0a3ea2";
    private static final String USER_TAG = "User";
    private static final String ORGS_TAG = "Orgs";
    private static final String JSON_FILE_EXTENSION = ".json";
    private static final String USER_AGENT_NAME = "User-Agent";
    public static final String PLATFORM_ANDROID = "android";
    private User _user = null;
    private final Map<Organization, List<App>> _appsCache;
    private final Map<App, List<Issue>> _issuesCache;
    private String _userAgent;
    private String _baseApiUrl;

    public WebApi() {
        this(DEFAULT_BASE_API_URL);
    }

    public WebApi(String string) {
        this._baseApiUrl = string;
        this._appsCache = new HashMap<Organization, List<App>>();
        this._issuesCache = new HashMap<App, List<Issue>>();
        this.loadUserFromCache();
    }

    public final void logout() {
        this.setUser(null);
        this.deleteFileInCache(USER_TAG);
        this._appsCache.clear();
    }

    public final synchronized boolean authenticateUser(String string, String string2) throws IOException {
        this.logout();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(DEV_TOKEN_HEADER, DEV_TOKEN);
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(JSON_USER_EMAIL, string);
        jSONObject.put(JSON_USER_PASSWORD, string2);
        String string3 = this.getBaseApiUrl() + "/api/v2/session.json";
        URI uRI = null;
        try {
            uRI = new URI(string3);
        }
        catch (URISyntaxException uRISyntaxException) {
            DeveloperTools.logE("bad URI: " + uRI, uRISyntaxException);
            return false;
        }
        JSONObject jSONObject2 = (JSONObject)this.postJSON(uRI, jSONObject, hashMap);
        if (jSONObject2 != null) {
            this.setUser(new User(jSONObject2));
            this.writeJSONToFile(USER_TAG, jSONObject2);
        }
        return this._user != null;
    }

    public void asyncAuthenticate(final String string, final String string2, final ApiCallback apiCallback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    WebApi.this.authenticateUser(string, string2);
                }
                catch (Exception exception) {
                    if (apiCallback != null) {
                        apiCallback.onAuthenticateException(WebApi.this, exception);
                    }
                    return;
                }
                if (apiCallback != null) {
                    apiCallback.onAuthenticated(WebApi.this, WebApi.this._user);
                }
            }
        }).start();
    }

    public final boolean authenticateWithToken(String string) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(DEV_TOKEN_HEADER, DEV_TOKEN);
        hashMap.put(ACCESS_TOKEN_HEADER, string);
        String string2 = this.getBaseApiUrl() + "/api/v2/session.json";
        URI uRI = null;
        try {
            uRI = new URI(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            DeveloperTools.logE("bad URI: " + uRI, uRISyntaxException);
            return false;
        }
        JSONObject jSONObject = (JSONObject)this.getJSON(uRI, hashMap);
        if (jSONObject != null) {
            this.setUser(new User(jSONObject));
        }
        return this._user != null;
    }

    public void asyncAuthenticateWithToken(final String string, final ApiCallback apiCallback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    WebApi.this.authenticateWithToken(string);
                }
                catch (Exception exception) {
                    if (apiCallback != null) {
                        apiCallback.onAuthenticateException(WebApi.this, exception);
                    }
                    return;
                }
                if (apiCallback != null) {
                    apiCallback.onAuthenticated(WebApi.this, WebApi.this._user);
                }
            }
        }).start();
    }

    public List<Organization> refreshOrganizations() throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(DEV_TOKEN_HEADER, DEV_TOKEN);
        hashMap.put(ACCESS_TOKEN_HEADER, this._user.getToken());
        String string = this.getBaseApiUrl() + "/api/v2/organizations.json";
        URI uRI = null;
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            DeveloperTools.logE("bad URI: " + uRI, uRISyntaxException);
            return null;
        }
        JSONArray jSONArray = (JSONArray)this.getJSON(uRI, hashMap);
        if (jSONArray != null) {
            LinkedList<Organization> linkedList = new LinkedList<Organization>();
            for (int i = 0; i < jSONArray.size(); ++i) {
                linkedList.add(new Organization((JSONObject)jSONArray.get(i)));
            }
            this._user.setOrgs(linkedList);
        }
        return this._user.getOrgs();
    }

    public void fetchApps(final Organization organization, final ApiCallback apiCallback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                List<App> list = null;
                try {
                    list = WebApi.this.getApps(organization, true);
                }
                catch (Exception exception) {
                    if (apiCallback != null) {
                        apiCallback.onAppException(WebApi.this, exception);
                    }
                    return;
                }
                if (apiCallback != null) {
                    apiCallback.onRetrievedApps(WebApi.this, list);
                }
            }
        }).start();
    }

    public List<App> getApps(Organization organization, boolean bl) throws IOException {
        if (bl) {
            this._appsCache.clear();
        }
        if (!this._appsCache.containsKey(organization)) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(DEV_TOKEN_HEADER, DEV_TOKEN);
            hashMap.put(ACCESS_TOKEN_HEADER, this._user.getToken());
            String string = this.getBaseApiUrl() + "/api/v2/organizations/" + organization.getId() + "/platforms/android/apps.json";
            URI uRI = null;
            try {
                uRI = new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                DeveloperTools.logE("bad URI: " + uRI, uRISyntaxException);
                return null;
            }
            JSONArray jSONArray = (JSONArray)this.getJSON(uRI, hashMap);
            if (jSONArray != null) {
                LinkedList<App> linkedList = new LinkedList<App>();
                for (int i = 0; i < jSONArray.size(); ++i) {
                    linkedList.add(new App((JSONObject)jSONArray.get(i), organization));
                }
                this._appsCache.put(organization, linkedList);
            }
        }
        return this._appsCache.containsKey(organization) ? Collections.unmodifiableList(this._appsCache.get(organization)) : Collections.EMPTY_LIST;
    }

    public List<Issue> getIssues(App app, boolean bl) throws IOException {
        if (bl) {
            this._issuesCache.clear();
        }
        if (!this._issuesCache.containsKey(app)) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(DEV_TOKEN_HEADER, DEV_TOKEN);
            hashMap.put(ACCESS_TOKEN_HEADER, this._user.getToken());
            String string = this.getBaseApiUrl() + "/api/v2/organizations/" + app.getOrganization().getId() + "/apps/" + app.getId() + "/issues.json";
            URI uRI = null;
            try {
                uRI = new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                DeveloperTools.logE("bad URI: " + uRI, uRISyntaxException);
                return null;
            }
            JSONArray jSONArray = (JSONArray)this.getJSON(uRI, hashMap);
            if (jSONArray != null) {
                LinkedList<Issue> linkedList = new LinkedList<Issue>();
                for (int i = 0; i < jSONArray.size(); ++i) {
                    linkedList.add(new Issue((JSONObject)jSONArray.get(i), app));
                }
                this._issuesCache.put(app, linkedList);
            }
        }
        return this._issuesCache.containsKey(app) ? Collections.unmodifiableList(this._issuesCache.get(app)) : Collections.EMPTY_LIST;
    }

    public boolean sendFile(URL uRL, File file, String string, String string2, Map<String, String> map) throws IOException {
        int n;
        Object object;
        DeveloperTools.logD("Sending file: " + file + " to URL: " + uRL);
        HttpPost httpPost = null;
        try {
            httpPost = new HttpPost(uRL.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
        MultipartEntity multipartEntity = new MultipartEntity();
        Object object2 = map.entrySet().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            multipartEntity.addPart(object.getKey(), new StringBody(object.getValue()));
        }
        multipartEntity.addPart(string2, new FileBody(file, string));
        httpPost.setEntity(multipartEntity);
        if (this._userAgent != null) {
            httpPost.setHeader(USER_AGENT_NAME, this._userAgent);
        }
        return (n = (object = (object2 = this.getClient()).execute(httpPost)).getStatusLine().getStatusCode()) >= 200 && n < 300;
    }

    public boolean downloadFile(URL uRL, File file) throws IOException {
        HttpGet httpGet;
        try {
            httpGet = new HttpGet(uRL.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
        httpGet.addHeader(DEV_TOKEN_HEADER, DEV_TOKEN);
        if (this._user != null) {
            httpGet.addHeader(ACCESS_TOKEN_HEADER, this._user.getToken());
        }
        HttpClient httpClient = this.getClient();
        DeveloperTools.logD("REQUEST: " + httpGet.getURI());
        HttpResponse httpResponse = httpClient.execute(httpGet);
        DeveloperTools.logD("RESPONSE: " + httpResponse.getStatusLine());
        if (httpResponse.getStatusLine().getStatusCode() == 200) {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            httpResponse.getEntity().writeTo(fileOutputStream);
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
            return true;
        }
        return false;
    }

    protected Object postJSON(URI uRI, JSONObject jSONObject, Map<String, String> map) throws IOException {
        HttpPost httpPost = new HttpPost(uRI);
        if (jSONObject != null) {
            ByteArrayEntity byteArrayEntity = new ByteArrayEntity(jSONObject.toString().getBytes());
            byteArrayEntity.setContentType(MIME_TYPE_JSON);
            httpPost.setEntity(byteArrayEntity);
        }
        return this.requestJSON(httpPost, jSONObject, map);
    }

    protected Object getJSON(URI uRI, Map<String, String> map) throws IOException {
        HttpGet httpGet = new HttpGet(uRI);
        return this.requestJSON(httpGet, null, map);
    }

    private Object requestJSON(HttpUriRequest httpUriRequest, JSONObject jSONObject, Map<String, String> map) throws IOException {
        if (this._userAgent != null) {
            httpUriRequest.setHeader(USER_AGENT_NAME, this._userAgent);
        }
        for (Map.Entry<String, String> object2 : map.entrySet()) {
            httpUriRequest.addHeader(object2.getKey(), object2.getValue().trim());
        }
        HttpClient httpClient = this.getClient();
        DeveloperTools.logD("REQUEST: " + httpUriRequest.getURI());
        HttpResponse httpResponse = httpClient.execute(httpUriRequest);
        int n = httpResponse.getStatusLine().getStatusCode();
        Object object = null;
        if (n >= 200 && n < 300) {
            object = JSONValue.parse(new InputStreamReader(httpResponse.getEntity().getContent()));
        }
        DeveloperTools.logD("RESPONSE: " + object);
        return object;
    }

    public Software getSoftwareIntegration(Organization organization, String string, String string2, String string3) throws IOException {
        return this.getSoftwareIntegration(organization.getApiKey(), string, string2, string3);
    }

    public Software getSoftwareIntegration(String string, String string2, String string3, String string4) throws IOException {
        URI uRI;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(DEV_TOKEN_HEADER, DEV_TOKEN);
        if (this._user != null) {
            hashMap.put(ACCESS_TOKEN_HEADER, this._user.getToken());
        }
        try {
            uRI = new URI(this._baseApiUrl + "/api/v2/keys/" + string + "/platforms/" + string2 + "/integrations/" + string3 + ".json?current_version=" + string4);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
        JSONObject jSONObject = (JSONObject)this.getJSON(uRI, hashMap);
        return jSONObject == null ? null : new Software(jSONObject);
    }

    public Software getAndroidSDK(Organization organization, String string) throws IOException {
        return this.getAndroidSDK(organization.getApiKey(), string);
    }

    public Software getAndroidSDK(String string, String string2) throws IOException {
        URI uRI;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(DEV_TOKEN_HEADER, DEV_TOKEN);
        if (this._user != null) {
            hashMap.put(ACCESS_TOKEN_HEADER, this._user.getToken());
        }
        try {
            uRI = new URI(this._baseApiUrl + "/api/v2/keys/" + string + "/platforms/" + "android" + "/sdks/com.crashlytics.android.json?current_version=" + string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
        JSONObject jSONObject = (JSONObject)this.getJSON(uRI, hashMap);
        return jSONObject == null ? null : new Software(jSONObject);
    }

    protected HttpClient getClient() {
        return new DefaultHttpClient();
    }

    public String getBaseApiUrl() {
        return this._baseApiUrl;
    }

    public User getCurrentUser() {
        return this._user;
    }

    private void setUser(User user) {
        this._user = user;
    }

    private void writeJSONToFile(String string, JSONObject jSONObject) {
        File file = new File(DeveloperTools.CRASHLYTICS_DATA_ROOT.getPath(), string + JSON_FILE_EXTENSION);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(jSONObject.toJSONString().getBytes());
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            DeveloperTools.logE("Could not write " + file, iOException);
        }
    }

    private void writeJSONToFile(String string, JSONArray jSONArray) {
        File file = new File(DeveloperTools.CRASHLYTICS_DATA_ROOT.getPath(), string + JSON_FILE_EXTENSION);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(jSONArray.toJSONString().getBytes());
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            DeveloperTools.logE("Could not write " + file, iOException);
        }
    }

    private void loadUserFromCache() {
        User user;
        JSONObject jSONObject = (JSONObject)this.loadFromCache(USER_TAG);
        if (jSONObject != null && (user = new User(jSONObject)) != null) {
            JSONArray jSONArray = (JSONArray)this.loadFromCache(ORGS_TAG);
            if (jSONArray != null) {
                LinkedList<Organization> linkedList = new LinkedList<Organization>();
                for (int i = 0; i < jSONArray.size(); ++i) {
                    linkedList.add(new Organization((JSONObject)jSONArray.get(i)));
                }
                user.setOrgs(linkedList);
            }
            this.setUser(user);
        }
    }

    private Object loadFromCache(String string) {
        File file = new File(DeveloperTools.CRASHLYTICS_DATA_ROOT.getPath(), string + JSON_FILE_EXTENSION);
        if (file.exists()) {
            try {
                String string2 = FileUtils.fileToString(file);
                return JSONValue.parse(string2);
            }
            catch (IOException iOException) {
                DeveloperTools.logE("Could not read cache file " + file, iOException);
            }
        }
        return null;
    }

    private void deleteFileInCache(String string) {
        File file = new File(DeveloperTools.CRASHLYTICS_DATA_ROOT.getPath(), string + JSON_FILE_EXTENSION);
        file.delete();
    }

    public void setUserAgent(String string) {
        this._userAgent = string;
    }

    public static enum AppStatus {
        CONFIGURED;

    }

    public static class ApiCallbackAdapter
    implements ApiCallback {
        @Override
        public void onAuthenticated(WebApi webApi, User user) {
        }

        @Override
        public void onRetrievedOrganizations(WebApi webApi, List<Organization> list) {
        }

        @Override
        public void onRetrievedApps(WebApi webApi, List<App> list) {
        }

        @Override
        public void onAuthenticateException(WebApi webApi, Exception exception) {
        }

        @Override
        public void onOrganizationException(WebApi webApi, Exception exception) {
        }

        @Override
        public void onAppException(WebApi webApi, Exception exception) {
        }
    }

    public static interface ApiCallback {
        public void onAuthenticated(WebApi var1, User var2);

        public void onAuthenticateException(WebApi var1, Exception var2);

        public void onRetrievedOrganizations(WebApi var1, List<Organization> var2);

        public void onOrganizationException(WebApi var1, Exception var2);

        public void onRetrievedApps(WebApi var1, List<App> var2);

        public void onAppException(WebApi var1, Exception var2);
    }
}

