/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android;

import com.crashlytics.api.WebApi;
import com.crashlytics.tools.android.project.DefaultAndroidProject;
import com.crashlytics.tools.android.project.DeobsUploader;
import java.io.File;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DeveloperTools {
    public static final String CRASHLYTICS_JAR = "crashlytics.jar";
    public static final File CRASHLYTICS_DATA_ROOT = new File(".crashlytics_data");
    private static org.apache.log4j.Logger l4jLogger;
    protected static final String OPT_HELP = "help";
    protected static final String OPT_UPDATE_BUILD_ID = "updateBuildId";
    protected static final String OPT_DELETE_STRINGS_FILE = "deleteStringsFile";
    protected static final String OPT_STORE_DEOBS = "storeDeobs";
    protected static final String OPT_STORE_DEOBS_ARG = "file";
    protected static final String OPT_OBFUSCATOR = "obfuscator";
    protected static final String OPT_OBFUSCATOR_ARG = "obfuscatorId";
    protected static final String OPT_OBFUSCATOR_VERSION = "obVer";
    protected static final String OPT_OBFUSCATOR_VERSION_ARG = "obfuscatorVersion";
    protected static final String OPT_UPLOAD_DEOBS = "uploadDeobs";
    protected static final String OPT_PATH = "projectPath";
    protected static final String OPT_PATH_ARG = "path";
    protected static final String OPT_VERBOSE = "verbose";
    protected static final String MANIFEST_API_KEY = "com.crashlytics.ApiKey";
    public static final String TEST_API_KEY = "testkey";
    public static final String STRINGS_API_KEY = "@string/api_key";
    public static final String LOCAL_DATA_SUBDIR = ".data";
    private static final Pattern HEX_PATTERN;
    private static Logger customLogger;
    private static WebApi sharedWebApi;

    public static WebApi getWebApi() {
        return sharedWebApi;
    }

    public static void setWebApi(WebApi webApi) {
        if (!"https://api.crashlytics.com".equals(webApi.getBaseApiUrl())) {
            DeveloperTools.logW("Crashlytics API host: " + webApi.getBaseApiUrl(), null);
        }
        sharedWebApi = webApi;
    }

    public static void setLogger(Logger logger) {
        customLogger = logger;
    }

    public static void logD(String string) {
        if (customLogger == null) {
            l4jLogger.debug(string);
        } else {
            customLogger.logD(string);
        }
    }

    public static void logI(String string) {
        if (customLogger == null) {
            l4jLogger.info(string);
        } else {
            customLogger.logI(string);
        }
    }

    public static void logW(String string, Throwable throwable) {
        if (customLogger == null) {
            l4jLogger.warn(string, throwable);
        } else {
            customLogger.logW(string, throwable);
        }
    }

    public static void logE(String string, Throwable throwable) {
        if (customLogger == null) {
            l4jLogger.error(string, throwable);
        } else {
            customLogger.logE(string, throwable);
        }
    }

    public static boolean isValidApiKeyFormat(String string) {
        if (string == null) {
            return false;
        }
        if (string.equals(TEST_API_KEY) || string.equals(STRINGS_API_KEY)) {
            DeveloperTools.logI("ApiKey is " + string);
            return true;
        }
        if (string.length() == 40) {
            return HEX_PATTERN.matcher(string).matches();
        }
        return false;
    }

    public static void main(String[] stringArray) {
        DeveloperTools.setWebApi(new WebApi());
        try {
            DeveloperTools.processArgs(stringArray);
        }
        catch (Exception exception) {
            DeveloperTools.logE("Crashlytics Developer Tools error.", exception);
            HelpFormatter helpFormatter = new HelpFormatter();
            Options options = DeveloperTools.createOptions();
            helpFormatter.printHelp(DeveloperTools.class.getName().toString(), options);
            System.exit(-1);
        }
    }

    public static void processArgs(String[] stringArray) throws Exception {
        Object object;
        GnuParser gnuParser = new GnuParser();
        Options options = DeveloperTools.createOptions();
        CommandLine commandLine = gnuParser.parse(options, stringArray);
        boolean bl = commandLine.hasOption(OPT_VERBOSE);
        if (bl) {
            // empty if block
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(string + " ");
        }
        DeveloperTools.logD("Invoked Crashlytics Developer Tools with arguments: " + stringBuilder.toString());
        if (commandLine.hasOption(OPT_HELP)) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp(DeveloperTools.class.getName().toString(), options);
            return;
        }
        if (!(commandLine.hasOption(OPT_UPDATE_BUILD_ID) || commandLine.hasOption(OPT_DELETE_STRINGS_FILE) || commandLine.hasOption(OPT_STORE_DEOBS) || commandLine.hasOption(OPT_UPLOAD_DEOBS))) {
            throw new IllegalArgumentException("Required argument(s) missing.");
        }
        String string = commandLine.getOptionValue(OPT_PATH, ".");
        DefaultAndroidProject defaultAndroidProject = new DefaultAndroidProject(new File(string));
        String string2 = defaultAndroidProject.getManifestData().getMetaData().get(MANIFEST_API_KEY);
        if (string2 == null || !DeveloperTools.isValidApiKeyFormat(string2)) {
            throw new IllegalArgumentException("Invalid apiKey: " + string2);
        }
        DeveloperTools.logD("apiKey is " + string2);
        if (commandLine.hasOption(OPT_UPDATE_BUILD_ID)) {
            DeveloperTools.logI("Updating build id");
            UUID uUID = defaultAndroidProject.updateBuildId();
            DeveloperTools.logD("Set build id to " + uUID);
        }
        if (commandLine.hasOption(OPT_DELETE_STRINGS_FILE)) {
            defaultAndroidProject.getResourceFile().delete();
        }
        if (commandLine.hasOption(OPT_STORE_DEOBS)) {
            File file = new File(commandLine.getOptionValue(OPT_STORE_DEOBS));
            if (!commandLine.hasOption(OPT_OBFUSCATOR) || !commandLine.hasOption(OPT_OBFUSCATOR_VERSION)) {
                throw new IllegalArgumentException("storeDeobs requires obfuscator and obVer");
            }
            object = commandLine.getOptionValue(OPT_OBFUSCATOR);
            String string3 = commandLine.getOptionValue(OPT_OBFUSCATOR_VERSION);
            DeveloperTools.logI("Saving deobfuscation file: " + file);
            defaultAndroidProject.storeDeobfuscationFile(file, (String)object, string3);
        }
        if (commandLine.hasOption(OPT_UPLOAD_DEOBS)) {
            boolean bl2 = defaultAndroidProject.hasCachedDeobfuscationFiles();
            object = new DeobsUploader(DeveloperTools.getWebApi());
            if (bl2) {
                boolean bl3 = ((DeobsUploader)object).uploadDeobfuscationFiles(defaultAndroidProject, string2);
                if (bl3) {
                    DeveloperTools.logI("Deobfuscation file(s) uploaded.");
                } else {
                    DeveloperTools.logW("Deobfuscation file upload FAILED - check network connectivity and try again", null);
                }
            }
        }
    }

    protected static Options createOptions() {
        Options options = new Options();
        Option option = new Option(OPT_UPDATE_BUILD_ID, "Update the Crashlytics-specific build ID for the project.");
        Option option2 = new Option(OPT_DELETE_STRINGS_FILE, "Delete the strings.xml file containing the build ID");
        OptionBuilder.withArgName(OPT_STORE_DEOBS_ARG);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Store the specified deobfuscation file in preparation for upload.");
        Option option3 = OptionBuilder.create(OPT_STORE_DEOBS);
        OptionBuilder.withArgName(OPT_OBFUSCATOR_ARG);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Optionally specify an obfuscator vendor identifier for use with storeDeobs [default=\"proguard\"].");
        Option option4 = OptionBuilder.create(OPT_OBFUSCATOR);
        OptionBuilder.withArgName(OPT_OBFUSCATOR_VERSION_ARG);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Optionally specify the obfuscator vendor software version for use with obfuscator [default=\"4.7\"].");
        Option option5 = OptionBuilder.create(OPT_OBFUSCATOR_VERSION);
        Option option6 = new Option(OPT_UPLOAD_DEOBS, "Attempt to upload deobfuscation file(s) to Crashlytics servers.");
        OptionBuilder.withArgName(OPT_PATH_ARG);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Path to Android project (location of AndroidManifest.xml)");
        Option option7 = OptionBuilder.create(OPT_PATH);
        Option option8 = new Option(OPT_VERBOSE, "Verbose output");
        Option option9 = new Option(OPT_HELP, "Display command help.");
        options.addOption(option);
        options.addOption(option2);
        options.addOption(option3);
        options.addOption(option4);
        options.addOption(option5);
        options.addOption(option6);
        options.addOption(option7);
        options.addOption(option8);
        options.addOption(option9);
        return options;
    }

    static {
        if (CRASHLYTICS_DATA_ROOT.isFile()) {
            throw new RuntimeException(CRASHLYTICS_DATA_ROOT.getAbsolutePath() + " is not a directory");
        }
        if (!CRASHLYTICS_DATA_ROOT.exists() && !CRASHLYTICS_DATA_ROOT.mkdir()) {
            throw new RuntimeException(CRASHLYTICS_DATA_ROOT.getAbsolutePath() + " could not be created.");
        }
        l4jLogger = org.apache.log4j.Logger.getLogger("com.crashlytics.tools.android");
        HEX_PATTERN = Pattern.compile("[0-9a-f]+");
    }

    public static interface Logger {
        public void logD(String var1);

        public void logI(String var1);

        public void logW(String var1, Throwable var2);

        public void logE(String var1, Throwable var2);
    }
}

