/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android;

import com.crashlytics.api.Software;
import com.crashlytics.api.WebApi;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.utils.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Comparator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipInputStream;

public class SDKManager {
    private static final String ATTRIBUTES_KEY = "com/crashlytics/android/";
    private static final String VERSION_ATTRIBUTE = "Specification-Version";
    private final File _sdksDir;
    private final File _defaultSdk;
    private final Lock _downloadInvocationLock = new ReentrantLock();
    private final ReadWriteLock _sdkLock = new ReentrantReadWriteLock();
    public static final Comparator<String> VERSION_STRING_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String string, String string2) {
            String[] stringArray = string.split("\\.", 4);
            String[] stringArray2 = string2.split("\\.", 4);
            for (int i = 0; i < 3; ++i) {
                int n;
                int n2 = Integer.parseInt(stringArray[i]);
                if (n2 < (n = Integer.parseInt(stringArray2[i]))) {
                    return -1;
                }
                if (n2 <= n) continue;
                return 1;
            }
            String string3 = stringArray.length > 3 ? stringArray[3] : "";
            String string4 = stringArray2.length > 3 ? stringArray2[3] : "";
            return string3.compareTo(string4);
        }
    };
    public static final Comparator<Manifest> VERSION_COMPARATOR = new Comparator<Manifest>(){

        @Override
        public int compare(Manifest manifest, Manifest manifest2) {
            return VERSION_STRING_COMPARATOR.compare(SDKManager.getVersion(manifest), SDKManager.getVersion(manifest2));
        }
    };

    public SDKManager(File file, InputStream inputStream) {
        Closeable closeable;
        this._sdksDir = new File(file, ".sdks");
        File file2 = new File(this._sdksDir, "default");
        file2.mkdirs();
        boolean bl = false;
        this._defaultSdk = new File(file2, "crashlytics.jar");
        Manifest manifest = null;
        try {
            if (this._defaultSdk.exists()) {
                manifest = new JarFile(this._defaultSdk).getManifest();
            }
        }
        catch (Exception exception) {
            DeveloperTools.logW("Could not read manifest from " + this._defaultSdk, exception);
        }
        if (manifest == null) {
            bl = true;
        } else {
            try {
                closeable = new JarInputStream(inputStream);
                bl = VERSION_COMPARATOR.compare(((JarInputStream)closeable).getManifest(), manifest) > 0;
                ((ZipInputStream)closeable).close();
            }
            catch (Exception exception) {
                DeveloperTools.logE("Could not read built in SDK", exception);
                bl = false;
            }
        }
        try {
            if (bl) {
                closeable = new FileOutputStream(this._defaultSdk, false);
                FileUtils.redirect(inputStream, (OutputStream)closeable);
                ((OutputStream)closeable).flush();
                ((FileOutputStream)closeable).close();
            }
        }
        catch (Exception exception) {
            DeveloperTools.logE("An error occurred creating the default SDK at " + this._defaultSdk, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateSdk(String string, File file) throws IOException {
        String string2 = null;
        if (file.exists()) {
            try {
                string2 = SDKManager.getVersion(new JarFile(file).getManifest());
            }
            catch (Exception exception) {
                DeveloperTools.logW("Exception while retrieving version from " + file + "; attempting to replace.", exception);
                string2 = null;
            }
        }
        this._sdkLock.readLock().lock();
        try {
            File file2 = this.getSdk(string);
            if (string2 == null || VERSION_STRING_COMPARATOR.compare(SDKManager.getVersion(new JarFile(file2).getManifest()), string2) > 0) {
                FileUtils.copyFile(file2, file);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this._sdkLock.readLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadUpdate(WebApi webApi, String string) throws IOException {
        this._downloadInvocationLock.lock();
        try {
            String string2 = SDKManager.getVersion(new JarFile(this.getSdk(string)).getManifest());
            Software software = webApi.getAndroidSDK(string, string2);
            if (software == null) {
                boolean bl = false;
                return bl;
            }
            File file = new File(this._sdksDir, string);
            File file2 = new File(file, "crashlytics.jar.dl");
            webApi.downloadFile(new URL(software.getDownloadUrl()), file2);
            try {
                this._sdkLock.writeLock().lock();
                FileUtils.copyFile(file2, new File(file, "crashlytics.jar"));
            }
            finally {
                try {
                    if (file2.exists()) {
                        file2.delete();
                    }
                }
                finally {
                    this._sdkLock.writeLock().unlock();
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this._downloadInvocationLock.unlock();
        }
    }

    private File getSdk(String string) {
        File file = new File(this._sdksDir, string + File.separator + "crashlytics.jar");
        if (file.exists()) {
            return file;
        }
        return this._defaultSdk;
    }

    public static String getVersion(Manifest manifest) {
        Attributes attributes = manifest.getAttributes(ATTRIBUTES_KEY);
        if (attributes != null) {
            return attributes.getValue(VERSION_ATTRIBUTE);
        }
        return null;
    }
}

