/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project;

import com.crashlytics.tools.android.project.DefaultManifestData;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

class DeobsMetadata {
    static final String DEOBS_EXTENSION = ".zip";
    static final String DEOBS_DATA_EXTENSION = ".meta";
    static final String PARAM_BUILD_ID = "resource[uuid]";
    static final String PARAM_DEOBS_FILE = "resource[file]";
    static final String PARAM_OBFUSCATOR_ID = "resource[vendor]";
    static final String PARAM_OBFUSCATOR_VERSION = "resource[vendor_version]";
    static final String PARAM_PACKAGE = "resource[bundle_identifier]";
    static final String PARAM_VERSION_CODE = "resource[version_number]";
    static final String PARAM_VERSION_NAME = "resource[short_version_number]";
    private String _buildId;
    private String _obfuscatorId = null;
    private String _obfuscatorVersion = null;
    private String _packageId = null;
    private int _versionCode = -1;
    private String _versionName = null;

    public DeobsMetadata() {
    }

    public DeobsMetadata(String string, File file) throws IOException {
        this._buildId = string;
        DefaultManifestData defaultManifestData = new DefaultManifestData(file);
        this._packageId = defaultManifestData.getPackage();
        this._versionCode = defaultManifestData.getVersionCode();
        this._versionName = defaultManifestData.getVersionName();
    }

    public Map<String, String> toMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this._buildId != null) {
            hashMap.put(PARAM_BUILD_ID, this._buildId);
        }
        if (this._obfuscatorId != null) {
            hashMap.put(PARAM_OBFUSCATOR_ID, this._obfuscatorId);
        }
        if (this._obfuscatorVersion != null) {
            hashMap.put(PARAM_OBFUSCATOR_VERSION, this._obfuscatorVersion);
        }
        if (this._packageId != null) {
            hashMap.put(PARAM_PACKAGE, this._packageId);
        }
        hashMap.put(PARAM_VERSION_CODE, Integer.toString(this._versionCode));
        if (this._versionName != null) {
            hashMap.put(PARAM_VERSION_NAME, this._versionName);
        }
        return hashMap;
    }

    public void load(File file) throws IOException {
        JSONParser jSONParser = new JSONParser();
        JSONObject jSONObject = null;
        try {
            jSONObject = (JSONObject)jSONParser.parse(new FileReader(file));
        }
        catch (ParseException parseException) {
            throw new IOException("Exception while parsing JSON file: " + file, parseException);
        }
        this._buildId = (String)jSONObject.get(PARAM_BUILD_ID);
        this._packageId = (String)jSONObject.get(PARAM_PACKAGE);
        this._versionCode = Integer.parseInt((String)jSONObject.get(PARAM_VERSION_CODE));
        this._versionName = (String)jSONObject.get(PARAM_VERSION_NAME);
        this._obfuscatorId = (String)jSONObject.get(PARAM_OBFUSCATOR_ID);
        this._obfuscatorVersion = (String)jSONObject.get(PARAM_OBFUSCATOR_VERSION);
    }

    public void store(File file) throws IOException {
        JSONObject jSONObject = new JSONObject();
        for (Map.Entry<String, String> entry : this.toMap().entrySet()) {
            jSONObject.put(entry.getKey(), entry.getValue());
        }
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(jSONObject.toJSONString());
        fileWriter.close();
    }

    public String getBuildId() {
        return this._buildId;
    }

    public void setBuildId(String string) {
        this._buildId = string;
    }

    public String getPackageId() {
        return this._packageId;
    }

    public void setPackageId(String string) {
        this._packageId = string;
    }

    public int getVersionCode() {
        return this._versionCode;
    }

    public void setVersionCode(int n) {
        this._versionCode = n;
    }

    public String getVersionName() {
        return this._versionName;
    }

    public void setVersionName(String string) {
        this._versionName = string;
    }

    public String getObfuscatorId() {
        return this._obfuscatorId;
    }

    public void setObfuscatorId(String string) {
        this._obfuscatorId = string;
    }

    public String getObfuscatorVersion() {
        return this._obfuscatorVersion;
    }

    public void setObfuscatorVersion(String string) {
        this._obfuscatorVersion = string;
    }
}

