/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ResourceFileManager {
    public static final String CRASHLYTICS_BUILDID_RESOURCE_FILENAME = "com_crashlytics_export_strings.xml";
    public static final String CRASHLYTICS_TOOLS_RESOURCE_FILENAME = "com_crashlytics_tools_strings.xml";
    public static final String RESOURCE_DIRECTORY = "res";
    public static final String VALUES_DIRECTORY = "values";
    public static final String BUILDID_RESOURCE_FILE_RELATIVE_PATH = "res" + File.separator + "values" + File.separator + "com_crashlytics_export_strings.xml";
    public static final String TOOLS_RESOURCE_FILE_RELATIVE_PATH = "res" + File.separator + "values" + File.separator + "com_crashlytics_tools_strings.xml";
    public static final String BUILD_ID_NAME = "com.crashlytics.android.build_id";
    public static final String BUILT_WITH_TOOLS_NAME = "com.crashlytics.android.builtWithTools";
    public static final String XML_STRING_TAG = "string";
    public static final String XML_NAME_ATTRIBUTE = "name";
    private final DocumentBuilder _docBuilder;
    private final File _resourceFile;

    public ResourceFileManager(File file, String string) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Invalid project path: " + file);
        }
        File file2 = new File(file, RESOURCE_DIRECTORY);
        if (!file2.isDirectory()) {
            throw new IllegalArgumentException("Invalid project path: " + file);
        }
        File file3 = new File(file2, VALUES_DIRECTORY);
        this._resourceFile = new File(file3, string);
        try {
            this._docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
    }

    protected File getResourceFile() {
        return this._resourceFile;
    }

    public boolean fileExists() {
        return this._resourceFile.exists() && this._resourceFile.isFile();
    }

    public void createEmptyResourceFile() throws IOException {
        File file = this._resourceFile.getParentFile();
        if (file.exists() && !file.isDirectory()) {
            throw new IOException("Could not create resource file, path is not a directory: " + file);
        }
        if (!file.exists() && !file.mkdir()) {
            throw new IOException("Could not create resource directory: " + file);
        }
        ResourceFileManager.writeInputStreamToFile(this.createEmptyResourceFileStream(), this._resourceFile);
    }

    protected InputStream createEmptyResourceFileStream() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        stringBuilder.append("<resources>\n");
        stringBuilder.append("<!--\n");
        stringBuilder.append("  This file is autogenerated by Crashlytics.\n");
        stringBuilder.append("  Do NOT modify, delete, or commit to source control!\n");
        stringBuilder.append("-->\n");
        stringBuilder.append("</resources>\n");
        return new ByteArrayInputStream(stringBuilder.toString().getBytes());
    }

    public UUID updateBuildId() {
        UUID uUID = UUID.randomUUID();
        try {
            InputStream inputStream = this.updateBuildId(new FileInputStream(this._resourceFile), uUID.toString());
            ResourceFileManager.writeInputStreamToFile(inputStream, this._resourceFile);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
        return uUID;
    }

    public UUID getBuildId() throws IOException {
        if (!this._resourceFile.exists()) {
            return null;
        }
        UUID uUID = null;
        try {
            Document document = this._docBuilder.parse(this._resourceFile);
            Element element = this.getBuildIdElement(document);
            if (element != null) {
                uUID = UUID.fromString(element.getTextContent());
            }
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException);
        }
        return uUID;
    }

    protected Element getBuildIdElement(Document document) {
        NodeList nodeList = document.getElementsByTagName(XML_STRING_TAG);
        Element element = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (!element2.hasAttribute(XML_NAME_ATTRIBUTE) || !element2.getAttribute(XML_NAME_ATTRIBUTE).equals(BUILD_ID_NAME)) continue;
            element = element2;
            break;
        }
        return element;
    }

    protected Element getBuiltWithToolsElement(Document document) {
        NodeList nodeList = document.getElementsByTagName(XML_STRING_TAG);
        Element element = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (!element2.hasAttribute(XML_NAME_ATTRIBUTE) || !element2.getAttribute(XML_NAME_ATTRIBUTE).equals(BUILT_WITH_TOOLS_NAME)) continue;
            element = element2;
            break;
        }
        return element;
    }

    public InputStream updateBuildId(InputStream inputStream, String string) throws SAXException, IOException {
        Object object;
        Document document = this._docBuilder.parse(inputStream);
        Element element = this.getBuildIdElement(document);
        if (element == null) {
            element = document.createElement(XML_STRING_TAG);
            element.setAttribute(XML_NAME_ATTRIBUTE, BUILD_ID_NAME);
            object = document.getFirstChild();
            object.appendChild(element);
        }
        element.setTextContent(string);
        object = null;
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult streamResult = new StreamResult(new StringWriter());
            DOMSource dOMSource = new DOMSource(document);
            transformer.transform(dOMSource, streamResult);
            object = new ByteArrayInputStream(streamResult.getWriter().toString().getBytes());
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            transformerConfigurationException.printStackTrace();
            throw new RuntimeException(transformerConfigurationException);
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            transformerFactoryConfigurationError.printStackTrace();
            throw new RuntimeException(transformerFactoryConfigurationError);
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
            throw new RuntimeException(transformerException);
        }
        return object;
    }

    public InputStream updateBuiltWithTools(InputStream inputStream, String string) throws SAXException, IOException {
        Object object;
        Document document = this._docBuilder.parse(inputStream);
        Element element = this.getBuiltWithToolsElement(document);
        if (element == null) {
            element = document.createElement(XML_STRING_TAG);
            element.setAttribute(XML_NAME_ATTRIBUTE, BUILT_WITH_TOOLS_NAME);
            object = document.getFirstChild();
            object.appendChild(element);
        }
        element.setTextContent(string);
        object = null;
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult streamResult = new StreamResult(new StringWriter());
            DOMSource dOMSource = new DOMSource(document);
            transformer.transform(dOMSource, streamResult);
            object = new ByteArrayInputStream(streamResult.getWriter().toString().getBytes());
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            transformerConfigurationException.printStackTrace();
            throw new RuntimeException(transformerConfigurationException);
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            transformerFactoryConfigurationError.printStackTrace();
            throw new RuntimeException(transformerFactoryConfigurationError);
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
            throw new RuntimeException(transformerException);
        }
        return object;
    }

    public static void writeInputStreamToFile(InputStream inputStream, File file) throws IOException {
        String string;
        if (!file.exists()) {
            file.createNewFile();
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        PrintWriter printWriter = new PrintWriter(file);
        while ((string = bufferedReader.readLine()) != null) {
            printWriter.println(string);
        }
        printWriter.close();
        bufferedReader.close();
    }
}

