/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.api;

import com.crashlytics.api.Organization;
import com.crashlytics.tools.android.DeveloperTools;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.json.simple.JSONObject;

public class App {
    private static final Object JSON_ID = "id";
    private static final String JSON_NAME = "name";
    private static final String JSON_BUNDLE_ID = "bundle_identifier";
    private static final String JSON_PLATFORM = "platform";
    private static final String JSON_STATUS = "status";
    private static final String JSON_IMPACTED_DEVICE_COUNT = "impacted_devices_count";
    private static final String JSON_UNRESOLVED_ISSUE_COUNT = "unresolved_issues_count";
    private static final String JSON_ICON64_URL = "icon64_url";
    private final String _id;
    private final String _name;
    private final String _bundleId;
    private final String _platform;
    private final String _icon64_url;
    private final int _impactedDeviceCount;
    private final int _unresolvedIssueCount;
    private final Organization _org;
    private final Status _status;
    Image _cachedIcon = null;

    private static Status statusFromString(String string) {
        try {
            return Status.valueOf(string.toUpperCase());
        }
        catch (Exception exception) {
            DeveloperTools.logE("Unknown status string: " + string, exception);
            return Status.UNKNOWN;
        }
    }

    public App(String string, String string2, String string3, String string4, String string5, int n, int n2, Organization organization, Status status) {
        if (string3 == null || string3.isEmpty()) {
            throw new IllegalArgumentException("Invalid bundleId: " + string3);
        }
        this._id = string;
        this._name = string2;
        this._bundleId = string3;
        this._platform = string4;
        this._icon64_url = string5;
        this._org = organization;
        this._status = status;
        this._impactedDeviceCount = n;
        this._unresolvedIssueCount = n2;
    }

    public App(JSONObject jSONObject, Organization organization) {
        this((String)jSONObject.get(JSON_ID), (String)jSONObject.get(JSON_NAME), (String)jSONObject.get(JSON_BUNDLE_ID), (String)jSONObject.get(JSON_PLATFORM), (String)jSONObject.get(JSON_ICON64_URL), ((Long)jSONObject.get(JSON_IMPACTED_DEVICE_COUNT)).intValue(), ((Long)jSONObject.get(JSON_UNRESOLVED_ISSUE_COUNT)).intValue(), organization, App.statusFromString((String)jSONObject.get(JSON_STATUS)));
    }

    public String getId() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public String getBundleIdForDisplay() {
        return this._bundleId;
    }

    public boolean bundleIdEquals(String string) {
        return this._bundleId.equalsIgnoreCase(string);
    }

    public String getPlatform() {
        return this._platform;
    }

    public String getIcon64URL() {
        return this._icon64_url;
    }

    public int getImpactedDeviceCount() {
        return this._impactedDeviceCount;
    }

    public int getUnresolvedIssueCount() {
        return this._unresolvedIssueCount;
    }

    public Organization getOrganization() {
        return this._org;
    }

    public Status getStatus() {
        return this._status;
    }

    public int hashCode() {
        return this._bundleId.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this._bundleId.equals(((App)object)._bundleId);
    }

    public String toString() {
        return this._bundleId + ":" + this._name;
    }

    public BufferedImage getIconImageOrNull() {
        BufferedImage bufferedImage = null;
        String string = this.getIcon64URL();
        try {
            if (!string.startsWith("http")) {
                string = DeveloperTools.getWebApi().getBaseApiUrl() + string;
            }
            bufferedImage = ImageIO.read(new URL(string));
        }
        catch (IOException iOException) {
            DeveloperTools.logE("Could not get image from " + string, iOException);
        }
        return bufferedImage;
    }

    public synchronized Image getCachedIconImageOrNull(int n, int n2) {
        if (this.getCachedIconImageOrNull() == null) {
            return null;
        }
        Image image = this._cachedIcon.getScaledInstance(n, n, n2);
        return image;
    }

    public synchronized Image getCachedIconImageOrNull() {
        if (this._cachedIcon == null) {
            this._cachedIcon = this.getIconImageOrNull();
        }
        return this._cachedIcon;
    }

    public static enum Status {
        ACTIVATED,
        CONFIGURED,
        NEW,
        DELETED,
        UNKNOWN;

    }
}

