/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android;

import com.crashlytics.api.Software;
import com.crashlytics.api.WebApi;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.FileBasedSDK;
import com.crashlytics.tools.android.PersistedSDK;
import com.crashlytics.tools.android.ReleaseNotesManager;
import com.crashlytics.tools.android.SDK;
import com.crashlytics.tools.android.SDKManager;
import com.crashlytics.tools.android.SDKManagerListener;
import com.crashlytics.tools.utils.JarUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class DefaultSDKManager
implements SDKManager {
    private static final Comparator<String> VERSION_STRING_COMPARATOR = JarUtils.VERSION_STRING_COMPARATOR;
    private final File _sdksDir;
    private final SDK _defaultSDK;
    private final List<SDKManagerListener> listeners = new ArrayList<SDKManagerListener>();
    private static ReleaseNotesManager _releaseNotesManager;

    public static DefaultSDKManager create(File file, SDK sDK, ReleaseNotesManager releaseNotesManager) {
        File file2 = new File(file, "default");
        file2.mkdirs();
        FileBasedSDK fileBasedSDK = new FileBasedSDK(new File(file2, "crashlytics.jar"));
        return new DefaultSDKManager(file, fileBasedSDK, sDK, releaseNotesManager);
    }

    public DefaultSDKManager(File file, PersistedSDK persistedSDK, SDK sDK, ReleaseNotesManager releaseNotesManager) {
        this._sdksDir = file;
        this._defaultSDK = persistedSDK;
        _releaseNotesManager = releaseNotesManager;
        boolean bl = this.isNotPresentOrOutdated(sDK);
        if (bl) {
            persistedSDK.replaceWith(sDK);
        }
    }

    private boolean isNotPresentOrOutdated(SDK sDK) {
        boolean bl = false;
        if (!this._defaultSDK.exists() || this._defaultSDK.getVersion() == null) {
            bl = true;
        } else {
            String string = this._defaultSDK.getVersion();
            String string2 = sDK.getVersion();
            bl = string2 == null ? false : VERSION_STRING_COMPARATOR.compare(string2, string) > 0;
        }
        return bl;
    }

    @Override
    public boolean copyCachedSDK(String string, PersistedSDK persistedSDK) throws IOException {
        String string2 = persistedSDK.getVersion();
        SDK sDK = this.getCachedSdk(string);
        String string3 = sDK.getVersion();
        if (string2 == null || VERSION_STRING_COMPARATOR.compare(string3, string2) > 0) {
            DeveloperTools.logD("Updating " + persistedSDK + " (" + string2 + " -> " + string3 + ")");
            persistedSDK.replaceWith(sDK);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateCachedSDK(WebApi webApi, String string) throws IOException {
        Software software;
        String string2 = this.getCachedSdk(string).getVersion();
        if (string2 == null) {
            DeveloperTools.logD("Unable to parse current SDK version, defaulting to " + string2);
            string2 = "0.0.0";
        }
        if ((software = webApi.getAndroidSDK(string, string2)) == null) {
            return false;
        }
        boolean bl = _releaseNotesManager.downloadReleaseNotes();
        if (!bl) {
            DeveloperTools.logW("Failed to download release notes during SDK update - propagating failure to entire download.", null);
            return false;
        }
        File file = new File(this._sdksDir, string);
        file.mkdirs();
        URL uRL = new URL(software.getDownloadUrl());
        File file2 = new File(file, "crashlytics.jar");
        boolean bl2 = webApi.downloadFile(uRL, file2);
        if (bl2 && _releaseNotesManager.commitDownloadedReleaseNotes()) {
            this.fireSdkDownloaded();
        }
        return bl2;
    }

    @Override
    public void dispose() {
    }

    private SDK getCachedSdk(String string) {
        File file = new File(this._sdksDir, string + File.separator + "crashlytics.jar");
        if (file.exists()) {
            return new FileBasedSDK(file);
        }
        return this._defaultSDK;
    }

    private void fireSdkDownloaded() {
        for (SDKManagerListener sDKManagerListener : this.getSDKManagerListeners()) {
            sDKManagerListener.onNewReleaseNotesAvailable();
        }
    }

    @Override
    public void addSDKManagerListener(SDKManagerListener sDKManagerListener) {
        if (sDKManagerListener != null) {
            this.listeners.add(sDKManagerListener);
        }
    }

    @Override
    public void removeSDKManagerListener(SDKManagerListener sDKManagerListener) {
        if (sDKManagerListener != null) {
            this.listeners.remove(sDKManagerListener);
        }
    }

    protected List<SDKManagerListener> getSDKManagerListeners() {
        return new ArrayList<SDKManagerListener>(this.listeners);
    }
}

