/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android;

import com.crashlytics.api.RestfulWebApi;
import com.crashlytics.api.WebApi;
import com.crashlytics.tools.android.project.AndroidProjectStructure;
import com.crashlytics.tools.android.project.DefaultAndroidProject;
import com.crashlytics.tools.android.project.DeobsUploader;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.log4j.PropertyConfigurator;

public class DeveloperTools {
    public static final String CRASHLYTICS_JAR = "crashlytics.jar";
    public static final File CRASHLYTICS_DATA_ROOT = DeveloperTools.getAppDataFolder();
    public static final String DEVELOPER_TOOLS_ROOT = "com.crashlytics.tools";
    public static final File CRASHLYTICS_PROJECTS_ROOT = new File(CRASHLYTICS_DATA_ROOT, "com.crashlytics.tools");
    private static Logger customLogger;
    protected static final String OPT_HELP = "help";
    public static final String OPT_GENERATE_RESOURCE_FILE = "generateResourceFile";
    public static final String OPT_CLEANUP_RESOURCE_FILE = "cleanupResourceFile";
    public static final String OPT_STORE_DEOBS = "storeDeobs";
    protected static final String OPT_STORE_DEOBS_ARG = "file";
    public static final String OPT_OBFUSCATOR = "obfuscator";
    protected static final String OPT_OBFUSCATOR_ARG = "obfuscatorId";
    public static final String OPT_OBFUSCATOR_VERSION = "obVer";
    protected static final String OPT_OBFUSCATOR_VERSION_ARG = "obfuscatorVersion";
    public static final String OPT_UPLOAD_DEOBS = "uploadDeobs";
    public static final String OPT_PATH = "projectPath";
    protected static final String OPT_PATH_ARG = "path";
    public static final String DEFAULT_PATH = ".";
    public static final String OPT_MANIFEST_PATH = "androidManifest";
    protected static final String OPT_MANIFEST_PATH_ARG = "androidManifestPath";
    public static final String OPT_RES_PATH = "androidRes";
    protected static final String OPT_RES_PATH_ARG = "androidResPath";
    public static final String OPT_VERBOSE = "verbose";
    public static final String OPT_QUIET = "quiet";
    protected static final String MANIFEST_API_KEY = "com.crashlytics.ApiKey";
    public static final String TEST_API_KEY = "testkey";
    public static final String STRINGS_API_KEY = "@string/api_key";
    public static final String LOCAL_DATA_SUBDIR = ".data";
    private static final Pattern HEX_PATTERN;
    private static WebApi sharedWebApi;

    private static File getAppDataFolder() {
        String string = System.getProperty("os.name").toUpperCase();
        String string2 = string.contains("MAC") ? "Library/Caches/com.crashlytics" : ".crashlytics";
        return new File(System.getProperty("user.home"), string2);
    }

    public static org.apache.log4j.Logger configurel4jLogger(File file) {
        System.setProperty("crashlytics.logger.home", new File(file.getAbsolutePath(), "crashlytics.log").getAbsolutePath());
        Properties properties = new Properties();
        try {
            properties.load(DeveloperTools.class.getClassLoader().getResourceAsStream("log4j.fileappender.properties"));
            PropertyConfigurator.configure(properties);
        }
        catch (IOException iOException) {
            System.err.println("Logger properties could not be intialized.");
            iOException.printStackTrace(System.err);
        }
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger("com.crashlytics");
        return logger;
    }

    public static WebApi getWebApi() {
        return sharedWebApi;
    }

    public static void setWebApi(WebApi webApi) {
        if (!"https://api.crashlytics.com".equals(webApi.getBaseApiUrl())) {
            DeveloperTools.logW("Crashlytics API host: " + webApi.getBaseApiUrl(), null);
        }
        sharedWebApi = webApi;
    }

    public static void setLogger(Logger logger) {
        customLogger = logger;
    }

    public static void logD(String string) {
        customLogger.logD(string);
    }

    public static void logI(String string) {
        customLogger.logI(string);
    }

    public static void logW(String string, Throwable throwable) {
        customLogger.logW(string, throwable);
    }

    public static void logE(String string, Throwable throwable) {
        customLogger.logE(string, throwable);
    }

    public static void logStackW(String string) {
        DeveloperTools.logW(string + "\n" + DeveloperTools.currentStackAsString(3), null);
    }

    public static void logStackE(String string) {
        DeveloperTools.logE(string + "\n" + DeveloperTools.currentStackAsString(3), null);
    }

    private static StringBuffer currentStackAsString(int n) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i < stackTraceElementArray.length; ++i) {
            stringBuffer.append("\t" + stackTraceElementArray[i] + "\n");
        }
        return stringBuffer;
    }

    public static boolean isValidApiKeyFormat(String string) {
        if (string == null) {
            return false;
        }
        if (string.equals(TEST_API_KEY) || string.equals(STRINGS_API_KEY)) {
            DeveloperTools.logD("ApiKey is " + string);
            return true;
        }
        if (string.length() == 40) {
            return HEX_PATTERN.matcher(string).matches();
        }
        return false;
    }

    public static void main(String[] stringArray) {
        try {
            Properties properties = new Properties();
            properties.load(DeveloperTools.class.getClassLoader().getResourceAsStream("log4j.properties"));
            PropertyConfigurator.configure(properties);
        }
        catch (Exception exception) {
            System.err.println("Logger properties could not be intialized, continuing with default logger.");
            exception.printStackTrace(System.err);
        }
        DeveloperTools.processArgsSafe(stringArray);
    }

    public static void processArgsSafe(String[] stringArray) {
        org.apache.log4j.Logger logger = DeveloperTools.configurel4jLogger(CRASHLYTICS_PROJECTS_ROOT);
        DeveloperTools.setLogger(new L4JWrappedLogger(logger));
        try {
            DeveloperTools.processArgs(stringArray);
        }
        catch (Exception exception) {
            DeveloperTools.logE("Crashlytics Developer Tools error.", exception);
            HelpFormatter helpFormatter = new HelpFormatter();
            Options options = DeveloperTools.createOptions();
            helpFormatter.printHelp(DeveloperTools.class.getName().toString(), options);
            System.exit(-1);
        }
    }

    public static void processArgs(String[] stringArray) throws Exception {
        Object object;
        Comparable<UUID> bl;
        File file;
        File file2;
        Object object2;
        DeveloperTools.setWebApi(new RestfulWebApi());
        Options options = DeveloperTools.createOptions();
        GnuParser gnuParser = new GnuParser();
        CommandLine commandLine = gnuParser.parse(options, stringArray);
        StringBuilder stringBuilder = new StringBuilder();
        for (String object32 : stringArray) {
            stringBuilder.append(object32 + " ");
        }
        DeveloperTools.logD("Invoked Crashlytics Developer Tools with arguments: " + stringBuilder.toString());
        if (commandLine.hasOption(OPT_HELP)) {
            object2 = new HelpFormatter();
            ((HelpFormatter)object2).printHelp(DeveloperTools.class.getName().toString(), options);
            return;
        }
        if (!(commandLine.hasOption(OPT_GENERATE_RESOURCE_FILE) || commandLine.hasOption(OPT_CLEANUP_RESOURCE_FILE) || commandLine.hasOption(OPT_STORE_DEOBS) || commandLine.hasOption(OPT_UPLOAD_DEOBS))) {
            throw new IllegalArgumentException("Required argument(s) missing.");
        }
        object2 = new File(commandLine.getOptionValue(OPT_PATH, DEFAULT_PATH));
        AndroidProjectStructure androidProjectStructure = new AndroidProjectStructure((File)object2, file2 = commandLine.hasOption(OPT_MANIFEST_PATH) ? new File(commandLine.getOptionValue(OPT_MANIFEST_PATH)) : new File((File)object2, "AndroidManifest.xml"), file = commandLine.hasOption(OPT_RES_PATH) ? new File(commandLine.getOptionValue(OPT_RES_PATH)) : new File((File)object2, "res"));
        DefaultAndroidProject defaultAndroidProject = new DefaultAndroidProject(androidProjectStructure);
        String string = defaultAndroidProject.getManifestData().getMetaData().get(MANIFEST_API_KEY);
        if (string == null || !DeveloperTools.isValidApiKeyFormat(string)) {
            throw new IllegalArgumentException("Invalid API key: " + string + ". Check the Crashlytics plugin to make sure that the application has been added successfully! Contact support@crashlytics.com for assistance.");
        }
        DeveloperTools.logD("apiKey is " + string);
        if (commandLine.hasOption(OPT_GENERATE_RESOURCE_FILE)) {
            DeveloperTools.logI("Generating Crashlytics Resources");
            bl = defaultAndroidProject.updateBuildId();
            DeveloperTools.logD("Set build id to " + bl);
        }
        if (commandLine.hasOption(OPT_CLEANUP_RESOURCE_FILE)) {
            DeveloperTools.logI("Cleaning Crashlytics Resources");
            defaultAndroidProject.removeBuildResource();
        }
        if (commandLine.hasOption(OPT_STORE_DEOBS)) {
            DeveloperTools.logI("Caching deobfuscation file");
            bl = new File(commandLine.getOptionValue(OPT_STORE_DEOBS));
            if (!commandLine.hasOption(OPT_OBFUSCATOR) || !commandLine.hasOption(OPT_OBFUSCATOR_VERSION)) {
                throw new IllegalArgumentException("storeDeobs requires obfuscator and obVer");
            }
            object = commandLine.getOptionValue(OPT_OBFUSCATOR);
            String bl2 = commandLine.getOptionValue(OPT_OBFUSCATOR_VERSION);
            DeveloperTools.logI("Saving deobfuscation file: " + bl);
            defaultAndroidProject.storeDeobfuscationFile((File)bl, (String)object, bl2);
        }
        if (commandLine.hasOption(OPT_UPLOAD_DEOBS)) {
            DeveloperTools.logI("Uploading deobfuscation file");
            boolean bl2 = defaultAndroidProject.hasCachedDeobfuscationFiles();
            object = new DeobsUploader(DeveloperTools.getWebApi());
            if (bl2) {
                boolean bl3 = ((DeobsUploader)object).uploadDeobfuscationFiles(defaultAndroidProject, string);
                if (bl3) {
                    DeveloperTools.logI("Deobfuscation file(s) uploaded.");
                } else {
                    DeveloperTools.logW("Deobfuscation file upload FAILED - check network connectivity and try again", null);
                }
            }
        }
    }

    protected static Options createOptions() {
        Options options = new Options();
        Option option = new Option(OPT_GENERATE_RESOURCE_FILE, "Generate Crashlytics-required resources for the project.");
        Option option2 = new Option(OPT_CLEANUP_RESOURCE_FILE, "Remove Crashlytics-generated resource files");
        OptionBuilder.withArgName(OPT_STORE_DEOBS_ARG);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Store the specified deobfuscation file in preparation for upload.");
        Option option3 = OptionBuilder.create(OPT_STORE_DEOBS);
        OptionBuilder.withArgName(OPT_OBFUSCATOR_ARG);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Optionally specify an obfuscator vendor identifier for use with storeDeobs.");
        Option option4 = OptionBuilder.create(OPT_OBFUSCATOR);
        OptionBuilder.withArgName(OPT_OBFUSCATOR_VERSION_ARG);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Optionally specify the obfuscator vendor software version for use with obfuscator.");
        Option option5 = OptionBuilder.create(OPT_OBFUSCATOR_VERSION);
        Option option6 = new Option(OPT_UPLOAD_DEOBS, "Attempt to upload deobfuscation file(s) to Crashlytics servers.");
        OptionBuilder.withArgName(OPT_PATH_ARG);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Path to Android project root");
        Option option7 = OptionBuilder.create(OPT_PATH);
        OptionBuilder.withArgName(OPT_MANIFEST_PATH_ARG);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Path to AndroidManifest.xml)");
        Option option8 = OptionBuilder.create(OPT_MANIFEST_PATH);
        OptionBuilder.withArgName(OPT_RES_PATH_ARG);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Path to Android resources (res/ folder)");
        Option option9 = OptionBuilder.create(OPT_RES_PATH);
        Option option10 = new Option(OPT_VERBOSE, "Verbose command line output");
        Option option11 = new Option(OPT_QUIET, "Silent command line output");
        Option option12 = new Option(OPT_HELP, "Display command help.");
        options.addOption(option);
        options.addOption(option2);
        options.addOption(option3);
        options.addOption(option4);
        options.addOption(option5);
        options.addOption(option6);
        options.addOption(option7);
        options.addOption(option8);
        options.addOption(option11);
        options.addOption(option9);
        options.addOption(option10);
        options.addOption(option12);
        return options;
    }

    static {
        if (CRASHLYTICS_DATA_ROOT.isFile()) {
            throw new RuntimeException("Crashlytics data directory at " + CRASHLYTICS_DATA_ROOT.getAbsolutePath() + " is not a directory");
        }
        if (!CRASHLYTICS_DATA_ROOT.exists() && !CRASHLYTICS_DATA_ROOT.mkdir()) {
            throw new RuntimeException("Crashlytics data directory at " + CRASHLYTICS_DATA_ROOT.getAbsolutePath() + " could not be created.");
        }
        customLogger = new StdOutLogger();
        HEX_PATTERN = Pattern.compile("[0-9a-f]+");
    }

    public static class StdOutLogger
    implements Logger {
        @Override
        public synchronized void logD(String string) {
            System.out.println("[CLSLOG DEBUG] " + string);
        }

        @Override
        public synchronized void logI(String string) {
            System.out.println("[CLSLOG INFO] " + string);
        }

        @Override
        public synchronized void logW(String string, Throwable throwable) {
            System.out.println("[CLSLOG WARN] " + string);
            if (throwable != null) {
                System.err.println(throwable);
                throwable.printStackTrace();
            }
        }

        @Override
        public synchronized void logE(String string, Throwable throwable) {
            System.err.println("[CLSLOG ERR] " + string);
            if (throwable != null) {
                System.err.println(throwable);
                throwable.printStackTrace();
            }
        }
    }

    public static class L4JWrappedLogger
    implements Logger {
        private final org.apache.log4j.Logger _logger;

        public L4JWrappedLogger(org.apache.log4j.Logger logger) {
            this._logger = logger;
        }

        @Override
        public synchronized void logD(String string) {
            this._logger.debug(string);
        }

        @Override
        public synchronized void logI(String string) {
            this._logger.info(string);
        }

        @Override
        public synchronized void logW(String string, Throwable throwable) {
            this._logger.warn(string, throwable);
        }

        @Override
        public synchronized void logE(String string, Throwable throwable) {
            this._logger.error(string, throwable);
        }
    }

    public static class MultiLogger
    implements Logger {
        private final Logger[] _loggers;

        public MultiLogger(Logger ... loggerArray) {
            this._loggers = loggerArray;
        }

        @Override
        public synchronized void logD(String string) {
            for (Logger logger : this._loggers) {
                logger.logD(string);
            }
        }

        @Override
        public synchronized void logI(String string) {
            for (Logger logger : this._loggers) {
                logger.logI(string);
            }
        }

        @Override
        public synchronized void logW(String string, Throwable throwable) {
            for (Logger logger : this._loggers) {
                logger.logW(string, throwable);
            }
        }

        @Override
        public synchronized void logE(String string, Throwable throwable) {
            for (Logger logger : this._loggers) {
                logger.logE(string, throwable);
            }
        }
    }

    public static interface Logger {
        public void logD(String var1);

        public void logI(String var1);

        public void logW(String var1, Throwable var2);

        public void logE(String var1, Throwable var2);
    }
}

