/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android;

import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.PersistedSDK;
import com.crashlytics.tools.android.SDK;
import com.crashlytics.tools.utils.FileUtils;
import com.crashlytics.tools.utils.JarUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Manifest;

public class FileBasedSDK
implements PersistedSDK {
    private File _location;

    public FileBasedSDK(File file) {
        this._location = file;
    }

    @Override
    public boolean exists() {
        return this._location != null && this._location.exists();
    }

    public String toString() {
        if (this._location != null) {
            return String.format("SDK File:( %s )", this._location.getAbsolutePath());
        }
        return String.format("SDK File:( empty )", new Object[0]);
    }

    @Override
    public File getLocation() {
        return this._location;
    }

    @Override
    public String getVersion() {
        if (this._location == null) {
            return null;
        }
        Manifest manifest = JarUtils.getMaybeManifest(this._location);
        if (manifest == null) {
            return null;
        }
        return JarUtils.getVersion(manifest, "com/crashlytics/android/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceWith(SDK sDK) {
        if (sDK.exists()) {
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(this._location, false);
                FileUtils.redirect(sDK.getStream(), fileOutputStream);
                fileOutputStream.flush();
                this.closeIfNonNull(fileOutputStream, "SDK Stream");
            }
            catch (Exception exception) {
                try {
                    DeveloperTools.logE("An error occurred creating the default SDK at " + this._location, exception);
                    this.closeIfNonNull(fileOutputStream, "SDK Stream");
                }
                catch (Throwable throwable) {
                    this.closeIfNonNull(fileOutputStream, "SDK Stream");
                    throw throwable;
                }
            }
        } else {
            DeveloperTools.logI("Crashlytics could not replace an SDK with an empty one.");
        }
    }

    private void closeIfNonNull(Closeable closeable, String string) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                DeveloperTools.logE("Could not close " + string, iOException);
            }
        }
    }

    @Override
    public InputStream getStream() {
        try {
            return new FileInputStream(this._location);
        }
        catch (FileNotFoundException fileNotFoundException) {
            DeveloperTools.logE("Crashlytics could not create a file stream for an sdk.", fileNotFoundException);
            return null;
        }
    }
}

