/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android;

import com.crashlytics.api.WebApi;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.PersistedSDK;
import com.crashlytics.tools.android.SDKManager;
import com.crashlytics.tools.android.SDKManagerListener;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class ThreadedSDKManager
implements SDKManager {
    private final ScheduledExecutorService _sdkExecutor = Executors.newSingleThreadScheduledExecutor();
    private final SDKManager _manager;

    public ThreadedSDKManager(SDKManager sDKManager) {
        this._manager = sDKManager;
    }

    @Override
    public boolean copyCachedSDK(final String string, final PersistedSDK persistedSDK) throws IOException {
        try {
            return this._sdkExecutor.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return ThreadedSDKManager.this._manager.copyCachedSDK(string, persistedSDK);
                }
            }).get();
        }
        catch (InterruptedException interruptedException) {
            DeveloperTools.logE("Crashlytics was interrupted during its update of the SDK for api key " + string, interruptedException);
        }
        catch (ExecutionException executionException) {
            DeveloperTools.logE("Crashlytics execution failed during its update of the SDK for api key " + string, executionException);
        }
        return false;
    }

    @Override
    public boolean updateCachedSDK(final WebApi webApi, final String string) throws IOException {
        try {
            return this._sdkExecutor.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return ThreadedSDKManager.this._manager.updateCachedSDK(webApi, string);
                }
            }).get();
        }
        catch (InterruptedException interruptedException) {
            DeveloperTools.logE("Crashlytics was interrupted during its update of the SDK for api key " + string, interruptedException);
        }
        catch (ExecutionException executionException) {
            DeveloperTools.logE("Crashlytics execution failed during its update of the SDK for api key " + string, executionException);
        }
        return false;
    }

    @Override
    public void dispose() {
        DeveloperTools.logD("Crashlytics is shutting down the SDK...");
        this._sdkExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ThreadedSDKManager.this._manager.dispose();
            }
        });
        this._sdkExecutor.shutdown();
    }

    @Override
    public void addSDKManagerListener(final SDKManagerListener sDKManagerListener) {
        try {
            this._sdkExecutor.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ThreadedSDKManager.this._manager.addSDKManagerListener(sDKManagerListener);
                    return null;
                }
            }).get();
        }
        catch (InterruptedException interruptedException) {
            DeveloperTools.logE("Crashlytics was interrupted during adding a listener to the SDK manager", interruptedException);
        }
        catch (ExecutionException executionException) {
            DeveloperTools.logE("Crashlytics execution failed during adding a listener to the SDK manager", executionException);
        }
    }

    @Override
    public void removeSDKManagerListener(final SDKManagerListener sDKManagerListener) {
        try {
            this._sdkExecutor.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ThreadedSDKManager.this._manager.removeSDKManagerListener(sDKManagerListener);
                    return null;
                }
            }).get();
        }
        catch (InterruptedException interruptedException) {
            DeveloperTools.logE("Crashlytics was interrupted during removal a listener to of the SDK manager", interruptedException);
        }
        catch (ExecutionException executionException) {
            DeveloperTools.logE("Crashlytics execution failed during removal a listener to of the SDK manager", executionException);
        }
    }
}

