/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project;

import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.project.AndroidProject;
import com.crashlytics.tools.android.project.AndroidProjectStructure;
import com.crashlytics.tools.android.project.DefaultManifestData;
import com.crashlytics.tools.android.project.DeobsMetadata;
import com.crashlytics.tools.android.project.ManifestData;
import com.crashlytics.tools.android.project.ResourceFileManager;
import com.crashlytics.tools.android.project.ResourceManager;
import com.crashlytics.tools.utils.FileUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;

public class DefaultAndroidProject
implements AndroidProject {
    static final String OBFUSCATOR_ID_PROGUARD = "proguard";
    private static final String DEOBS_SUBDIR = "deobs";
    private final File _dataPath;
    private final File _deobsPath;
    private final ManifestData _manifestData;
    private final File _manifestFile;
    private final ResourceManager _resourceManager;
    protected static final FilenameFilter DEOBS_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File file, String string) {
            return string.toLowerCase().endsWith(".zip");
        }
    };

    public static AndroidProjectStructure createDefaultStructure(File file) {
        return DefaultAndroidProject.createStructure(file, "AndroidManifest.xml", "res");
    }

    public static AndroidProjectStructure createStructure(File file, String string, String string2) {
        return new AndroidProjectStructure(file, new File(file, string), new File(file, string2));
    }

    public DefaultAndroidProject(AndroidProjectStructure androidProjectStructure) throws IOException {
        this(androidProjectStructure, new ResourceFileManager(androidProjectStructure.getResourceDir()));
    }

    public DefaultAndroidProject(AndroidProjectStructure androidProjectStructure, ResourceManager resourceManager) throws IOException {
        this(androidProjectStructure, DefaultAndroidProject.getProjectDataPath(androidProjectStructure), resourceManager);
    }

    protected static File getProjectDataPath(AndroidProjectStructure androidProjectStructure) throws IOException {
        File file = new File(DeveloperTools.CRASHLYTICS_PROJECTS_ROOT, FileUtils.getIdentifier(androidProjectStructure.getProjectRootDir()));
        FileUtils.verifyDirectory(file);
        return file;
    }

    public DefaultAndroidProject(AndroidProjectStructure androidProjectStructure, File file, ResourceManager resourceManager) throws IOException {
        File file2 = androidProjectStructure.getProjectRootDir();
        if (!file2.exists() || !file2.isDirectory()) {
            throw new IllegalArgumentException("Project path is not a directory: " + file2);
        }
        this._manifestFile = androidProjectStructure.getManifestFile();
        this._manifestData = DefaultManifestData.createManifest(this._manifestFile);
        this._resourceManager = resourceManager;
        this._dataPath = file;
        this._deobsPath = new File(this._dataPath, DEOBS_SUBDIR);
    }

    protected synchronized void createDataDir() throws IOException {
        FileUtils.verifyDirectory(this._dataPath);
    }

    @Override
    public File getManifestFile() {
        return this._manifestFile;
    }

    @Override
    public ManifestData getManifestData() {
        return this._manifestData;
    }

    @Override
    public File getLauncherIcon() {
        return this._manifestData.getLauncherIcon();
    }

    @Override
    public UUID updateBuildId() throws IOException {
        if (!this._resourceManager.fileExists()) {
            this._resourceManager.createEmptyResourceFile();
        }
        UUID uUID = this._resourceManager.updateBuildId();
        return uUID;
    }

    @Override
    public UUID getBuildId() throws IOException {
        return this._resourceManager.getBuildId();
    }

    @Override
    public File getDataDirectory() {
        return this._dataPath;
    }

    @Override
    public void storeDeobfuscationFile(File file, String string, String string2) throws IOException {
        Object object;
        if (!file.isFile()) {
            throw new IllegalArgumentException("Invalid deobfuscation file: " + file);
        }
        this.createDataDir();
        FileUtils.verifyDirectory(this._deobsPath);
        UUID uUID = this._resourceManager.getBuildId();
        File file2 = new File(this._deobsPath, uUID.toString() + ".zip");
        if (file2.exists()) {
            throw new IllegalStateException("Destination file exists: " + file2);
        }
        if (file.getName().equals("mapping.txt")) {
            FileUtils.zip(file, file2, false);
        } else {
            object = new File(this._deobsPath, "mapping.txt");
            DeveloperTools.logI("Copying deobs file (" + file + ") to " + object);
            FileUtils.copyFile(file, (File)object);
            FileUtils.zip((File)object, file2, false);
            ((File)object).delete();
        }
        object = new DeobsMetadata(uUID.toString(), this._manifestFile);
        ((DeobsMetadata)object).setObfuscatorId(string);
        ((DeobsMetadata)object).setObfuscatorVersion(string2);
        File file3 = new File(this._deobsPath, uUID.toString() + ".meta");
        ((DeobsMetadata)object).store(file3);
    }

    @Override
    public boolean hasCachedDeobfuscationFiles() {
        return this._deobsPath.exists() && this._deobsPath.list(DEOBS_FILTER).length > 0;
    }

    protected File getDeobfuscationDirectory() {
        return this._deobsPath;
    }

    @Override
    public List<File> getDeobfuscationFiles() throws IOException {
        if (!this._deobsPath.exists()) {
            return Collections.emptyList();
        }
        FileUtils.verifyDirectory(this._deobsPath);
        LinkedList<File> linkedList = new LinkedList<File>();
        for (String string : this._deobsPath.list(DEOBS_FILTER)) {
            linkedList.add(new File(this._deobsPath, string));
        }
        return linkedList;
    }

    @Override
    public void removeBuildResource() {
        this._resourceManager.removeBuildResource();
    }

    @Override
    public File getResourceFile() {
        return this._resourceManager.getResourceFile();
    }

    @Override
    public String getApiKey() {
        return this.getManifestData().getMetaData().get("com.crashlytics.ApiKey");
    }
}

