/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project;

import com.android.sdklib.xml.AndroidManifestParser;
import com.android.sdklib.xml.ManifestData;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.project.ManifestData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DefaultManifestData
implements ManifestData {
    private static final String XMLTAG_VERSION_NAME = "android:versionName";
    private static final String XMLTAG_ICON = "android:icon";
    private static final String PNG_EXTENSION = ".png";
    private final File _resDir;
    private final String _versionName;
    private final Set<String> _services;
    private final Set<String> _usesPermissions;
    private final Hashtable<String, String> _metaData;
    private final String _packageName;
    private final Integer _versionCodeOrNull;
    private final String _launcherActivityName;
    private String _iconName = null;
    private String _applicationClass = null;
    private static final FilenameFilter DRAWABLE_FOLDER_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File file, String string) {
            return string.startsWith("drawable") && new File(file, string).isDirectory();
        }
    };
    private static final FilenameFilter PNG_FILE_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File file, String string) {
            return string.toLowerCase().endsWith(DefaultManifestData.PNG_EXTENSION);
        }
    };

    public static DefaultManifestData createManifest(final File file) throws ManifestData.ManifestIOException {
        return DefaultManifestData.createManifest(new ManifestProvider(){

            @Override
            public InputStream getManifestStream() throws ManifestData.ManifestIOException {
                try {
                    return new FileInputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new ManifestData.ManifestIOException("Crashlytics could not find the manifest. Not found at " + file.getAbsolutePath());
                }
            }

            @Override
            public File getManifestFile() {
                return file;
            }
        });
    }

    public static DefaultManifestData createManifest(ManifestProvider manifestProvider) throws ManifestData.ManifestIOException {
        File file = manifestProvider.getManifestFile();
        File file2 = new File(file.getParentFile(), "res");
        return DefaultManifestData.createManifest(manifestProvider, file.getAbsolutePath(), file2);
    }

    public static DefaultManifestData createManifest(ManifestProvider manifestProvider, String string, File file) throws ManifestData.ManifestIOException {
        Object object;
        String string2;
        Object object2;
        Object object3;
        Object object4;
        com.android.sdklib.xml.ManifestData manifestData;
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string3 = null;
        String string4 = null;
        InputStream inputStream = manifestProvider.getManifestStream();
        try {
            manifestData = AndroidManifestParser.parse(inputStream);
        }
        catch (Exception exception) {
            throw new ManifestData.ManifestIOException("Crashlytics could not parse " + string + " as an Android manifest.", exception);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                throw new ManifestData.ManifestIOException("Crashlytics could not close the manifest input stream.");
            }
        }
        inputStream = manifestProvider.getManifestStream();
        try {
            object4 = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            object3 = ((DocumentBuilder)object4).parse(inputStream);
            object2 = object3.getDocumentElement();
            string2 = object2.getAttribute(XMLTAG_VERSION_NAME);
            hashSet.clear();
            object = object2.getElementsByTagName("application");
            if (object.getLength() != 0) {
                String string5;
                Object object5;
                Element element = (Element)object.item(0);
                if (element.hasAttribute(XMLTAG_ICON)) {
                    string3 = element.getAttribute(XMLTAG_ICON).replaceFirst("@drawable/", "");
                }
                if (element.hasAttribute("android:name") && (string4 = element.getAttribute("android:name")).startsWith(".")) {
                    string4 = manifestData.getPackage() + string4;
                }
                NodeList nodeList = element.getElementsByTagName("service");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    String string6 = ((Element)nodeList.item(i)).getAttribute("name");
                    if (string6 == null) continue;
                    hashSet.add(string6);
                }
                NodeList nodeList2 = element.getElementsByTagName("meta-data");
                for (int i = 0; i < nodeList2.getLength(); ++i) {
                    Element element2 = (Element)nodeList2.item(i);
                    object5 = element2.getAttribute("android:name");
                    string5 = element2.getAttribute("android:value");
                    hashtable.put((String)object5, string5);
                }
                NodeList nodeList3 = object2.getElementsByTagName("uses-permission");
                for (int i = 0; i < nodeList3.getLength(); ++i) {
                    object5 = (Element)nodeList3.item(i);
                    string5 = object5.getAttribute("android:name");
                    hashSet2.add(string5);
                }
            }
        }
        catch (Exception exception) {
            throw new ManifestData.ManifestIOException("Crashlytics could not parse the manifest found at " + string, exception);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                throw new ManifestData.ManifestIOException("Crashlytics could not close the manifest input stream.");
            }
        }
        if (manifestData.getPackage() == null) {
            DeveloperTools.logD("Crashlytics could not find a package name. This will likely cause issues during upload deobs files.");
        }
        object4 = manifestData.getPackage();
        object3 = manifestData.getVersionCode();
        object2 = manifestData.getLauncherActivity();
        object = object2 == null ? null : ((ManifestData.Activity)object2).getName();
        return new DefaultManifestData(file, string2, hashSet, hashSet2, hashtable, string3, string4, (String)object4, (Integer)object3, (String)object);
    }

    public DefaultManifestData(File file, String string, Set<String> set, Set<String> set2, Hashtable<String, String> hashtable, String string2, String string3, String string4, Integer n, String string5) {
        this._resDir = file;
        this._versionName = string;
        this._services = set;
        this._usesPermissions = set2;
        this._metaData = hashtable;
        this._iconName = string2;
        this._applicationClass = string3;
        this._packageName = string4;
        this._versionCodeOrNull = n;
        this._launcherActivityName = string5;
    }

    protected DefaultManifestData() {
        this._resDir = null;
        this._versionName = null;
        this._services = null;
        this._usesPermissions = null;
        this._metaData = null;
        this._iconName = null;
        this._applicationClass = null;
        this._packageName = null;
        this._versionCodeOrNull = null;
        this._launcherActivityName = null;
    }

    @Override
    public File getLauncherIcon() {
        if (this._iconName == null || !this._resDir.exists()) {
            return null;
        }
        int n = this._iconName.length() + PNG_EXTENSION.length();
        for (File file : this._resDir.listFiles(DRAWABLE_FOLDER_FILTER)) {
            for (String string : file.list(PNG_FILE_FILTER)) {
                if (string.length() != n || !string.startsWith(this._iconName)) continue;
                return new File(file.getAbsoluteFile(), string);
            }
        }
        return null;
    }

    @Override
    public String getPackage() {
        return this._packageName;
    }

    @Override
    public Integer getVersionCodeOrNull() {
        return this._versionCodeOrNull;
    }

    @Override
    public String getVersionName() {
        return this._versionName;
    }

    @Override
    public boolean declaresService(String string) {
        return this._services.contains(string);
    }

    @Override
    public String getMainActivity() {
        return this._launcherActivityName;
    }

    @Override
    public String getApplicationClass() {
        return this._applicationClass;
    }

    @Override
    public Hashtable<String, String> getMetaData() {
        return this._metaData;
    }

    @Override
    public boolean usesPermission(String string) {
        return this._usesPermissions.contains(string);
    }

    public static interface ManifestProvider {
        public InputStream getManifestStream() throws ManifestData.ManifestIOException;

        public File getManifestFile() throws ManifestData.ManifestIOException;
    }
}

