/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project;

import com.crashlytics.api.WebApi;
import com.crashlytics.tools.android.project.AndroidProject;
import com.crashlytics.tools.android.project.DeobsMetadata;
import com.crashlytics.tools.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;

public class DeobsUploader {
    private static final String REQUEST_DEOBS_FORMAT = "%s/api/v1/%s/deobs";
    private static final String DEOBS_STORAGE_DIR = "deobs_uploaded";
    private final WebApi _webApi;

    public DeobsUploader(WebApi webApi) {
        this._webApi = webApi;
    }

    public boolean uploadDeobfuscationFiles(AndroidProject androidProject, String string) throws IOException {
        List<File> list = androidProject.getDeobfuscationFiles();
        int n = 0;
        File file = new File(androidProject.getDataDirectory(), DEOBS_STORAGE_DIR);
        for (File file2 : androidProject.getDeobfuscationFiles()) {
            boolean bl = this.uploadDeobsFile(file2, string, file);
            if (!bl) continue;
            ++n;
        }
        return n == list.size();
    }

    private boolean uploadDeobsFile(File file, String string, File file2) throws IOException {
        String string2 = this.buildIdFromFilename(file);
        File file3 = new File(file.getParent(), string2 + ".meta");
        DeobsMetadata deobsMetadata = new DeobsMetadata();
        deobsMetadata.load(file3);
        Map<String, String> map = deobsMetadata.toMap();
        URL uRL = new URL(String.format(REQUEST_DEOBS_FORMAT, this._webApi.getBaseApiUrl(), string));
        boolean bl = this._webApi.sendFile(uRL, file, "application/zip", "resource[file]", map);
        if (bl) {
            FileUtils.verifyDirectory(file2);
            if (!file3.renameTo(new File(file2, file3.getName()))) {
                file3.delete();
            }
            if (!file.renameTo(new File(file2, file.getName()))) {
                file.delete();
            }
        }
        return bl;
    }

    private String buildIdFromFilename(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(".zip");
        return string.substring(0, n);
    }
}

