/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project;

import com.crashlytics.tools.android.project.ResourceHelper;
import com.crashlytics.tools.android.project.ResourceManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ResourceFileManager
implements ResourceManager {
    private final DocumentBuilder _docBuilder;
    private final File _resourceFile;

    public ResourceFileManager(File file) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Invalid resource path: " + file.getAbsolutePath());
        }
        File file2 = new File(file, "values");
        this._resourceFile = new File(file2, "com_crashlytics_export_strings.xml");
        try {
            this._docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
    }

    @Override
    public boolean fileExists() {
        return this._resourceFile.exists() && this._resourceFile.isFile();
    }

    @Override
    public void createEmptyResourceFile() throws IOException {
        File file = this._resourceFile.getParentFile();
        if (file.exists() && !file.isDirectory()) {
            throw new IOException("Could not create resource file, path is not a directory: " + file);
        }
        if (!file.exists() && !file.mkdir()) {
            throw new IOException("Could not create resource directory: " + file);
        }
        ResourceHelper.writeInputStreamToFile(ResourceHelper.createEmptyResourceFileStream(), this._resourceFile);
    }

    @Override
    public void removeBuildResource() {
        this._resourceFile.delete();
    }

    @Override
    public UUID updateBuildId() {
        UUID uUID = UUID.randomUUID();
        try {
            InputStream inputStream = this.updateBuildId(new FileInputStream(this._resourceFile), uUID.toString());
            ResourceHelper.writeInputStreamToFile(inputStream, this._resourceFile);
        }
        catch (Exception exception) {
            throw new RuntimeException("Crashlytics could not create: " + this._resourceFile, exception);
        }
        return uUID;
    }

    public InputStream updateBuildId(InputStream inputStream, String string) throws SAXException, IOException {
        Object object;
        Document document = this._docBuilder.parse(inputStream);
        Element element = ResourceHelper.getBuildIdElement(document);
        if (element == null) {
            element = document.createElement("string");
            element.setAttribute("name", "com.crashlytics.android.build_id");
            object = document.getFirstChild();
            object.appendChild(element);
        }
        element.setTextContent(string);
        object = null;
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult streamResult = new StreamResult(new StringWriter());
            DOMSource dOMSource = new DOMSource(document);
            transformer.transform(dOMSource, streamResult);
            object = new ByteArrayInputStream(streamResult.getWriter().toString().getBytes());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return object;
    }

    @Override
    public UUID getBuildId() throws IOException {
        if (!this._resourceFile.exists()) {
            return null;
        }
        UUID uUID = null;
        try {
            Document document = this._docBuilder.parse(this._resourceFile);
            Element element = ResourceHelper.getBuildIdElement(document);
            if (element != null) {
                uUID = UUID.fromString(element.getTextContent());
            }
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException);
        }
        return uUID;
    }

    @Override
    public File getResourceFile() {
        return this._resourceFile;
    }
}

