/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ResourceHelper {
    public static InputStream createEmptyResourceFileStream() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        stringBuilder.append("<resources>\n");
        stringBuilder.append("<!--\n");
        stringBuilder.append("  This file is automatically generated by Crashlytics to uniquely \n");
        stringBuilder.append("  identify individual builds of your Android application.\n");
        stringBuilder.append("\n");
        stringBuilder.append("  Do NOT modify, delete, or commit to source control!\n");
        stringBuilder.append("-->\n");
        stringBuilder.append("</resources>\n");
        return new ByteArrayInputStream(stringBuilder.toString().getBytes());
    }

    public static Element getBuildIdElement(Document document) {
        NodeList nodeList = document.getElementsByTagName("string");
        Element element = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (!element2.hasAttribute("name") || !element2.getAttribute("name").equals("com.crashlytics.android.build_id")) continue;
            element = element2;
            break;
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeInputStreamToFile(InputStream inputStream, File file) throws IOException {
        if (!file.exists()) {
            file.createNewFile();
        }
        BufferedReader bufferedReader = null;
        PrintWriter printWriter = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            printWriter = new PrintWriter(file);
            while ((string = bufferedReader.readLine()) != null) {
                printWriter.println(string);
            }
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }
}

