/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Enumeration;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;

public class FileUtils {
    private static final int ZIP_BUFFER = 2048;

    public static boolean isCrashlyticsJar(String string) {
        return (string = string.toLowerCase()).endsWith(".jar") && string.startsWith("crashlytics-");
    }

    public static void verifyDirectory(File file) throws IOException {
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!file.exists() || !file.isDirectory()) {
            throw new IOException("Could not create directory: " + file);
        }
    }

    public static void redirect(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.flush();
    }

    public static Thread redirectAsync(final InputStream inputStream, final OutputStream outputStream) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    FileUtils.redirect(inputStream, outputStream);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        });
        thread.start();
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) throws IOException {
        FileChannel fileChannel = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        try {
            fileChannel = new FileInputStream(file).getChannel();
            abstractInterruptibleChannel = new FileOutputStream(file2).getChannel();
            ((FileChannel)abstractInterruptibleChannel).transferFrom(fileChannel, 0L, fileChannel.size());
        }
        finally {
            if (fileChannel != null) {
                fileChannel.close();
            }
            if (abstractInterruptibleChannel != null) {
                abstractInterruptibleChannel.close();
            }
        }
    }

    public static void zip(File file, File file2, boolean bl) throws IOException {
        int n;
        if (!file.exists() || !file.isFile()) {
            throw new IllegalArgumentException("Source file does not exist: " + file);
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
        byte[] byArray = new byte[2048];
        String string = bl ? file.toString() : file.getName();
        ZipEntry zipEntry = new ZipEntry(string);
        zipOutputStream.putNextEntry(zipEntry);
        while ((n = bufferedInputStream.read(byArray, 0, 2048)) != -1) {
            zipOutputStream.write(byArray, 0, n);
        }
        bufferedInputStream.close();
        zipOutputStream.close();
    }

    public static void unzip(File file, File file2) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            int n;
            ZipEntry zipEntry = enumeration.nextElement();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
            byte[] byArray = new byte[2048];
            FileOutputStream fileOutputStream = new FileOutputStream(new File(file2, zipEntry.getName()));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 2048);
            while ((n = ((InputStream)bufferedInputStream).read(byArray, 0, 2048)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            ((InputStream)bufferedInputStream).close();
        }
    }

    public static void unzipArchive(ZipFile zipFile, File file) throws IOException {
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            FileUtils.unzipEntry(zipFile, zipEntry, file);
        }
    }

    private static void unzipEntry(ZipFile zipFile, ZipEntry zipEntry, File file) throws IOException {
        if (zipEntry.isDirectory()) {
            FileUtils.verifyDirectory(new File(file, zipEntry.getName()));
            return;
        }
        File file2 = new File(file, zipEntry.getName());
        if (!file2.getParentFile().exists()) {
            FileUtils.verifyDirectory(file2.getParentFile());
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
        try {
            IOUtils.copy((InputStream)bufferedInputStream, (OutputStream)bufferedOutputStream);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            bufferedOutputStream.close();
            bufferedInputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidZip(File file) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static String unzipToString(File file) throws IOException {
        if (!file.exists() || !file.isFile()) {
            throw new FileNotFoundException("source file does not exist: " + file);
        }
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
        zipInputStream.getNextEntry();
        String string = new Scanner(zipInputStream).useDelimiter("\\A").next();
        return string;
    }

    public static String fileToString(File file) throws IOException {
        if (!file.exists() || !file.isFile()) {
            throw new FileNotFoundException("source file does not exist: " + file);
        }
        return FileUtils.streamToString(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String streamToString(InputStream inputStream) {
        Scanner scanner = null;
        String string = null;
        try {
            scanner = new Scanner(inputStream, "UTF8").useDelimiter("\\A");
            string = scanner.hasNext() ? scanner.next() : "";
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
        return string;
    }

    public static int characterOffset(File file, int n, int n2, String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        int n3 = FileUtils.characterOffset(bufferedReader, n, n2);
        bufferedReader.close();
        return n3;
    }

    public static int characterOffset(InputStream inputStream, int n, int n2) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        int n3 = FileUtils.characterOffset(bufferedReader, n, n2);
        return n3;
    }

    private static int characterOffset(BufferedReader bufferedReader, int n, int n2) throws IOException {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = -1;
        n7 = bufferedReader.read();
        while (n7 != -1 && (n3 != n || n2 != n4)) {
            char c = (char)n7;
            if (c != '\n' && n6 == 13) {
                ++n3;
                n4 = 0;
            }
            if (c != '\r') {
                if (c == '\n') {
                    ++n3;
                    n4 = 0;
                } else {
                    ++n4;
                }
            }
            n6 = c;
            ++n5;
            n7 = bufferedReader.read();
        }
        return n5;
    }

    public static String unqualifiedClassname(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(".");
        if (n > 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static void deleteAndRemakeFolder(File file) throws IOException {
        if (file.exists()) {
            org.apache.commons.io.FileUtils.deleteDirectory(file);
        }
        file.mkdirs();
    }

    public static String getIdentifier(File file) {
        String string;
        if (file == null) {
            throw new IllegalArgumentException("Crashlytics cannot create a unique identifier from a null file.");
        }
        try {
            string = String.format("%s-%s", file.getName(), DigestUtils.shaHex(file.getCanonicalPath()));
        }
        catch (IOException iOException) {
            string = String.format("%s-%s", file.getName(), DigestUtils.shaHex(file.getAbsolutePath()));
        }
        return string;
    }
}

