/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.answers;

import com.crashlytics.android.answers.SessionEvent;
import io.fabric.sdk.android.services.events.EventTransform;
import java.io.IOException;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class SessionEventTransform
implements EventTransform<SessionEvent> {
    private static final String APP_BUNDLE_ID_KEY = "appBundleId";
    private static final String EXECUTION_ID_KEY = "executionId";
    private static final String INSTALLATION_ID_KEY = "installationId";
    private static final String ANDROID_ID_KEY = "androidId";
    private static final String ADVERTISING_ID_KEY = "advertisingId";
    private static final String OS_VERSION_KEY = "osVersion";
    private static final String DEVICE_MODEL_KEY = "deviceModel";
    private static final String APP_VERSION_CODE_KEY = "appVersionCode";
    private static final String APP_VERSION_NAME_KEY = "appVersionName";
    private static final String TIMESTAMP_KEY = "timestamp";
    private static final String TYPE_KEY = "type";
    private static final String DETAILS_KEY = "details";

    SessionEventTransform() {
    }

    public byte[] toBytes(SessionEvent event) throws IOException {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(APP_BUNDLE_ID_KEY, (Object)event.appBundleId);
            jsonObject.put(EXECUTION_ID_KEY, (Object)event.executionId);
            jsonObject.put(INSTALLATION_ID_KEY, (Object)event.installationId);
            jsonObject.put(ANDROID_ID_KEY, (Object)event.androidId);
            jsonObject.put(ADVERTISING_ID_KEY, (Object)event.advertisingId);
            jsonObject.put(OS_VERSION_KEY, (Object)event.osVersion);
            jsonObject.put(DEVICE_MODEL_KEY, (Object)event.deviceModel);
            jsonObject.put(APP_VERSION_CODE_KEY, (Object)event.appVersionCode);
            jsonObject.put(APP_VERSION_NAME_KEY, (Object)event.appVersionName);
            jsonObject.put(TIMESTAMP_KEY, event.timestamp);
            jsonObject.put(TYPE_KEY, (Object)event.type.toString());
            jsonObject.put(DETAILS_KEY, (Object)this.buildDetailsJsonFor(event.details));
            return jsonObject.toString().getBytes("UTF-8");
        }
        catch (JSONException e) {
            throw new IOException(e.getMessage());
        }
    }

    private JSONObject buildDetailsJsonFor(Map<String, String> details) throws JSONException {
        JSONObject detailsJson = new JSONObject();
        for (Map.Entry<String, String> entry : details.entrySet()) {
            detailsJson.put(entry.getKey(), (Object)entry.getValue());
        }
        return detailsJson;
    }

    public SessionEvent fromBytes(byte[] bytes) throws IOException {
        return null;
    }
}

