/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.answers;

import android.app.Activity;
import android.content.Context;
import android.os.Looper;
import com.crashlytics.android.answers.Answers;
import com.crashlytics.android.answers.DisabledSessionAnalyticsManagerStrategy;
import com.crashlytics.android.answers.EnabledSessionAnalyticsManagerStrategy;
import com.crashlytics.android.answers.SessionAnalyticsFilesManager;
import com.crashlytics.android.answers.SessionAnalyticsManagerStrategy;
import com.crashlytics.android.answers.SessionEvent;
import io.fabric.sdk.android.services.common.CommonUtils;
import io.fabric.sdk.android.services.common.ExecutorUtils;
import io.fabric.sdk.android.services.events.EventsFilesManager;
import io.fabric.sdk.android.services.events.EventsHandler;
import io.fabric.sdk.android.services.events.EventsStrategy;
import io.fabric.sdk.android.services.network.HttpRequestFactory;
import io.fabric.sdk.android.services.settings.AnalyticsSettingsData;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;

class SessionAnalyticsManager
extends EventsHandler<SessionEvent> {
    private final String appBundleId;
    private final String installationId;
    private final String androidId;
    private final String advertisingId;
    private final String osVersion;
    private final String deviceModel;
    private final String appVersionCode;
    private final String appVersionName;
    private final String executionId;
    private final String betaDeviceToken;

    public SessionAnalyticsManager(Context context, String appBundleId, String installationId, String androidId, String advertisingId, String betaDeviceToken, String osVersion, String deviceModel, String appVersionCode, String appVersionName, SessionAnalyticsFilesManager filesManager, HttpRequestFactory httpRequestFactory) {
        this(context, appBundleId, installationId, androidId, advertisingId, betaDeviceToken, osVersion, deviceModel, appVersionCode, appVersionName, filesManager, ExecutorUtils.buildSingleThreadScheduledExecutorService((String)"Crashlytics SAM"), httpRequestFactory);
    }

    SessionAnalyticsManager(Context context, String appBundleId, String installationId, String androidId, String advertisingId, String betaDeviceToken, String osVersion, String deviceModel, String appVersionCode, String appVersionName, SessionAnalyticsFilesManager filesManager, ScheduledExecutorService executor, HttpRequestFactory httpRequestFactory) {
        super(context, (EventsStrategy)new EnabledSessionAnalyticsManagerStrategy(context, executor, filesManager, httpRequestFactory), (EventsFilesManager)filesManager, executor);
        this.appBundleId = appBundleId;
        this.installationId = installationId;
        this.androidId = androidId;
        this.osVersion = osVersion;
        this.advertisingId = advertisingId;
        this.deviceModel = deviceModel;
        this.appVersionCode = appVersionCode;
        this.appVersionName = appVersionName;
        this.betaDeviceToken = betaDeviceToken;
        this.executionId = UUID.randomUUID().toString();
    }

    public void onCrash(final String sessionId) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new IllegalStateException("onCrash called from main thread!!!");
        }
        this.executeSync(new Runnable(){

            @Override
            public void run() {
                try {
                    SessionAnalyticsManager.this.strategy.recordEvent((Object)SessionEvent.buildCrashEvent(SessionAnalyticsManager.this.appBundleId, SessionAnalyticsManager.this.executionId, SessionAnalyticsManager.this.installationId, SessionAnalyticsManager.this.androidId, SessionAnalyticsManager.this.advertisingId, SessionAnalyticsManager.this.betaDeviceToken, SessionAnalyticsManager.this.osVersion, SessionAnalyticsManager.this.deviceModel, SessionAnalyticsManager.this.appVersionCode, SessionAnalyticsManager.this.appVersionName, sessionId));
                }
                catch (Exception e) {
                    CommonUtils.logControlledError((Context)Answers.getInstance().getContext(), (String)"Crashlytics failed to record crash event", (Throwable)e);
                }
            }
        });
    }

    public void onInstall() {
        this.recordEventAsync(SessionEvent.buildEvent(this.appBundleId, this.executionId, this.installationId, this.androidId, this.advertisingId, this.betaDeviceToken, this.osVersion, this.deviceModel, this.appVersionCode, this.appVersionName, SessionEvent.Type.INSTALL, new HashMap<String, String>()), true);
    }

    public void onCreate(Activity activity) {
        this.recordEventAsync(SessionEvent.Type.CREATE, activity, false);
    }

    public void onDestroy(Activity activity) {
        this.recordEventAsync(SessionEvent.Type.DESTROY, activity, false);
    }

    public void onError(String sessionId) {
        this.recordEventAsync(SessionEvent.buildErrorEvent(this.appBundleId, this.executionId, this.installationId, this.androidId, this.advertisingId, this.betaDeviceToken, this.osVersion, this.deviceModel, this.appVersionCode, this.appVersionName, sessionId), false);
    }

    public void onPause(Activity activity) {
        this.recordEventAsync(SessionEvent.Type.PAUSE, activity, false);
    }

    public void onResume(Activity activity) {
        this.recordEventAsync(SessionEvent.Type.RESUME, activity, false);
    }

    public void onSaveInstanceState(Activity activity) {
        this.recordEventAsync(SessionEvent.Type.SAVE_INSTANCE_STATE, activity, false);
    }

    public void onStart(Activity activity) {
        this.recordEventAsync(SessionEvent.Type.START, activity, false);
    }

    public void onStop(Activity activity) {
        this.recordEventAsync(SessionEvent.Type.STOP, activity, false);
    }

    private void recordEventAsync(SessionEvent.Type type, Activity activity, boolean sendImmediately) {
        this.recordEventAsync(SessionEvent.buildActivityLifecycleEvent(this.appBundleId, this.executionId, this.installationId, this.androidId, this.advertisingId, this.betaDeviceToken, this.osVersion, this.deviceModel, this.appVersionCode, this.appVersionName, type, activity), sendImmediately);
    }

    void setAnalyticsSettingsData(final AnalyticsSettingsData analyticsSettingsData, final String protocolAndHostOverride) {
        this.executeAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    ((SessionAnalyticsManagerStrategy)SessionAnalyticsManager.this.strategy).setAnalyticsSettingsData(analyticsSettingsData, protocolAndHostOverride);
                }
                catch (Exception e) {
                    CommonUtils.logControlledError((Context)Answers.getInstance().getContext(), (String)"Crashlytics failed to set analytics settings data.", (Throwable)e);
                }
            }
        });
    }

    protected EventsStrategy<SessionEvent> getDisabledEventsStrategy() {
        return new DisabledSessionAnalyticsManagerStrategy();
    }
}

