/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.answers;

import android.app.Activity;
import android.content.Context;
import android.os.Looper;
import com.crashlytics.android.answers.Answers;
import com.crashlytics.android.answers.DisabledSessionAnalyticsManagerStrategy;
import com.crashlytics.android.answers.EnabledSessionAnalyticsManagerStrategy;
import com.crashlytics.android.answers.SessionAnalyticsFilesManager;
import com.crashlytics.android.answers.SessionAnalyticsManagerStrategy;
import com.crashlytics.android.answers.SessionEvent;
import com.crashlytics.android.answers.SessionEventMetadata;
import io.fabric.sdk.android.services.common.CommonUtils;
import io.fabric.sdk.android.services.common.ExecutorUtils;
import io.fabric.sdk.android.services.events.EventsFilesManager;
import io.fabric.sdk.android.services.events.EventsHandler;
import io.fabric.sdk.android.services.events.EventsStrategy;
import io.fabric.sdk.android.services.network.HttpRequestFactory;
import io.fabric.sdk.android.services.settings.AnalyticsSettingsData;
import java.util.HashMap;
import java.util.concurrent.ScheduledExecutorService;

class SessionAnalyticsManager
extends EventsHandler<SessionEvent> {
    private final SessionEventMetadata metadata;

    public SessionAnalyticsManager(Context context, SessionEventMetadata metadata, SessionAnalyticsFilesManager filesManager, HttpRequestFactory httpRequestFactory) {
        this(context, metadata, filesManager, ExecutorUtils.buildSingleThreadScheduledExecutorService((String)"Crashlytics SAM"), httpRequestFactory);
    }

    SessionAnalyticsManager(Context context, SessionEventMetadata metadata, SessionAnalyticsFilesManager filesManager, ScheduledExecutorService executor, HttpRequestFactory httpRequestFactory) {
        super(context, (EventsStrategy)new EnabledSessionAnalyticsManagerStrategy(context, executor, filesManager, httpRequestFactory), (EventsFilesManager)filesManager, executor);
        this.metadata = metadata;
    }

    public void onCrash(final String sessionId) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new IllegalStateException("onCrash called from main thread!!!");
        }
        this.executeSync(new Runnable(){

            @Override
            public void run() {
                try {
                    SessionAnalyticsManager.this.strategy.recordEvent((Object)SessionEvent.buildCrashEvent(SessionAnalyticsManager.this.metadata, sessionId));
                }
                catch (Exception e) {
                    CommonUtils.logControlledError((Context)Answers.getInstance().getContext(), (String)"Crashlytics failed to record crash event", (Throwable)e);
                }
            }
        });
    }

    public void onInstall() {
        this.recordEventAsync(SessionEvent.buildEvent(this.metadata, SessionEvent.Type.INSTALL, new HashMap<String, String>()), true);
    }

    public void onCreate(Activity activity) {
        this.recordEventAsync(SessionEvent.Type.CREATE, activity, false);
    }

    public void onDestroy(Activity activity) {
        this.recordEventAsync(SessionEvent.Type.DESTROY, activity, false);
    }

    public void onError(String sessionId) {
        this.recordEventAsync(SessionEvent.buildErrorEvent(this.metadata, sessionId), false);
    }

    public void onPause(Activity activity) {
        this.recordEventAsync(SessionEvent.Type.PAUSE, activity, false);
    }

    public void onResume(Activity activity) {
        this.recordEventAsync(SessionEvent.Type.RESUME, activity, false);
    }

    public void onSaveInstanceState(Activity activity) {
        this.recordEventAsync(SessionEvent.Type.SAVE_INSTANCE_STATE, activity, false);
    }

    public void onStart(Activity activity) {
        this.recordEventAsync(SessionEvent.Type.START, activity, false);
    }

    public void onStop(Activity activity) {
        this.recordEventAsync(SessionEvent.Type.STOP, activity, false);
    }

    private void recordEventAsync(SessionEvent.Type type, Activity activity, boolean sendImmediately) {
        this.recordEventAsync(SessionEvent.buildActivityLifecycleEvent(this.metadata, type, activity), sendImmediately);
    }

    void setAnalyticsSettingsData(final AnalyticsSettingsData analyticsSettingsData, final String protocolAndHostOverride) {
        this.executeAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    ((SessionAnalyticsManagerStrategy)SessionAnalyticsManager.this.strategy).setAnalyticsSettingsData(analyticsSettingsData, protocolAndHostOverride);
                }
                catch (Exception e) {
                    CommonUtils.logControlledError((Context)Answers.getInstance().getContext(), (String)"Crashlytics failed to set analytics settings data.", (Throwable)e);
                }
            }
        });
    }

    protected EventsStrategy<SessionEvent> getDisabledEventsStrategy() {
        return new DisabledSessionAnalyticsManagerStrategy();
    }
}

