/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.answers;

import android.content.Context;
import com.crashlytics.android.answers.AnswersRetryFilesSender;
import com.crashlytics.android.answers.EventFilter;
import com.crashlytics.android.answers.KeepAllEventFilter;
import com.crashlytics.android.answers.SamplingEventFilter;
import com.crashlytics.android.answers.SessionAnalyticsFilesManager;
import com.crashlytics.android.answers.SessionAnalyticsFilesSender;
import com.crashlytics.android.answers.SessionAnalyticsManagerStrategy;
import com.crashlytics.android.answers.SessionEvent;
import com.crashlytics.android.answers.SessionEventMetadata;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.Kit;
import io.fabric.sdk.android.services.common.ApiKey;
import io.fabric.sdk.android.services.events.EnabledEventsStrategy;
import io.fabric.sdk.android.services.events.EventsFilesManager;
import io.fabric.sdk.android.services.events.FilesSender;
import io.fabric.sdk.android.services.network.HttpRequestFactory;
import io.fabric.sdk.android.services.settings.AnalyticsSettingsData;
import java.util.concurrent.ScheduledExecutorService;

class EnabledSessionAnalyticsManagerStrategy
extends EnabledEventsStrategy<SessionEvent>
implements SessionAnalyticsManagerStrategy<SessionEvent> {
    private final Kit kit;
    private final HttpRequestFactory httpRequestFactory;
    final SessionEventMetadata metadata;
    EventFilter eventFilter = new KeepAllEventFilter();
    FilesSender filesSender;
    ApiKey apiKey = new ApiKey();
    boolean customEventsEnabled = true;
    boolean predefinedEventsEnabled = true;

    public EnabledSessionAnalyticsManagerStrategy(Kit kit, Context context, ScheduledExecutorService executor, SessionAnalyticsFilesManager filesManager, HttpRequestFactory httpRequestFactory, SessionEventMetadata metadata) {
        super(context, executor, (EventsFilesManager)filesManager);
        this.kit = kit;
        this.httpRequestFactory = httpRequestFactory;
        this.metadata = metadata;
    }

    public FilesSender getFilesSender() {
        return this.filesSender;
    }

    @Override
    public void setAnalyticsSettingsData(AnalyticsSettingsData analyticsSettingsData, String protocolAndHostOverride) {
        this.filesSender = AnswersRetryFilesSender.build(new SessionAnalyticsFilesSender(this.kit, protocolAndHostOverride, analyticsSettingsData.analyticsURL, this.httpRequestFactory, this.apiKey.getValue(this.context)));
        ((SessionAnalyticsFilesManager)this.filesManager).setAnalyticsSettingsData(analyticsSettingsData);
        this.customEventsEnabled = analyticsSettingsData.trackCustomEvents;
        Fabric.getLogger().d("Answers", "Custom event tracking " + (this.customEventsEnabled ? "enabled" : "disabled"));
        this.predefinedEventsEnabled = analyticsSettingsData.trackPredefinedEvents;
        Fabric.getLogger().d("Answers", "Predefined event tracking " + (this.predefinedEventsEnabled ? "enabled" : "disabled"));
        if (analyticsSettingsData.samplingRate > 1) {
            Fabric.getLogger().d("Answers", "Event sampling enabled");
            this.eventFilter = new SamplingEventFilter(analyticsSettingsData.samplingRate);
        }
        this.configureRollover(analyticsSettingsData.flushIntervalSeconds);
    }

    @Override
    public void processEvent(SessionEvent.Builder builder) {
        SessionEvent event = builder.build(this.metadata);
        if (!this.customEventsEnabled && SessionEvent.Type.CUSTOM.equals((Object)event.type)) {
            Fabric.getLogger().d("Answers", "Custom events tracking disabled - skipping event: " + event);
            return;
        }
        if (!this.predefinedEventsEnabled && SessionEvent.Type.PREDEFINED.equals((Object)event.type)) {
            Fabric.getLogger().d("Answers", "Predefined events tracking disabled - skipping event: " + event);
            return;
        }
        if (this.eventFilter.skipEvent(event)) {
            Fabric.getLogger().d("Answers", "Skipping filtered event: " + event);
            return;
        }
        this.recordEvent(event);
    }
}

