/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.answers;

import android.content.Context;
import com.crashlytics.android.answers.AnswersRetryFilesSender;
import com.crashlytics.android.answers.EventFilter;
import com.crashlytics.android.answers.FirebaseAnalyticsApiAdapter;
import com.crashlytics.android.answers.KeepAllEventFilter;
import com.crashlytics.android.answers.SamplingEventFilter;
import com.crashlytics.android.answers.SessionAnalyticsFilesManager;
import com.crashlytics.android.answers.SessionAnalyticsFilesSender;
import com.crashlytics.android.answers.SessionAnalyticsManagerStrategy;
import com.crashlytics.android.answers.SessionEvent;
import com.crashlytics.android.answers.SessionEventMetadata;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.Kit;
import io.fabric.sdk.android.services.common.ApiKey;
import io.fabric.sdk.android.services.common.CommonUtils;
import io.fabric.sdk.android.services.events.FileRollOverManager;
import io.fabric.sdk.android.services.events.FilesSender;
import io.fabric.sdk.android.services.events.TimeBasedFileRollOverRunnable;
import io.fabric.sdk.android.services.network.HttpRequestFactory;
import io.fabric.sdk.android.services.settings.AnalyticsSettingsData;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

class EnabledSessionAnalyticsManagerStrategy
implements SessionAnalyticsManagerStrategy {
    static final int UNDEFINED_ROLLOVER_INTERVAL_SECONDS = -1;
    private final Kit kit;
    private final HttpRequestFactory httpRequestFactory;
    private final Context context;
    private final SessionAnalyticsFilesManager filesManager;
    private final ScheduledExecutorService executorService;
    private final AtomicReference<ScheduledFuture<?>> rolloverFutureRef = new AtomicReference();
    final SessionEventMetadata metadata;
    private final FirebaseAnalyticsApiAdapter firebaseAnalyticsApiAdapter;
    FilesSender filesSender;
    ApiKey apiKey = new ApiKey();
    EventFilter eventFilter = new KeepAllEventFilter();
    boolean customEventsEnabled = true;
    boolean predefinedEventsEnabled = true;
    volatile int rolloverIntervalSeconds = -1;
    boolean forwardToFirebaseAnalyticsEnabled = false;
    boolean includePurchaseEventsInForwardedEvents = false;

    public EnabledSessionAnalyticsManagerStrategy(Kit kit, Context context, ScheduledExecutorService executor, SessionAnalyticsFilesManager filesManager, HttpRequestFactory httpRequestFactory, SessionEventMetadata metadata, FirebaseAnalyticsApiAdapter firebaseAnalyticsApiAdapter) {
        this.kit = kit;
        this.context = context;
        this.executorService = executor;
        this.filesManager = filesManager;
        this.httpRequestFactory = httpRequestFactory;
        this.metadata = metadata;
        this.firebaseAnalyticsApiAdapter = firebaseAnalyticsApiAdapter;
    }

    @Override
    public void setAnalyticsSettingsData(AnalyticsSettingsData analyticsSettingsData, String protocolAndHostOverride) {
        this.filesSender = AnswersRetryFilesSender.build(new SessionAnalyticsFilesSender(this.kit, protocolAndHostOverride, analyticsSettingsData.analyticsURL, this.httpRequestFactory, this.apiKey.getValue(this.context)));
        this.filesManager.setAnalyticsSettingsData(analyticsSettingsData);
        this.forwardToFirebaseAnalyticsEnabled = analyticsSettingsData.forwardToFirebaseAnalytics;
        this.includePurchaseEventsInForwardedEvents = analyticsSettingsData.includePurchaseEventsInForwardedEvents;
        Fabric.getLogger().d("Answers", "Firebase analytics forwarding " + (this.forwardToFirebaseAnalyticsEnabled ? "enabled" : "disabled"));
        Fabric.getLogger().d("Answers", "Firebase analytics including purchase events " + (this.includePurchaseEventsInForwardedEvents ? "enabled" : "disabled"));
        this.customEventsEnabled = analyticsSettingsData.trackCustomEvents;
        Fabric.getLogger().d("Answers", "Custom event tracking " + (this.customEventsEnabled ? "enabled" : "disabled"));
        this.predefinedEventsEnabled = analyticsSettingsData.trackPredefinedEvents;
        Fabric.getLogger().d("Answers", "Predefined event tracking " + (this.predefinedEventsEnabled ? "enabled" : "disabled"));
        if (analyticsSettingsData.samplingRate > 1) {
            Fabric.getLogger().d("Answers", "Event sampling enabled");
            this.eventFilter = new SamplingEventFilter(analyticsSettingsData.samplingRate);
        }
        this.rolloverIntervalSeconds = analyticsSettingsData.flushIntervalSeconds;
        this.scheduleTimeBasedFileRollOver(0L, this.rolloverIntervalSeconds);
    }

    @Override
    public void processEvent(SessionEvent.Builder builder) {
        SessionEvent event = builder.build(this.metadata);
        if (!this.customEventsEnabled && SessionEvent.Type.CUSTOM.equals((Object)event.type)) {
            Fabric.getLogger().d("Answers", "Custom events tracking disabled - skipping event: " + event);
            return;
        }
        if (!this.predefinedEventsEnabled && SessionEvent.Type.PREDEFINED.equals((Object)event.type)) {
            Fabric.getLogger().d("Answers", "Predefined events tracking disabled - skipping event: " + event);
            return;
        }
        if (this.eventFilter.skipEvent(event)) {
            Fabric.getLogger().d("Answers", "Skipping filtered event: " + event);
            return;
        }
        try {
            this.filesManager.writeEvent(event);
        }
        catch (IOException e) {
            Fabric.getLogger().e("Answers", "Failed to write event: " + event, (Throwable)e);
        }
        this.scheduleTimeBasedRollOverIfNeeded();
        boolean isCustomOrPredefinedEvent = SessionEvent.Type.CUSTOM.equals((Object)event.type) || SessionEvent.Type.PREDEFINED.equals((Object)event.type);
        boolean isPurchaseEvent = "purchase".equals(event.predefinedType);
        if (!this.forwardToFirebaseAnalyticsEnabled || !isCustomOrPredefinedEvent) {
            return;
        }
        if (isPurchaseEvent && !this.includePurchaseEventsInForwardedEvents) {
            return;
        }
        try {
            this.firebaseAnalyticsApiAdapter.processEvent(event);
        }
        catch (Exception e) {
            Fabric.getLogger().e("Answers", "Failed to map event to Firebase: " + event, (Throwable)e);
        }
    }

    public void scheduleTimeBasedRollOverIfNeeded() {
        boolean hasRollOverInterval;
        boolean bl = hasRollOverInterval = this.rolloverIntervalSeconds != -1;
        if (hasRollOverInterval) {
            this.scheduleTimeBasedFileRollOver(this.rolloverIntervalSeconds, this.rolloverIntervalSeconds);
        }
    }

    @Override
    public void sendEvents() {
        if (this.filesSender == null) {
            CommonUtils.logControlled((Context)this.context, (String)"skipping files send because we don't yet know the target endpoint");
            return;
        }
        CommonUtils.logControlled((Context)this.context, (String)"Sending all files");
        int filesSent = 0;
        List batch = this.filesManager.getBatchOfFilesToSend();
        try {
            while (batch.size() > 0) {
                CommonUtils.logControlled((Context)this.context, (String)String.format(Locale.US, "attempt to send batch of %d files", batch.size()));
                boolean cleanup = this.filesSender.send(batch);
                if (cleanup) {
                    filesSent += batch.size();
                    this.filesManager.deleteSentFiles(batch);
                }
                if (cleanup) {
                    batch = this.filesManager.getBatchOfFilesToSend();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            CommonUtils.logControlledError((Context)this.context, (String)("Failed to send batch of analytics files to server: " + e.getMessage()), (Throwable)e);
        }
        if (filesSent == 0) {
            this.filesManager.deleteOldestInRollOverIfOverMax();
        }
    }

    public void cancelTimeBasedFileRollOver() {
        if (this.rolloverFutureRef.get() != null) {
            CommonUtils.logControlled((Context)this.context, (String)"Cancelling time-based rollover because no events are currently being generated.");
            this.rolloverFutureRef.get().cancel(false);
            this.rolloverFutureRef.set(null);
        }
    }

    @Override
    public void deleteAllEvents() {
        this.filesManager.deleteAllEventsFiles();
    }

    public boolean rollFileOver() {
        try {
            return this.filesManager.rollFileOver();
        }
        catch (IOException e) {
            CommonUtils.logControlledError((Context)this.context, (String)"Failed to roll file over.", (Throwable)e);
            return false;
        }
    }

    void scheduleTimeBasedFileRollOver(long initialDelaySecs, long frequencySecs) {
        boolean noRollOverIsScheduled;
        boolean bl = noRollOverIsScheduled = this.rolloverFutureRef.get() == null;
        if (noRollOverIsScheduled) {
            TimeBasedFileRollOverRunnable rollOverRunnable = new TimeBasedFileRollOverRunnable(this.context, (FileRollOverManager)this);
            CommonUtils.logControlled((Context)this.context, (String)("Scheduling time based file roll over every " + frequencySecs + " seconds"));
            try {
                this.rolloverFutureRef.set(this.executorService.scheduleAtFixedRate((Runnable)rollOverRunnable, initialDelaySecs, frequencySecs, TimeUnit.SECONDS));
            }
            catch (RejectedExecutionException e) {
                CommonUtils.logControlledError((Context)this.context, (String)"Failed to schedule time based file roll over", (Throwable)e);
            }
        }
    }
}

