/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.answers;

import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.Kit;
import io.fabric.sdk.android.services.common.AbstractSpiCall;
import io.fabric.sdk.android.services.common.ResponseParser;
import io.fabric.sdk.android.services.events.FilesSender;
import io.fabric.sdk.android.services.network.HttpMethod;
import io.fabric.sdk.android.services.network.HttpRequest;
import io.fabric.sdk.android.services.network.HttpRequestFactory;
import java.io.File;
import java.util.List;

class SessionAnalyticsFilesSender
extends AbstractSpiCall
implements FilesSender {
    static final String FILE_PARAM_NAME = "session_analytics_file_";
    static final String FILE_CONTENT_TYPE = "application/vnd.crashlytics.android.events";
    private final String apiKey;

    public SessionAnalyticsFilesSender(Kit kit, String protocolAndHostOverride, String url, HttpRequestFactory requestFactory, String apiKey) {
        super(kit, protocolAndHostOverride, url, requestFactory, HttpMethod.POST);
        this.apiKey = apiKey;
    }

    public boolean send(List<File> files) {
        HttpRequest httpRequest = this.getHttpRequest();
        httpRequest = httpRequest.header("X-CRASHLYTICS-API-CLIENT-TYPE", "android").header("X-CRASHLYTICS-API-CLIENT-VERSION", this.kit.getVersion()).header("X-CRASHLYTICS-API-KEY", this.apiKey);
        int i = 0;
        for (File file : files) {
            httpRequest.part(FILE_PARAM_NAME + i, file.getName(), FILE_CONTENT_TYPE, file);
            ++i;
        }
        Fabric.getLogger().d("Answers", "Sending " + files.size() + " analytics files to " + this.getUrl());
        int statusCode = httpRequest.code();
        Fabric.getLogger().d("Answers", "Response code for analytics file send is " + statusCode);
        return 0 == ResponseParser.parse((int)statusCode);
    }
}

