/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.beta;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import com.crashlytics.android.beta.ActivityLifecycleCheckForUpdatesController;
import com.crashlytics.android.beta.BuildProperties;
import com.crashlytics.android.beta.DeviceTokenLoader;
import com.crashlytics.android.beta.ImmediateCheckForUpdatesController;
import com.crashlytics.android.beta.UpdatesController;
import io.fabric.sdk.android.ActivityLifecycleManager;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.Kit;
import io.fabric.sdk.android.services.cache.MemoryValueCache;
import io.fabric.sdk.android.services.cache.ValueLoader;
import io.fabric.sdk.android.services.common.CommonUtils;
import io.fabric.sdk.android.services.common.CurrentTimeProvider;
import io.fabric.sdk.android.services.common.DeviceIdentifierProvider;
import io.fabric.sdk.android.services.common.IdManager;
import io.fabric.sdk.android.services.common.SystemCurrentTimeProvider;
import io.fabric.sdk.android.services.network.DefaultHttpRequestFactory;
import io.fabric.sdk.android.services.network.HttpRequestFactory;
import io.fabric.sdk.android.services.persistence.PreferenceStore;
import io.fabric.sdk.android.services.persistence.PreferenceStoreImpl;
import io.fabric.sdk.android.services.settings.BetaSettingsData;
import io.fabric.sdk.android.services.settings.Settings;
import io.fabric.sdk.android.services.settings.SettingsData;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class Beta
extends Kit<Boolean>
implements DeviceIdentifierProvider {
    public static final String TAG = "Beta";
    static final String NO_DEVICE_TOKEN = "";
    private static final String CRASHLYTICS_API_ENDPOINT = "com.crashlytics.ApiEndpoint";
    private static final String CRASHLYTICS_BUILD_PROPERTIES = "crashlytics-build.properties";
    private final MemoryValueCache<String> deviceTokenCache = new MemoryValueCache();
    private final DeviceTokenLoader deviceTokenLoader = new DeviceTokenLoader();
    private UpdatesController updatesController;

    public static Beta getInstance() {
        return (Beta)Fabric.getKit(Beta.class);
    }

    @TargetApi(value=14)
    protected boolean onPreExecute() {
        Application application = (Application)this.getContext().getApplicationContext();
        this.updatesController = this.createUpdatesController(Build.VERSION.SDK_INT, application);
        return true;
    }

    protected Boolean doInBackground() {
        Fabric.getLogger().d(TAG, "Beta kit initializing...");
        Context context = this.getContext();
        IdManager idManager = this.getIdManager();
        String installerPackageName = idManager.getInstallerPackageName();
        String betaDeviceToken = this.getBetaDeviceToken(context, installerPackageName);
        if (TextUtils.isEmpty((CharSequence)betaDeviceToken)) {
            Fabric.getLogger().d(TAG, "A Beta device token was not found for this app");
            return false;
        }
        Fabric.getLogger().d(TAG, "Beta device token is present, checking for app updates.");
        BetaSettingsData betaSettings = this.getBetaSettingsData();
        BuildProperties buildProps = this.loadBuildProperties(context);
        if (this.canCheckForUpdates(betaSettings, buildProps)) {
            this.updatesController.initialize(context, this, idManager, betaSettings, buildProps, (PreferenceStore)new PreferenceStoreImpl((Kit)this), (CurrentTimeProvider)new SystemCurrentTimeProvider(), (HttpRequestFactory)new DefaultHttpRequestFactory(Fabric.getLogger()));
        }
        return true;
    }

    @TargetApi(value=14)
    UpdatesController createUpdatesController(int apiLevel, Application application) {
        if (apiLevel >= 14) {
            ActivityLifecycleManager lifecycleManager = this.getFabric().getActivityLifecycleManager();
            ExecutorService executorService = this.getFabric().getExecutorService();
            return new ActivityLifecycleCheckForUpdatesController(lifecycleManager, executorService);
        }
        return new ImmediateCheckForUpdatesController();
    }

    public Map<IdManager.DeviceIdentifierType, String> getDeviceIdentifiers() {
        String installerPackageName = this.getIdManager().getInstallerPackageName();
        String betaDeviceToken = this.getBetaDeviceToken(this.getContext(), installerPackageName);
        HashMap<IdManager.DeviceIdentifierType, String> ids = new HashMap<IdManager.DeviceIdentifierType, String>();
        if (!TextUtils.isEmpty((CharSequence)betaDeviceToken)) {
            ids.put(IdManager.DeviceIdentifierType.FONT_TOKEN, betaDeviceToken);
        }
        return ids;
    }

    public String getIdentifier() {
        return "com.crashlytics.sdk.android:beta";
    }

    public String getVersion() {
        return "1.2.5.dev";
    }

    boolean canCheckForUpdates(BetaSettingsData betaSettings, BuildProperties buildProps) {
        return betaSettings != null && !TextUtils.isEmpty((CharSequence)betaSettings.updateUrl) && buildProps != null;
    }

    private String getBetaDeviceToken(Context context, String installerPackageName) {
        String token = null;
        try {
            String cachedToken = (String)this.deviceTokenCache.get(context, (ValueLoader)this.deviceTokenLoader);
            token = NO_DEVICE_TOKEN.equals(cachedToken) ? null : cachedToken;
        }
        catch (Exception e) {
            Fabric.getLogger().e(TAG, "Failed to load the Beta device token", (Throwable)e);
        }
        Fabric.getLogger().d(TAG, "Beta device token present: " + !TextUtils.isEmpty((CharSequence)token));
        return token;
    }

    private BetaSettingsData getBetaSettingsData() {
        SettingsData settingsData = Settings.getInstance().awaitSettingsData();
        if (settingsData != null) {
            return settingsData.betaSettingsData;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BuildProperties loadBuildProperties(Context context) {
        InputStream buildPropsStream = null;
        BuildProperties buildProps = null;
        try {
            buildPropsStream = context.getAssets().open(CRASHLYTICS_BUILD_PROPERTIES);
            if (buildPropsStream != null) {
                buildProps = BuildProperties.fromPropertiesStream(buildPropsStream);
                Fabric.getLogger().d(TAG, buildProps.packageName + " build properties: " + buildProps.versionName + " (" + buildProps.versionCode + ") - " + buildProps.buildId);
            }
        }
        catch (Exception e) {
            Fabric.getLogger().e(TAG, "Error reading Beta build properties", (Throwable)e);
        }
        finally {
            if (buildPropsStream != null) {
                try {
                    buildPropsStream.close();
                }
                catch (IOException e) {
                    Fabric.getLogger().e(TAG, "Error closing Beta build properties asset", (Throwable)e);
                }
            }
        }
        return buildProps;
    }

    String getOverridenSpiEndpoint() {
        return CommonUtils.getStringsFileValue((Context)this.getContext(), (String)CRASHLYTICS_API_ENDPOINT);
    }
}

