/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.beta;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.services.cache.ValueLoader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class DeviceTokenLoader
implements ValueLoader<String> {
    private static final String DIRFACTOR_DEVICE_TOKEN_PREFIX = "assets/com.crashlytics.android.beta/dirfactor-device-token=";
    private static final String BETA_APP_PACKAGE_NAME = "io.crash.air";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String load(Context context) throws Exception {
        long start = System.nanoTime();
        String token = "";
        ZipInputStream zis = null;
        try {
            zis = this.getZipInputStreamOfApkFrom(context, BETA_APP_PACKAGE_NAME);
            token = this.determineDeviceToken(zis);
        }
        catch (PackageManager.NameNotFoundException e) {
            Fabric.getLogger().d("Beta", "Beta by Crashlytics app is not installed");
        }
        catch (FileNotFoundException e) {
            Fabric.getLogger().e("Beta", "Failed to find the APK file", (Throwable)e);
        }
        catch (IOException e) {
            Fabric.getLogger().e("Beta", "Failed to read the APK file", (Throwable)e);
        }
        finally {
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (IOException e) {
                    Fabric.getLogger().e("Beta", "Failed to close the APK file", (Throwable)e);
                }
            }
        }
        long end = System.nanoTime();
        double millis = (double)(end - start) / 1000000.0;
        Fabric.getLogger().d("Beta", "Beta device token load took " + millis + "ms");
        return token;
    }

    ZipInputStream getZipInputStreamOfApkFrom(Context context, String packageName) throws PackageManager.NameNotFoundException, FileNotFoundException {
        PackageManager pm = context.getPackageManager();
        ApplicationInfo info = pm.getApplicationInfo(packageName, 0);
        return new ZipInputStream(new FileInputStream(info.sourceDir));
    }

    String determineDeviceToken(ZipInputStream zis) throws IOException {
        String name;
        ZipEntry entry = zis.getNextEntry();
        if (entry != null && (name = entry.getName()).startsWith(DIRFACTOR_DEVICE_TOKEN_PREFIX)) {
            return name.substring(DIRFACTOR_DEVICE_TOKEN_PREFIX.length(), name.length() - 1);
        }
        return "";
    }
}

