package com.databricks.jdbc.dbclient.impl.sqlexec;

import static java.sql.DatabaseMetaData.*;

import com.databricks.jdbc.api.impl.DatabricksResultSet;
import com.databricks.jdbc.common.StatementType;
import com.databricks.jdbc.dbclient.impl.common.StatementId;
import com.databricks.jdbc.model.core.StatementStatus;
import com.databricks.sdk.service.sql.StatementState;
import java.sql.Types;
import java.util.Arrays;

public class ResultConstants {
  public static final DatabricksResultSet TYPE_INFO_RESULT =
      new DatabricksResultSet(
          new StatementStatus().setState(StatementState.SUCCEEDED),
          new StatementId("typeinfo-metadata"),
          Arrays.asList(
              "TYPE_NAME",
              "DATA_TYPE",
              "PRECISION",
              "LITERAL_PREFIX",
              "LITERAL_SUFFIX",
              "CREATE_PARAMS",
              "NULLABLE",
              "CASE_SENSITIVE",
              "SEARCHABLE",
              "UNSIGNED_ATTRIBUTE",
              "FIXED_PREC_SCALE",
              "AUTO_INCREMENT",
              "LOCAL_TYPE_NAME",
              "MINIMUM_SCALE",
              "MAXIMUM_SCALE",
              "SQL_DATA_TYPE",
              "SQL_DATETIME_SUB",
              "NUM_PREC_RADIX"),
          Arrays.asList(
              "VARCHAR",
              "INTEGER",
              "INTEGER",
              "VARCHAR",
              "VARCHAR",
              "VARCHAR",
              "SMALLINT",
              "BIT",
              "SMALLINT",
              "BIT",
              "BIT",
              "BIT",
              "VARCHAR",
              "SMALLINT",
              "SMALLINT",
              "INTEGER",
              "INTEGER",
              "INTEGER"),
          new int[] {
            Types.VARCHAR,
            Types.INTEGER,
            Types.INTEGER,
            Types.VARCHAR,
            Types.VARCHAR,
            Types.VARCHAR,
            Types.SMALLINT,
            Types.BIT,
            Types.SMALLINT,
            Types.BIT,
            Types.BIT,
            Types.BIT,
            Types.VARCHAR,
            Types.SMALLINT,
            Types.SMALLINT,
            Types.INTEGER,
            Types.INTEGER,
            Types.INTEGER
          },
          new int[] {128, 10, 10, 128, 128, 128, 5, 1, 5, 1, 1, 1, 128, 5, 5, 10, 10, 10},
          new int[] {0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1},
          new Object[][] {
            {
              "TINYINT",
              Types.TINYINT,
              3,
              null,
              null,
              null,
              typeNullable,
              false,
              typePredBasic,
              false,
              false,
              null,
              "TINYINT",
              0,
              0,
              Types.TINYINT,
              null,
              10
            },
            {
              "BIGINT",
              Types.BIGINT,
              19,
              null,
              null,
              null,
              typeNullable,
              false,
              typePredBasic,
              false,
              false,
              null,
              "BIGINT",
              0,
              0,
              Types.BIGINT,
              null,
              10
            },
            {
              "BINARY",
              Types.BINARY,
              32767,
              "0x",
              null,
              "LENGTH",
              typeNullable,
              false,
              typePredNone,
              null,
              false,
              null,
              "BINARY",
              null,
              null,
              Types.BINARY,
              null,
              null
            },
            {
              "CHAR",
              Types.CHAR,
              255,
              "'",
              "'",
              "LENGTH",
              typeNullable,
              true,
              typeSearchable,
              null,
              false,
              null,
              "CHAR",
              null,
              null,
              Types.CHAR,
              null,
              null
            },
            {
              "DECIMAL",
              Types.DECIMAL,
              38,
              null,
              null,
              null,
              typeNullable,
              false,
              typePredBasic,
              false,
              false,
              null,
              "DECIMAL",
              0,
              0,
              Types.DECIMAL,
              null,
              10
            },
            {
              "INT",
              Types.INTEGER,
              10,
              null,
              null,
              null,
              typeNullable,
              false,
              typePredBasic,
              false,
              false,
              null,
              "INT",
              0,
              0,
              Types.INTEGER,
              null,
              10
            },
            {
              "SMALLINT",
              Types.SMALLINT,
              5,
              null,
              null,
              null,
              typeNullable,
              false,
              typePredBasic,
              false,
              false,
              null,
              "SMALLINT",
              0,
              0,
              Types.SMALLINT,
              null,
              10
            },
            {
              "FLOAT",
              Types.FLOAT,
              7,
              null,
              null,
              null,
              typeNullable,
              false,
              typePredBasic,
              false,
              false,
              null,
              "FLOAT",
              null,
              null,
              Types.FLOAT,
              null,
              2
            },
            {
              "DOUBLE",
              Types.DOUBLE,
              15,
              null,
              null,
              null,
              typeNullable,
              false,
              typePredBasic,
              false,
              false,
              null,
              "DOUBLE",
              null,
              null,
              Types.DOUBLE,
              null,
              2
            },
            {
              "ARRAY",
              Types.VARCHAR,
              32767,
              "'",
              "'",
              "Type",
              typeNullable,
              false,
              typeSearchable,
              null,
              false,
              null,
              "ARRAY",
              null,
              null,
              Types.VARCHAR,
              null,
              null
            },
            {
              "MAP",
              Types.VARCHAR,
              32767,
              "'",
              "'",
              "Key,Value",
              typeNullable,
              false,
              typeSearchable,
              null,
              false,
              null,
              "MAP",
              null,
              null,
              Types.VARCHAR,
              null,
              null
            },
            {
              "STRING",
              Types.VARCHAR,
              510,
              "'",
              "'",
              "max length",
              typeNullable,
              true,
              typeSearchable,
              null,
              false,
              null,
              "STRING",
              null,
              null,
              Types.VARCHAR,
              null,
              null
            },
            {
              "STRUCT",
              Types.VARCHAR,
              32767,
              "'",
              "'",
              "Column Type, ...",
              typeNullable,
              false,
              typeSearchable,
              null,
              false,
              null,
              "STRUCT",
              null,
              null,
              Types.VARCHAR,
              null,
              null
            },
            {
              "VARCHAR",
              Types.VARCHAR,
              510,
              "'",
              "'",
              "max length",
              typeNullable,
              true,
              typeSearchable,
              null,
              false,
              null,
              "VARCHAR",
              null,
              null,
              Types.VARCHAR,
              null,
              null
            },
            {
              "VARIANT",
              Types.VARCHAR,
              32767,
              "'",
              "'",
              "max length",
              typeNullable,
              false,
              typeSearchable,
              null,
              false,
              null,
              "VARIANT",
              null,
              null,
              Types.VARCHAR,
              null,
              null
            },
            {
              "BOOLEAN",
              Types.BOOLEAN,
              1,
              null,
              null,
              null,
              typeNullable,
              false,
              typePredBasic,
              null,
              false,
              null,
              "BOOLEAN",
              null,
              null,
              Types.BOOLEAN,
              null,
              null
            },
            {
              "DATE",
              Types.DATE,
              10,
              "'",
              "'",
              null,
              typeNullable,
              false,
              typeSearchable,
              null,
              false,
              null,
              "DATE",
              null,
              null,
              Types.DATE,
              1,
              null
            },
            {
              "TIMESTAMP",
              Types.TIMESTAMP,
              29,
              "'",
              "'",
              null,
              typeNullable,
              false,
              typeSearchable,
              null,
              false,
              null,
              "TIMESTAMP",
              0,
              0,
              Types.TIMESTAMP,
              3,
              null
            },
            {
              "TIMESTAMP_NTZ",
              Types.TIMESTAMP,
              29,
              "'",
              "'",
              null,
              typeNullable,
              false,
              typeSearchable,
              null,
              false,
              null,
              "TIMESTAMP_NTZ",
              0,
              0,
              Types.TIMESTAMP,
              3,
              null
            },
            {
              "INTERVAL",
              Types.VARCHAR,
              40,
              "'",
              "'",
              "Qualifier",
              typeNullable,
              false,
              typeSearchable,
              null,
              false,
              null,
              "INTERVAL",
              0,
              6,
              Types.VARCHAR,
              null,
              null
            }
          },
          StatementType.METADATA);

  /** The static result set for the client info properties metadata. */
  public static final DatabricksResultSet CLIENT_INFO_PROPERTIES_RESULT =
      new DatabricksResultSet(
          new StatementStatus().setState(StatementState.SUCCEEDED),
          new StatementId("client-info-properties-metadata"),
          Arrays.asList("NAME", "MAX_LEN", "DEFAULT_VALUE", "DESCRIPTION"),
          Arrays.asList("VARCHAR", "INTEGER", "VARCHAR", "VARCHAR"),
          new int[] {Types.VARCHAR, Types.INTEGER, Types.VARCHAR, Types.VARCHAR},
          new int[] {128, 10, 128, 128},
          new int[] {0, 0, 1, 1},
          new Object[][] {
            {
              "APPLICATIONNAME",
              25,
              null,
              "The name of the application currently utilizing the connection."
            },
            {
              "CLIENTHOSTNAME",
              25,
              null,
              "The hostname of the computer the application using the connection is running on."
            },
            {
              "CLIENTUSER",
              25,
              null,
              "The name of the user that the application using the connection is performing work for."
            }
          },
          StatementType.METADATA);
}
