/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.core;

import com.databricks.internal.google.auth.oauth2.AccessToken;
import com.databricks.internal.google.auth.oauth2.IdToken;
import com.databricks.internal.google.auth.oauth2.ServiceAccountCredentials;
import com.databricks.internal.sdk.core.CredentialsProvider;
import com.databricks.internal.sdk.core.DatabricksConfig;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.HeaderFactory;
import com.databricks.internal.sdk.core.utils.GoogleUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleCredentialsCredentialsProvider
implements CredentialsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleCredentialsCredentialsProvider.class);

    @Override
    public String authType() {
        return "google-credentials";
    }

    @Override
    public HeaderFactory configure(DatabricksConfig config) {
        ServiceAccountCredentials serviceAccountCredentials;
        String host = config.getHost();
        String googleCredentials = config.getGoogleCredentials();
        if (host == null || googleCredentials == null || !config.isGcp()) {
            return null;
        }
        try {
            serviceAccountCredentials = ServiceAccountCredentials.fromStream(Files.newInputStream(Paths.get(googleCredentials, new String[0]), new OpenOption[0]));
        }
        catch (IOException e) {
            try {
                serviceAccountCredentials = ServiceAccountCredentials.fromStream(new ByteArrayInputStream(googleCredentials.getBytes(StandardCharsets.UTF_8)));
            }
            catch (IOException ex) {
                LOG.warn("Failed to get Google service account credentials." + ex);
                return null;
            }
        }
        List tokenOption = Collections.emptyList();
        ServiceAccountCredentials finalServiceAccountCredentials = serviceAccountCredentials;
        return () -> {
            IdToken idToken;
            try {
                idToken = finalServiceAccountCredentials.idTokenWithAudience(host, tokenOption);
            }
            catch (IOException e) {
                String message = "Failed to get id token from Google service account credentials.";
                LOG.error(message + e);
                throw new DatabricksException(message, e);
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", String.format("Bearer %s", idToken.getTokenValue()));
            if (config.isAccountClient()) {
                AccessToken token;
                try {
                    token = finalServiceAccountCredentials.createScoped(GoogleUtils.GCP_SCOPES).refreshAccessToken();
                }
                catch (IOException e) {
                    String message = "Failed to refresh access token from Google service account credentials.";
                    LOG.error(message + e);
                    throw new DatabricksException(message, e);
                }
                headers.put(GoogleUtils.SA_ACCESS_TOKEN_HEADER, token.getTokenValue());
            }
            return headers;
        };
    }
}

