/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.dashboards;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.service.dashboards.GenieCreateConversationMessageRequest;
import com.databricks.internal.sdk.service.dashboards.GenieDeleteConversationMessageRequest;
import com.databricks.internal.sdk.service.dashboards.GenieDeleteConversationRequest;
import com.databricks.internal.sdk.service.dashboards.GenieExecuteMessageAttachmentQueryRequest;
import com.databricks.internal.sdk.service.dashboards.GenieExecuteMessageQueryRequest;
import com.databricks.internal.sdk.service.dashboards.GenieGetConversationMessageRequest;
import com.databricks.internal.sdk.service.dashboards.GenieGetMessageAttachmentQueryResultRequest;
import com.databricks.internal.sdk.service.dashboards.GenieGetMessageQueryResultRequest;
import com.databricks.internal.sdk.service.dashboards.GenieGetMessageQueryResultResponse;
import com.databricks.internal.sdk.service.dashboards.GenieGetQueryResultByAttachmentRequest;
import com.databricks.internal.sdk.service.dashboards.GenieGetSpaceRequest;
import com.databricks.internal.sdk.service.dashboards.GenieImpl;
import com.databricks.internal.sdk.service.dashboards.GenieListConversationMessagesRequest;
import com.databricks.internal.sdk.service.dashboards.GenieListConversationMessagesResponse;
import com.databricks.internal.sdk.service.dashboards.GenieListConversationsRequest;
import com.databricks.internal.sdk.service.dashboards.GenieListConversationsResponse;
import com.databricks.internal.sdk.service.dashboards.GenieListSpacesRequest;
import com.databricks.internal.sdk.service.dashboards.GenieListSpacesResponse;
import com.databricks.internal.sdk.service.dashboards.GenieMessage;
import com.databricks.internal.sdk.service.dashboards.GenieSendMessageFeedbackRequest;
import com.databricks.internal.sdk.service.dashboards.GenieService;
import com.databricks.internal.sdk.service.dashboards.GenieSpace;
import com.databricks.internal.sdk.service.dashboards.GenieStartConversationMessageRequest;
import com.databricks.internal.sdk.service.dashboards.GenieStartConversationResponse;
import com.databricks.internal.sdk.service.dashboards.GenieTrashSpaceRequest;
import com.databricks.internal.sdk.service.dashboards.MessageStatus;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Wait;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class GenieAPI {
    private static final Logger LOG = LoggerFactory.getLogger(GenieAPI.class);
    private final GenieService impl;

    public GenieAPI(ApiClient apiClient) {
        this.impl = new GenieImpl(apiClient);
    }

    public GenieAPI(GenieService mock) {
        this.impl = mock;
    }

    public GenieMessage waitGetMessageGenieCompleted(String conversationId, String messageId, String spaceId) throws TimeoutException {
        return this.waitGetMessageGenieCompleted(conversationId, messageId, spaceId, Duration.ofMinutes(20L), null);
    }

    public GenieMessage waitGetMessageGenieCompleted(String conversationId, String messageId, String spaceId, Duration timeout, Consumer<GenieMessage> callback) throws TimeoutException {
        long deadline = System.currentTimeMillis() + timeout.toMillis();
        List<MessageStatus> targetStates = Arrays.asList(MessageStatus.COMPLETED);
        List<MessageStatus> failureStates = Arrays.asList(MessageStatus.FAILED);
        String statusMessage = "polling...";
        int attempt = 1;
        while (System.currentTimeMillis() < deadline) {
            GenieMessage poll = this.getMessage(new GenieGetConversationMessageRequest().setConversationId(conversationId).setMessageId(messageId).setSpaceId(spaceId));
            MessageStatus status = poll.getStatus();
            statusMessage = String.format("current status: %s", new Object[]{status});
            if (targetStates.contains((Object)status)) {
                return poll;
            }
            if (callback != null) {
                callback.accept(poll);
            }
            if (failureStates.contains((Object)status)) {
                String msg = String.format("failed to reach COMPLETED, got %s: %s", new Object[]{status, statusMessage});
                throw new IllegalStateException(msg);
            }
            String prefix = String.format("conversationId=%s, messageId=%s, spaceId=%s", conversationId, messageId, spaceId);
            int sleep = attempt;
            if (sleep > 10) {
                sleep = 10;
            }
            LOG.info("{}: ({}) {} (sleeping ~{}s)", new Object[]{prefix, status, statusMessage, sleep});
            try {
                Thread.sleep((long)((double)((long)sleep * 1000L) + Math.random() * 1000.0));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new DatabricksException("Current thread was interrupted", e);
            }
            ++attempt;
        }
        throw new TimeoutException(String.format("timed out after %s: %s", timeout, statusMessage));
    }

    public Wait<GenieMessage, GenieMessage> createMessage(GenieCreateConversationMessageRequest request) {
        GenieMessage response = this.impl.createMessage(request);
        return new Wait<GenieMessage, GenieMessage>((timeout, callback) -> this.waitGetMessageGenieCompleted(request.getConversationId(), response.getMessageId(), request.getSpaceId(), timeout, callback), response);
    }

    public void deleteConversation(String spaceId, String conversationId) {
        this.deleteConversation(new GenieDeleteConversationRequest().setSpaceId(spaceId).setConversationId(conversationId));
    }

    public void deleteConversation(GenieDeleteConversationRequest request) {
        this.impl.deleteConversation(request);
    }

    public void deleteConversationMessage(String spaceId, String conversationId, String messageId) {
        this.deleteConversationMessage(new GenieDeleteConversationMessageRequest().setSpaceId(spaceId).setConversationId(conversationId).setMessageId(messageId));
    }

    public void deleteConversationMessage(GenieDeleteConversationMessageRequest request) {
        this.impl.deleteConversationMessage(request);
    }

    public GenieGetMessageQueryResultResponse executeMessageAttachmentQuery(GenieExecuteMessageAttachmentQueryRequest request) {
        return this.impl.executeMessageAttachmentQuery(request);
    }

    public GenieGetMessageQueryResultResponse executeMessageQuery(GenieExecuteMessageQueryRequest request) {
        return this.impl.executeMessageQuery(request);
    }

    public GenieMessage getMessage(String spaceId, String conversationId, String messageId) {
        return this.getMessage(new GenieGetConversationMessageRequest().setSpaceId(spaceId).setConversationId(conversationId).setMessageId(messageId));
    }

    public GenieMessage getMessage(GenieGetConversationMessageRequest request) {
        return this.impl.getMessage(request);
    }

    public GenieGetMessageQueryResultResponse getMessageAttachmentQueryResult(String spaceId, String conversationId, String messageId, String attachmentId) {
        return this.getMessageAttachmentQueryResult(new GenieGetMessageAttachmentQueryResultRequest().setSpaceId(spaceId).setConversationId(conversationId).setMessageId(messageId).setAttachmentId(attachmentId));
    }

    public GenieGetMessageQueryResultResponse getMessageAttachmentQueryResult(GenieGetMessageAttachmentQueryResultRequest request) {
        return this.impl.getMessageAttachmentQueryResult(request);
    }

    public GenieGetMessageQueryResultResponse getMessageQueryResult(String spaceId, String conversationId, String messageId) {
        return this.getMessageQueryResult(new GenieGetMessageQueryResultRequest().setSpaceId(spaceId).setConversationId(conversationId).setMessageId(messageId));
    }

    public GenieGetMessageQueryResultResponse getMessageQueryResult(GenieGetMessageQueryResultRequest request) {
        return this.impl.getMessageQueryResult(request);
    }

    public GenieGetMessageQueryResultResponse getMessageQueryResultByAttachment(String spaceId, String conversationId, String messageId, String attachmentId) {
        return this.getMessageQueryResultByAttachment(new GenieGetQueryResultByAttachmentRequest().setSpaceId(spaceId).setConversationId(conversationId).setMessageId(messageId).setAttachmentId(attachmentId));
    }

    public GenieGetMessageQueryResultResponse getMessageQueryResultByAttachment(GenieGetQueryResultByAttachmentRequest request) {
        return this.impl.getMessageQueryResultByAttachment(request);
    }

    public GenieSpace getSpace(String spaceId) {
        return this.getSpace(new GenieGetSpaceRequest().setSpaceId(spaceId));
    }

    public GenieSpace getSpace(GenieGetSpaceRequest request) {
        return this.impl.getSpace(request);
    }

    public GenieListConversationMessagesResponse listConversationMessages(String spaceId, String conversationId) {
        return this.listConversationMessages(new GenieListConversationMessagesRequest().setSpaceId(spaceId).setConversationId(conversationId));
    }

    public GenieListConversationMessagesResponse listConversationMessages(GenieListConversationMessagesRequest request) {
        return this.impl.listConversationMessages(request);
    }

    public GenieListConversationsResponse listConversations(String spaceId) {
        return this.listConversations(new GenieListConversationsRequest().setSpaceId(spaceId));
    }

    public GenieListConversationsResponse listConversations(GenieListConversationsRequest request) {
        return this.impl.listConversations(request);
    }

    public GenieListSpacesResponse listSpaces(GenieListSpacesRequest request) {
        return this.impl.listSpaces(request);
    }

    public void sendMessageFeedback(GenieSendMessageFeedbackRequest request) {
        this.impl.sendMessageFeedback(request);
    }

    public Wait<GenieMessage, GenieStartConversationResponse> startConversation(GenieStartConversationMessageRequest request) {
        GenieStartConversationResponse response = this.impl.startConversation(request);
        return new Wait<GenieMessage, GenieStartConversationResponse>((timeout, callback) -> this.waitGetMessageGenieCompleted(response.getConversationId(), response.getMessageId(), request.getSpaceId(), timeout, callback), response);
    }

    public void trashSpace(String spaceId) {
        this.trashSpace(new GenieTrashSpaceRequest().setSpaceId(spaceId));
    }

    public void trashSpace(GenieTrashSpaceRequest request) {
        this.impl.trashSpace(request);
    }

    public GenieService impl() {
        return this.impl;
    }
}

