/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.sharing;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.sharing.CreateProvider;
import com.databricks.internal.sdk.service.sharing.DeleteProviderRequest;
import com.databricks.internal.sdk.service.sharing.GetProviderRequest;
import com.databricks.internal.sdk.service.sharing.ListProviderShareAssetsRequest;
import com.databricks.internal.sdk.service.sharing.ListProviderShareAssetsResponse;
import com.databricks.internal.sdk.service.sharing.ListProviderSharesResponse;
import com.databricks.internal.sdk.service.sharing.ListProvidersRequest;
import com.databricks.internal.sdk.service.sharing.ListProvidersResponse;
import com.databricks.internal.sdk.service.sharing.ListSharesRequest;
import com.databricks.internal.sdk.service.sharing.ProviderInfo;
import com.databricks.internal.sdk.service.sharing.ProvidersService;
import com.databricks.internal.sdk.service.sharing.UpdateProvider;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class ProvidersImpl
implements ProvidersService {
    private final ApiClient apiClient;

    public ProvidersImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public ProviderInfo create(CreateProvider request) {
        String path = "/api/2.1/unity-catalog/providers";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, ProviderInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteProviderRequest request) {
        String path = String.format("/api/2.1/unity-catalog/providers/%s", request.getName());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ProviderInfo get(GetProviderRequest request) {
        String path = String.format("/api/2.1/unity-catalog/providers/%s", request.getName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ProviderInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListProvidersResponse list(ListProvidersRequest request) {
        String path = "/api/2.1/unity-catalog/providers";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListProvidersResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListProviderShareAssetsResponse listProviderShareAssets(ListProviderShareAssetsRequest request) {
        String path = String.format("/api/2.1/data-sharing/providers/%s/shares/%s", request.getProviderName(), request.getShareName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListProviderShareAssetsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListProviderSharesResponse listShares(ListSharesRequest request) {
        String path = String.format("/api/2.1/unity-catalog/providers/%s/shares", request.getName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListProviderSharesResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ProviderInfo update(UpdateProvider request) {
        String path = String.format("/api/2.1/unity-catalog/providers/%s", request.getName());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, ProviderInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

