/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.tags;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.tags.CreateTagPolicyRequest;
import com.databricks.internal.sdk.service.tags.DeleteTagPolicyRequest;
import com.databricks.internal.sdk.service.tags.GetTagPolicyRequest;
import com.databricks.internal.sdk.service.tags.ListTagPoliciesRequest;
import com.databricks.internal.sdk.service.tags.ListTagPoliciesResponse;
import com.databricks.internal.sdk.service.tags.TagPoliciesService;
import com.databricks.internal.sdk.service.tags.TagPolicy;
import com.databricks.internal.sdk.service.tags.UpdateTagPolicyRequest;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class TagPoliciesImpl
implements TagPoliciesService {
    private final ApiClient apiClient;

    public TagPoliciesImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public TagPolicy createTagPolicy(CreateTagPolicyRequest request) {
        String path = "/api/2.1/tag-policies";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request.getTagPolicy()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, TagPolicy.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteTagPolicy(DeleteTagPolicyRequest request) {
        String path = String.format("/api/2.1/tag-policies/%s", request.getTagKey());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public TagPolicy getTagPolicy(GetTagPolicyRequest request) {
        String path = String.format("/api/2.1/tag-policies/%s", request.getTagKey());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, TagPolicy.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListTagPoliciesResponse listTagPolicies(ListTagPoliciesRequest request) {
        String path = "/api/2.1/tag-policies";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListTagPoliciesResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public TagPolicy updateTagPolicy(UpdateTagPolicyRequest request) {
        String path = String.format("/api/2.1/tag-policies/%s", request.getTagKey());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request.getTagPolicy()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, TagPolicy.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

