/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl;

import com.databricks.jdbc.api.impl.IExecutionResult;
import com.databricks.jdbc.api.impl.InlineJsonResult;
import com.databricks.jdbc.api.impl.LazyThriftResult;
import com.databricks.jdbc.api.impl.arrow.ArrowStreamResult;
import com.databricks.jdbc.api.impl.volume.VolumeOperationResult;
import com.databricks.jdbc.api.internal.IDatabricksSession;
import com.databricks.jdbc.api.internal.IDatabricksStatementInternal;
import com.databricks.jdbc.common.util.DatabricksThriftUtil;
import com.databricks.jdbc.dbclient.impl.common.StatementId;
import com.databricks.jdbc.exception.DatabricksParsingException;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.exception.DatabricksSQLFeatureNotImplementedException;
import com.databricks.jdbc.exception.DatabricksSQLFeatureNotSupportedException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.client.thrift.generated.TFetchResultsResp;
import com.databricks.jdbc.model.client.thrift.generated.TSparkRowSetType;
import com.databricks.jdbc.model.core.ResultData;
import com.databricks.jdbc.model.core.ResultManifest;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import com.databricks.jdbc.telemetry.latency.TelemetryCollector;
import java.sql.SQLException;
import java.util.List;

class ExecutionResultFactory {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(ExecutionResultFactory.class);

    ExecutionResultFactory() {
    }

    static IExecutionResult getResultSet(ResultData data, ResultManifest manifest, StatementId statementId, IDatabricksSession session, IDatabricksStatementInternal statement) throws DatabricksSQLException {
        IExecutionResult resultHandler = ExecutionResultFactory.getResultHandler(data, manifest, statementId, session);
        if (manifest.getIsVolumeOperation() != null && manifest.getIsVolumeOperation().booleanValue()) {
            return new VolumeOperationResult(manifest.getTotalRowCount(), manifest.getSchema().getColumnCount(), session, resultHandler, statement);
        }
        return resultHandler;
    }

    private static IExecutionResult getResultHandler(ResultData data, ResultManifest manifest, StatementId statementId, IDatabricksSession session) throws DatabricksSQLException {
        if (manifest.getFormat() == null) {
            throw new DatabricksParsingException("Empty response format", DatabricksDriverErrorCode.INVALID_STATE);
        }
        TelemetryCollector.getInstance().setResultFormat(statementId, manifest.getFormat());
        LOGGER.info("Processing result of format {} from SQL Execution API", new Object[]{manifest.getFormat()});
        switch (manifest.getFormat()) {
            case ARROW_STREAM: {
                return new ArrowStreamResult(manifest, data, statementId, session);
            }
            case JSON_ARRAY: {
                return new InlineJsonResult(manifest, data);
            }
        }
        String errorMessage = String.format("Invalid response format %s", new Object[]{manifest.getFormat()});
        LOGGER.error(errorMessage);
        throw new DatabricksParsingException(errorMessage, DatabricksDriverErrorCode.INVALID_STATE);
    }

    static IExecutionResult getResultSet(TFetchResultsResp resultsResp, IDatabricksSession session, IDatabricksStatementInternal statement) throws SQLException {
        IExecutionResult resultHandler = ExecutionResultFactory.getResultHandler(resultsResp, statement, session);
        if (resultsResp.getResultSetMetadata().isSetIsStagingOperation() && resultsResp.getResultSetMetadata().isIsStagingOperation()) {
            return new VolumeOperationResult(DatabricksThriftUtil.getRowCount(resultsResp.getResults()), resultsResp.getResultSetMetadata().getSchema().getColumnsSize(), session, resultHandler, statement);
        }
        return resultHandler;
    }

    private static IExecutionResult getResultHandler(TFetchResultsResp resultsResp, IDatabricksStatementInternal parentStatement, IDatabricksSession session) throws SQLException {
        TSparkRowSetType resultFormat = resultsResp.getResultSetMetadata().getResultFormat();
        TelemetryCollector.getInstance().setResultFormat(parentStatement, resultFormat);
        LOGGER.info("Processing result of format {} from Thrift server", resultFormat);
        switch (resultFormat) {
            case COLUMN_BASED_SET: {
                return new LazyThriftResult(resultsResp, parentStatement, session);
            }
            case ARROW_BASED_SET: {
                return new ArrowStreamResult(resultsResp, true, parentStatement, session);
            }
            case URL_BASED_SET: {
                return new ArrowStreamResult(resultsResp, false, parentStatement, session);
            }
            case ROW_BASED_SET: {
                throw new DatabricksSQLFeatureNotSupportedException("Invalid state - row based set cannot be received");
            }
        }
        throw new DatabricksSQLFeatureNotImplementedException("Invalid thrift response format " + String.valueOf(resultFormat));
    }

    static IExecutionResult getResultSet(Object[][] rows) {
        return new InlineJsonResult(rows);
    }

    static IExecutionResult getResultSet(List<List<Object>> rows) {
        return new InlineJsonResult(rows);
    }
}

