/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.exception;

public enum DatabricksVendorCode {
    INCORRECT_UID(500174, "Invalid UID parameter: Expected 'token' or omit UID parameter entirely", "Invalid UID parameter: Expected 'token' or omit UID parameter entirely"),
    INCORRECT_ACCESS_TOKEN(500593, "Incorrect or invalid access token provided", "Invalid access token"),
    INCORRECT_HOST(700120, "Incorrect host URL provided", "java.net.UnknownHostException");

    private final int code;
    private final String message;
    private final String upstreamErrorMessage;

    private DatabricksVendorCode(int code, String message, String upstreamErrorMessage) {
        this.code = code;
        this.message = message;
        this.upstreamErrorMessage = upstreamErrorMessage.toLowerCase();
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getUpstreamErrorMessage() {
        return this.upstreamErrorMessage;
    }

    public static DatabricksVendorCode fromCode(int code) {
        for (DatabricksVendorCode vendorCode : DatabricksVendorCode.values()) {
            if (vendorCode.getCode() != code) continue;
            return vendorCode;
        }
        return null;
    }

    public static int getVendorCode(Throwable throwable) {
        for (Throwable current = throwable; current != null; current = current.getCause()) {
            String errorMessage = String.valueOf(current.getClass()) + ": " + current.getMessage();
            int vendorCode = DatabricksVendorCode.getVendorCode(errorMessage);
            if (vendorCode == 0) continue;
            return vendorCode;
        }
        return 0;
    }

    public static int getVendorCode(String exceptionMessage) {
        if (exceptionMessage == null) {
            return 0;
        }
        exceptionMessage = exceptionMessage.toLowerCase();
        for (DatabricksVendorCode vendorCode : DatabricksVendorCode.values()) {
            if (!exceptionMessage.contains(vendorCode.getUpstreamErrorMessage())) continue;
            return vendorCode.getCode();
        }
        return 0;
    }
}

