/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Codec;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Query;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.DateType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;

public class BoundStatement
extends Query {
    final PreparedStatement statement;
    final ByteBuffer[] values;
    private int remaining;

    public BoundStatement(PreparedStatement statement) {
        this.statement = statement;
        this.values = new ByteBuffer[statement.getVariables().size()];
        this.remaining = this.values.length;
        if (statement.getConsistencyLevel() != null) {
            this.setConsistencyLevel(statement.getConsistencyLevel());
        }
    }

    public PreparedStatement preparedStatement() {
        return this.statement;
    }

    public boolean isReady() {
        return this.remaining == 0;
    }

    public boolean isSet(int i) {
        this.metadata().checkBounds(i);
        return this.values[i] != null;
    }

    public boolean isSet(String name) {
        return this.isSet(this.metadata().getIdx(name));
    }

    public BoundStatement bind(Object ... values) {
        if (values.length > this.statement.getVariables().size()) {
            throw new IllegalArgumentException(String.format("Prepared statement has only %d variables, %d values provided", this.statement.getVariables().size(), values.length));
        }
        for (int i = 0; i < values.length; ++i) {
            Object toSet = values[i];
            if (toSet == null) {
                throw new IllegalArgumentException("'null' parameters are not allowed since CQL3 does not (yet) supports them (see https://issues.apache.org/jira/browse/CASSANDRA-3783)");
            }
            DataType columnType = this.statement.getVariables().getType(i);
            switch (columnType.getName()) {
                case LIST: {
                    if (!(toSet instanceof List)) {
                        throw new InvalidTypeException(String.format("Invalid type for value %d, column is a list but %s provided", i, toSet.getClass()));
                    }
                    List l = (List)toSet;
                    if (l.isEmpty()) break;
                    Class<?> providedClass = l.get(0).getClass();
                    Class<?> expectedClass = columnType.getTypeArguments().get(0).asJavaClass();
                    if (expectedClass.isAssignableFrom(providedClass)) break;
                    throw new InvalidTypeException(String.format("Invalid type for value %d of CQL type %s, expecting list of %s but provided list of %s", i, columnType, expectedClass, providedClass));
                }
                case SET: {
                    Class<?> providedClass;
                    Class<?> expectedClass;
                    if (!(toSet instanceof Set)) {
                        throw new InvalidTypeException(String.format("Invalid type for value %d, column is a set but %s provided", i, toSet.getClass()));
                    }
                    Set s = (Set)toSet;
                    if (s.isEmpty() || (expectedClass = columnType.getTypeArguments().get((int)0).getName().javaType).isAssignableFrom(providedClass = s.iterator().next().getClass())) break;
                    throw new InvalidTypeException(String.format("Invalid type for value %d of CQL type %s, expecting set of %s but provided set of %s", i, columnType, expectedClass, providedClass));
                }
                case MAP: {
                    if (!(toSet instanceof Map)) {
                        throw new InvalidTypeException(String.format("Invalid type for value %d, column is a map but %s provided", i, toSet.getClass()));
                    }
                    Map m = (Map)toSet;
                    if (m.isEmpty()) break;
                    Map.Entry entry = m.entrySet().iterator().next();
                    Class<?> providedKeysClass = entry.getKey().getClass();
                    Class<?> providedValuesClass = entry.getValue().getClass();
                    Class<?> expectedKeysClass = columnType.getTypeArguments().get((int)0).getName().javaType;
                    Class<?> expectedValuesClass = columnType.getTypeArguments().get((int)1).getName().javaType;
                    if (expectedKeysClass.isAssignableFrom(providedKeysClass) && expectedValuesClass.isAssignableFrom(providedValuesClass)) break;
                    throw new InvalidTypeException(String.format("Invalid type for value %d of CQL type %s, expecting map of %s->%s but provided set of %s->%s", i, columnType, expectedKeysClass, expectedValuesClass, providedKeysClass, providedValuesClass));
                }
                default: {
                    Class<?> providedClass = toSet.getClass();
                    Class<?> expectedClass = columnType.getName().javaType;
                    if (expectedClass.isAssignableFrom(providedClass)) break;
                    throw new InvalidTypeException(String.format("Invalid type for value %d of CQL type %s, expecting %s but %s provided", i, columnType, expectedClass, providedClass));
                }
            }
            this.setValue(i, Codec.getCodec(columnType).decompose(toSet));
        }
        return this;
    }

    @Override
    public ByteBuffer getRoutingKey() {
        if (this.statement.routingKey != null) {
            return this.statement.routingKey;
        }
        if (this.statement.routingKeyIndexes != null) {
            if (this.statement.routingKeyIndexes.length == 1) {
                return this.values[this.statement.routingKeyIndexes[0]];
            }
            ByteBuffer[] components = new ByteBuffer[this.statement.routingKeyIndexes.length];
            for (int i = 0; i < components.length; ++i) {
                components[i] = this.values[this.statement.routingKeyIndexes[i]];
            }
            return SimpleStatement.compose(components);
        }
        return null;
    }

    public BoundStatement setBool(int i, boolean v) {
        this.metadata().checkType(i, DataType.Name.BOOLEAN);
        return this.setValue(i, BooleanType.instance.decompose(Boolean.valueOf(v)));
    }

    public BoundStatement setBool(String name, boolean v) {
        return this.setBool(this.metadata().getIdx(name), v);
    }

    public BoundStatement setInt(int i, int v) {
        this.metadata().checkType(i, DataType.Name.INT);
        return this.setValue(i, Int32Type.instance.decompose(Integer.valueOf(v)));
    }

    public BoundStatement setInt(String name, int v) {
        return this.setInt(this.metadata().getIdx(name), v);
    }

    public BoundStatement setLong(int i, long v) {
        this.metadata().checkType(i, DataType.Name.BIGINT, DataType.Name.COUNTER);
        return this.setValue(i, LongType.instance.decompose(Long.valueOf(v)));
    }

    public BoundStatement setLong(String name, long v) {
        return this.setLong(this.metadata().getIdx(name), v);
    }

    public BoundStatement setDate(int i, Date v) {
        this.metadata().checkType(i, DataType.Name.TIMESTAMP);
        return this.setValue(i, DateType.instance.decompose(v));
    }

    public BoundStatement setDate(String name, Date v) {
        return this.setDate(this.metadata().getIdx(name), v);
    }

    public BoundStatement setFloat(int i, float v) {
        this.metadata().checkType(i, DataType.Name.FLOAT);
        return this.setValue(i, FloatType.instance.decompose(Float.valueOf(v)));
    }

    public BoundStatement setFloat(String name, float v) {
        return this.setFloat(this.metadata().getIdx(name), v);
    }

    public BoundStatement setDouble(int i, double v) {
        this.metadata().checkType(i, DataType.Name.DOUBLE);
        return this.setValue(i, DoubleType.instance.decompose(Double.valueOf(v)));
    }

    public BoundStatement setDouble(String name, double v) {
        return this.setDouble(this.metadata().getIdx(name), v);
    }

    public BoundStatement setString(int i, String v) {
        DataType.Name type = this.metadata().checkType(i, DataType.Name.VARCHAR, DataType.Name.TEXT, DataType.Name.ASCII);
        switch (type) {
            case ASCII: {
                return this.setValue(i, AsciiType.instance.decompose(v));
            }
            case TEXT: 
            case VARCHAR: {
                return this.setValue(i, UTF8Type.instance.decompose(v));
            }
        }
        throw new AssertionError();
    }

    public BoundStatement setString(String name, String v) {
        return this.setString(this.metadata().getIdx(name), v);
    }

    public BoundStatement setBytes(int i, ByteBuffer v) {
        this.metadata().checkType(i, DataType.Name.BLOB);
        return this.setBytesUnsafe(i, v);
    }

    public BoundStatement setBytes(String name, ByteBuffer v) {
        return this.setBytes(this.metadata().getIdx(name), v);
    }

    public BoundStatement setBytesUnsafe(int i, ByteBuffer v) {
        return this.setValue(i, v.duplicate());
    }

    public BoundStatement setBytesUnsafe(String name, ByteBuffer v) {
        return this.setBytesUnsafe(this.metadata().getIdx(name), v);
    }

    public BoundStatement setVarint(int i, BigInteger v) {
        this.metadata().checkType(i, DataType.Name.VARINT);
        return this.setValue(i, IntegerType.instance.decompose(v));
    }

    public BoundStatement setVarint(String name, BigInteger v) {
        return this.setVarint(this.metadata().getIdx(name), v);
    }

    public BoundStatement setDecimal(int i, BigDecimal v) {
        this.metadata().checkType(i, DataType.Name.DECIMAL);
        return this.setValue(i, DecimalType.instance.decompose(v));
    }

    public BoundStatement setDecimal(String name, BigDecimal v) {
        return this.setDecimal(this.metadata().getIdx(name), v);
    }

    public BoundStatement setUUID(int i, UUID v) {
        DataType.Name type = this.metadata().checkType(i, DataType.Name.UUID, DataType.Name.TIMEUUID);
        if (type == DataType.Name.TIMEUUID && v.version() != 1) {
            throw new InvalidTypeException(String.format("%s is not a Type 1 (time-based) UUID", v));
        }
        return type == DataType.Name.UUID ? this.setValue(i, UUIDType.instance.decompose(v)) : this.setValue(i, TimeUUIDType.instance.decompose(v));
    }

    public BoundStatement setUUID(String name, UUID v) {
        return this.setUUID(this.metadata().getIdx(name), v);
    }

    public BoundStatement setInet(int i, InetAddress v) {
        this.metadata().checkType(i, DataType.Name.INET);
        return this.setValue(i, InetAddressType.instance.decompose(v));
    }

    public BoundStatement setInet(String name, InetAddress v) {
        return this.setInet(this.metadata().getIdx(name), v);
    }

    public <T> BoundStatement setList(int i, List<T> v) {
        DataType type = this.metadata().getType(i);
        if (type.getName() != DataType.Name.LIST) {
            throw new InvalidTypeException(String.format("Column %s is of type %s, cannot set to a list", this.metadata().getName(i), type));
        }
        if (!v.isEmpty()) {
            Class<?> providedClass = v.get(0).getClass();
            Class<?> expectedClass = type.getTypeArguments().get(0).asJavaClass();
            if (!expectedClass.isAssignableFrom(providedClass)) {
                throw new InvalidTypeException(String.format("Invalid value for column %s of CQL type %s, expecting list of %s but provided list of %s", this.metadata().getName(i), type, expectedClass, providedClass));
            }
        }
        return this.setValue(i, Codec.getCodec(type).decompose(v));
    }

    public <T> BoundStatement setList(String name, List<T> v) {
        return this.setList(this.metadata().getIdx(name), v);
    }

    public <K, V> BoundStatement setMap(int i, Map<K, V> v) {
        DataType type = this.metadata().getType(i);
        if (type.getName() != DataType.Name.MAP) {
            throw new InvalidTypeException(String.format("Column %s is of type %s, cannot set to a map", this.metadata().getName(i), type));
        }
        if (!v.isEmpty()) {
            Map.Entry<K, V> entry = v.entrySet().iterator().next();
            Class<?> providedKeysClass = entry.getKey().getClass();
            Class<?> providedValuesClass = entry.getValue().getClass();
            Class<?> expectedKeysClass = type.getTypeArguments().get((int)0).getName().javaType;
            Class<?> expectedValuesClass = type.getTypeArguments().get((int)1).getName().javaType;
            if (!expectedKeysClass.isAssignableFrom(providedKeysClass) || !expectedValuesClass.isAssignableFrom(providedValuesClass)) {
                throw new InvalidTypeException(String.format("Invalid value for column %s of CQL type %s, expecting map of %s->%s but provided map of %s->%s", this.metadata().getName(i), type, expectedKeysClass, expectedValuesClass, providedKeysClass, providedValuesClass));
            }
        }
        return this.setValue(i, Codec.getCodec(type).decompose(v));
    }

    public <K, V> BoundStatement setMap(String name, Map<K, V> v) {
        return this.setMap(this.metadata().getIdx(name), v);
    }

    public <T> BoundStatement setSet(int i, Set<T> v) {
        Class<?> providedClass;
        Class<?> expectedClass;
        DataType type = this.metadata().getType(i);
        if (type.getName() != DataType.Name.SET) {
            throw new InvalidTypeException(String.format("Column %s is of type %s, cannot set to a set", this.metadata().getName(i), type));
        }
        if (!v.isEmpty() && !(expectedClass = type.getTypeArguments().get((int)0).getName().javaType).isAssignableFrom(providedClass = v.iterator().next().getClass())) {
            throw new InvalidTypeException(String.format("Invalid value for column %s of CQL type %s, expecting set of %s but provided set of %s", this.metadata().getName(i), type, expectedClass, providedClass));
        }
        return this.setValue(i, Codec.getCodec(type).decompose(v));
    }

    public <T> BoundStatement setSet(String name, Set<T> v) {
        return this.setSet(this.metadata().getIdx(name), v);
    }

    private ColumnDefinitions metadata() {
        return this.statement.metadata;
    }

    private BoundStatement setValue(int i, ByteBuffer value) {
        ByteBuffer previous = this.values[i];
        this.values[i] = value;
        if (previous == null) {
            --this.remaining;
        }
        return this;
    }
}

