/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.BusyConnectionException;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Configuration;
import com.datastax.driver.core.Connection;
import com.datastax.driver.core.ConnectionException;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostConnectionPool;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Query;
import com.datastax.driver.core.RequestHandler;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.google.common.util.concurrent.Uninterruptibles;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.messages.ErrorMessage;
import org.apache.cassandra.transport.messages.ExecuteMessage;
import org.apache.cassandra.transport.messages.PrepareMessage;
import org.apache.cassandra.transport.messages.QueryMessage;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session {
    private static final Logger logger = LoggerFactory.getLogger(Session.class);
    final Manager manager;

    Session(Cluster cluster, Collection<Host> hosts) {
        this.manager = new Manager(cluster, hosts);
    }

    public ResultSet execute(String query) {
        return this.execute(new SimpleStatement(query));
    }

    public ResultSet execute(Query query) {
        return this.executeAsync(query).getUninterruptibly();
    }

    public ResultSetFuture executeAsync(String query) {
        return this.executeAsync(new SimpleStatement(query));
    }

    public ResultSetFuture executeAsync(Query query) {
        if (query instanceof Statement) {
            return this.manager.executeQuery((Message.Request)new QueryMessage(((Statement)query).getQueryString(), ConsistencyLevel.toCassandraCL(query.getConsistencyLevel())), query);
        }
        assert (query instanceof BoundStatement) : query;
        BoundStatement bs = (BoundStatement)query;
        if (!bs.isReady()) {
            throw new IllegalStateException("Some bind variables haven't been bound in the provided statement");
        }
        return this.manager.executeQuery((Message.Request)new ExecuteMessage(bs.statement.id, Arrays.asList(bs.values), ConsistencyLevel.toCassandraCL(query.getConsistencyLevel())), query);
    }

    public PreparedStatement prepare(String query) {
        Connection.Future future = new Connection.Future((Message.Request)new PrepareMessage(query));
        this.manager.execute(future, Query.DEFAULT);
        return this.toPreparedStatement(query, future);
    }

    public void shutdown() {
        this.manager.shutdown();
    }

    public Cluster getCluster() {
        return this.manager.cluster;
    }

    private PreparedStatement toPreparedStatement(String query, Connection.Future future) {
        try {
            Message.Response response = (Message.Response)Uninterruptibles.getUninterruptibly((Future)((Object)future));
            switch (response.type) {
                case RESULT: {
                    ResultMessage rm = (ResultMessage)response;
                    switch (rm.kind) {
                        case PREPARED: {
                            ResultMessage.Prepared pmsg = (ResultMessage.Prepared)rm;
                            PreparedStatement stmt = PreparedStatement.fromMessage(pmsg, this.manager.cluster.getMetadata(), query, this.manager.poolsState.keyspace);
                            try {
                                this.manager.cluster.manager.prepare(pmsg.statementId, stmt, future.getAddress());
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                            return stmt;
                        }
                    }
                    throw new DriverInternalError(String.format("%s response received when prepared statement was expected", rm.kind));
                }
                case ERROR: {
                    ResultSetFuture.extractCause(ResultSetFuture.convertException(((ErrorMessage)response).error));
                    break;
                }
                default: {
                    throw new DriverInternalError(String.format("%s response received when prepared statement was expected", response.type));
                }
            }
            throw new AssertionError();
        }
        catch (ExecutionException e) {
            ResultSetFuture.extractCauseFromExecutionException(e);
            throw new AssertionError();
        }
    }

    static class Manager
    implements Host.StateListener {
        final Cluster cluster;
        final ConcurrentMap<Host, HostConnectionPool> pools;
        final LoadBalancingPolicy loadBalancer;
        final HostConnectionPool.PoolState poolsState;
        final AtomicBoolean isShutdown = new AtomicBoolean(false);

        public Manager(Cluster cluster, Collection<Host> hosts) {
            this.cluster = cluster;
            this.pools = new ConcurrentHashMap<Host, HostConnectionPool>(hosts.size());
            this.loadBalancer = cluster.manager.configuration.getPolicies().getLoadBalancingPolicy();
            this.poolsState = new HostConnectionPool.PoolState();
            for (Host host : hosts) {
                this.addOrRenewPool(host);
            }
        }

        public Connection.Factory connectionFactory() {
            return this.cluster.manager.connectionFactory;
        }

        public Configuration configuration() {
            return this.cluster.manager.configuration;
        }

        public ExecutorService executor() {
            return this.cluster.manager.executor;
        }

        private void shutdown() {
            if (!this.isShutdown.compareAndSet(false, true)) {
                return;
            }
            for (HostConnectionPool pool : this.pools.values()) {
                pool.shutdown();
            }
        }

        private void addOrRenewPool(Host host) {
            try {
                HostDistance distance = this.loadBalancer.distance(host);
                if (distance != HostDistance.IGNORED) {
                    logger.debug("Adding {} to list of queried hosts", (Object)host);
                    HostConnectionPool previous = this.pools.put(host, new HostConnectionPool(host, distance, this));
                    if (previous != null) {
                        previous.shutdown();
                    }
                }
            }
            catch (AuthenticationException e) {
                logger.error("Error creating pool to {} ({})", (Object)host, (Object)e.getMessage());
                host.getMonitor().signalConnectionFailure(new ConnectionException(e.getHost(), e.getMessage()));
            }
            catch (ConnectionException e) {
                logger.debug("Error creating pool to {} ({})", (Object)host, (Object)e.getMessage());
                host.getMonitor().signalConnectionFailure(e);
            }
        }

        private void removePool(Host host) {
            HostConnectionPool pool = (HostConnectionPool)this.pools.remove(host);
            if (pool != null) {
                pool.shutdown();
            }
        }

        private void updateCreatedPools() {
            for (Host h : this.cluster.getMetadata().allHosts()) {
                HostDistance dist = this.loadBalancer.distance(h);
                HostConnectionPool pool = (HostConnectionPool)this.pools.get(h);
                if (pool == null) {
                    if (dist == HostDistance.IGNORED || !h.getMonitor().isUp()) continue;
                    this.addOrRenewPool(h);
                    continue;
                }
                if (dist == pool.hostDistance) continue;
                if (dist == HostDistance.IGNORED) {
                    this.removePool(h);
                    continue;
                }
                pool.hostDistance = dist;
            }
        }

        @Override
        public void onUp(Host host) {
            this.addOrRenewPool(host);
            this.loadBalancer.onUp(host);
            this.updateCreatedPools();
        }

        @Override
        public void onDown(Host host) {
            this.loadBalancer.onDown(host);
            this.removePool(host);
            this.updateCreatedPools();
        }

        @Override
        public void onAdd(Host host) {
            this.addOrRenewPool(host);
            this.loadBalancer.onAdd(host);
            this.updateCreatedPools();
        }

        @Override
        public void onRemove(Host host) {
            this.loadBalancer.onRemove(host);
            this.removePool(host);
            this.updateCreatedPools();
        }

        public void setKeyspace(String keyspace) {
            try {
                Uninterruptibles.getUninterruptibly((Future)((Object)this.executeQuery((Message.Request)new QueryMessage("use " + keyspace, ConsistencyLevel.DEFAULT_CASSANDRA_CL), Query.DEFAULT)));
            }
            catch (ExecutionException e) {
                ResultSetFuture.extractCauseFromExecutionException(e);
            }
        }

        public void execute(RequestHandler.Callback callback, Query query) {
            new RequestHandler(this, callback, query).sendRequest();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void prepare(String query, InetAddress toExclude) throws InterruptedException {
            Iterator i$ = this.pools.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry entry = i$.next();
                if (((Host)entry.getKey()).getAddress().equals(toExclude)) continue;
                Connection c = null;
                try {
                    c = ((HostConnectionPool)entry.getValue()).borrowConnection(200L, TimeUnit.MILLISECONDS);
                    c.write((Message.Request)new PrepareMessage(query)).get();
                    continue;
                }
                catch (ConnectionException e) {
                    continue;
                }
                catch (BusyConnectionException e) {
                    continue;
                }
                catch (TimeoutException e) {
                    continue;
                }
                catch (ExecutionException e) {
                    logger.error(String.format("Unexpected error while preparing query (%s) on %s", query, entry.getKey()), (Throwable)e);
                    continue;
                }
                finally {
                    if (c == null) continue;
                    ((HostConnectionPool)entry.getValue()).returnConnection(c);
                    continue;
                }
                break;
            }
            return;
        }

        public ResultSetFuture executeQuery(Message.Request msg, Query query) {
            if (query.isTracing()) {
                msg.setTracingRequested();
            }
            ResultSetFuture future = new ResultSetFuture(this, msg);
            this.execute(future.callback, query);
            return future;
        }
    }
}

