/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Statement;
import java.nio.ByteBuffer;

public class SimpleStatement
extends Statement {
    private final String query;
    private volatile ByteBuffer routingKey;

    public SimpleStatement(String query) {
        this.query = query;
    }

    @Override
    public String getQueryString() {
        return this.query;
    }

    @Override
    public ByteBuffer getRoutingKey() {
        return this.routingKey;
    }

    public SimpleStatement setRoutingKey(ByteBuffer routingKey) {
        this.routingKey = routingKey;
        return this;
    }

    public SimpleStatement setRoutingKey(ByteBuffer ... routingKeyComponents) {
        this.routingKey = SimpleStatement.compose(routingKeyComponents);
        return this;
    }

    static ByteBuffer compose(ByteBuffer ... buffers) {
        int totalLength = 0;
        for (ByteBuffer bb : buffers) {
            totalLength += 2 + bb.remaining() + 1;
        }
        ByteBuffer out = ByteBuffer.allocate(totalLength);
        for (ByteBuffer bb : buffers) {
            SimpleStatement.putShortLength(out, bb.remaining());
            out.put(bb);
            out.put((byte)0);
        }
        out.flip();
        return out;
    }

    private static void putShortLength(ByteBuffer bb, int length) {
        bb.put((byte)(length >> 8 & 0xFF));
        bb.put((byte)(length & 0xFF));
    }
}

