/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.querybuilder;

import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.querybuilder.BuiltStatement;
import com.datastax.driver.core.querybuilder.Clause;
import com.datastax.driver.core.querybuilder.Using;
import com.datastax.driver.core.querybuilder.Utils;
import java.util.ArrayList;
import java.util.List;

public class Delete
extends BuiltStatement {
    private final String keyspace;
    private final String table;
    private final List<Object> columnNames;
    private final Where where;
    private final Options usings;

    Delete(String keyspace, String table, List<Object> columnNames) {
        this.keyspace = keyspace;
        this.table = table;
        this.columnNames = columnNames;
        this.where = new Where(this);
        this.usings = new Options(this);
    }

    Delete(TableMetadata table, List<Object> columnNames) {
        super(table);
        this.keyspace = table.getKeyspace().getName();
        this.table = table.getName();
        this.columnNames = columnNames;
        this.where = new Where(this);
        this.usings = new Options(this);
    }

    @Override
    protected String buildQueryString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DELETE ");
        if (this.columnNames != null) {
            Utils.joinAndAppendNames(builder, ",", this.columnNames);
        }
        builder.append(" FROM ");
        if (this.keyspace != null) {
            Utils.appendName(this.keyspace, builder).append(".");
        }
        Utils.appendName(this.table, builder);
        if (!this.usings.usings.isEmpty()) {
            builder.append(" USING ");
            Utils.joinAndAppend(builder, " AND ", this.usings.usings);
        }
        if (!this.where.clauses.isEmpty()) {
            builder.append(" WHERE ");
            Utils.joinAndAppend(builder, " AND ", this.where.clauses);
        }
        return builder.toString();
    }

    public Where where(Clause clause) {
        return this.where.and(clause);
    }

    public Where where() {
        return this.where;
    }

    public Options using(Using using) {
        return this.usings.and(using);
    }

    public static class Selection
    extends Builder {
        public Builder all() {
            if (this.columnNames != null) {
                throw new IllegalStateException(String.format("Some columns (%s) have already been selected.", this.columnNames));
            }
            return this;
        }

        public Selection column(String name) {
            if (this.columnNames == null) {
                this.columnNames = new ArrayList();
            }
            this.columnNames.add(name);
            return this;
        }

        public Selection listElt(String columnName, int idx) {
            StringBuilder sb = new StringBuilder();
            Utils.appendName(columnName, sb);
            return this.column(sb.append("[").append(idx).append("]").toString());
        }

        public Selection mapElt(String columnName, Object key) {
            StringBuilder sb = new StringBuilder();
            Utils.appendName(columnName, sb);
            sb.append("[");
            Utils.appendFlatValue(key, sb);
            return this.column(sb.append("]").toString());
        }
    }

    public static class Builder {
        protected List<Object> columnNames;

        protected Builder() {
        }

        Builder(List<Object> columnNames) {
            this.columnNames = columnNames;
        }

        public Delete from(String table) {
            return this.from(null, table);
        }

        public Delete from(String keyspace, String table) {
            return new Delete(keyspace, table, this.columnNames);
        }

        public Delete from(TableMetadata table) {
            return new Delete(table, this.columnNames);
        }
    }

    public static class Options
    extends BuiltStatement.ForwardingStatement<Delete> {
        private final List<Using> usings = new ArrayList<Using>();

        Options(Delete statement) {
            super(statement);
        }

        public Options and(Using using) {
            this.usings.add(using);
            this.setDirty();
            return this;
        }

        public Where where(Clause clause) {
            return ((Delete)this.statement).where(clause);
        }
    }

    public static class Where
    extends BuiltStatement.ForwardingStatement<Delete> {
        private final List<Clause> clauses = new ArrayList<Clause>();

        Where(Delete statement) {
            super(statement);
        }

        public Where and(Clause clause) {
            this.clauses.add(clause);
            ((Delete)this.statement).maybeAddRoutingKey(clause.name(), clause.firstValue());
            this.setDirty();
            return this;
        }

        public Options using(Using using) {
            return ((Delete)this.statement).using(using);
        }
    }
}

