/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Query;
import com.datastax.driver.core.WriteType;
import com.datastax.driver.core.policies.RetryPolicy;

public class DowngradingConsistencyRetryPolicy
implements RetryPolicy {
    public static final DowngradingConsistencyRetryPolicy INSTANCE = new DowngradingConsistencyRetryPolicy();

    private DowngradingConsistencyRetryPolicy() {
    }

    private RetryPolicy.RetryDecision maxLikelyToWorkCL(int knownOk) {
        if (knownOk >= 3) {
            return RetryPolicy.RetryDecision.retry(ConsistencyLevel.THREE);
        }
        if (knownOk >= 2) {
            return RetryPolicy.RetryDecision.retry(ConsistencyLevel.TWO);
        }
        if (knownOk >= 1) {
            return RetryPolicy.RetryDecision.retry(ConsistencyLevel.ONE);
        }
        return RetryPolicy.RetryDecision.rethrow();
    }

    @Override
    public RetryPolicy.RetryDecision onReadTimeout(Query query, ConsistencyLevel cl, int requiredResponses, int receivedResponses, boolean dataRetrieved, int nbRetry) {
        if (nbRetry != 0) {
            return RetryPolicy.RetryDecision.rethrow();
        }
        if (receivedResponses < requiredResponses) {
            return this.maxLikelyToWorkCL(receivedResponses);
        }
        return !dataRetrieved ? RetryPolicy.RetryDecision.retry(cl) : RetryPolicy.RetryDecision.rethrow();
    }

    @Override
    public RetryPolicy.RetryDecision onWriteTimeout(Query query, ConsistencyLevel cl, WriteType writeType, int requiredAcks, int receivedAcks, int nbRetry) {
        if (nbRetry != 0) {
            return RetryPolicy.RetryDecision.rethrow();
        }
        switch (writeType) {
            case SIMPLE: 
            case BATCH: {
                return RetryPolicy.RetryDecision.ignore();
            }
            case COUNTER: {
                return RetryPolicy.RetryDecision.ignore();
            }
            case UNLOGGED_BATCH: {
                return this.maxLikelyToWorkCL(receivedAcks);
            }
            case BATCH_LOG: {
                return RetryPolicy.RetryDecision.retry(cl);
            }
        }
        return RetryPolicy.RetryDecision.rethrow();
    }

    @Override
    public RetryPolicy.RetryDecision onUnavailable(Query query, ConsistencyLevel cl, int requiredReplica, int aliveReplica, int nbRetry) {
        if (nbRetry != 0) {
            return RetryPolicy.RetryDecision.rethrow();
        }
        return this.maxLikelyToWorkCL(aliveReplica);
    }
}

