/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.querybuilder;

import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.querybuilder.BuiltStatement;
import com.datastax.driver.core.querybuilder.Utils;

public class Truncate
extends BuiltStatement {
    private final String keyspace;
    private final String table;

    Truncate(String keyspace, String table) {
        this.keyspace = keyspace;
        this.table = table;
    }

    Truncate(TableMetadata table) {
        super(table);
        this.keyspace = table.getKeyspace().getName();
        this.table = table.getName();
    }

    @Override
    protected StringBuilder buildQueryString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TRUNCATE ");
        if (this.keyspace != null) {
            Utils.appendName(this.keyspace, builder).append(".");
        }
        Utils.appendName(this.table, builder);
        return builder;
    }
}

