/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.protocol;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.internal.core.protocol.BuiltInCompressors;
import com.datastax.oss.driver.internal.core.protocol.Lz4Compressor;
import com.datastax.oss.driver.internal.core.protocol.SnappyCompressor;
import com.datastax.oss.driver.internal.core.util.DependencyCheck;
import com.datastax.oss.driver.shaded.netty.buffer.ByteBuf;
import com.datastax.oss.protocol.internal.Compressor;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.util.Locale;
import java.util.function.BooleanSupplier;

public class CompressorSubstitutions {

    public static class Lz4Missing
    extends Lz4Present {
        @Override
        public boolean getAsBoolean() {
            return !super.getAsBoolean();
        }
    }

    public static class Lz4Present
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return DependencyCheck.LZ4.isPresent();
        }
    }

    @TargetClass(value=SnappyCompressor.class)
    @Delete
    public static final class DeleteSnappyCompressor {
    }

    @TargetClass(value=Lz4Compressor.class, onlyWith={Lz4Missing.class})
    @Delete
    public static final class DeleteLz4Compressor {
    }

    @TargetClass(value=BuiltInCompressors.class, onlyWith={Lz4Missing.class})
    public static final class NoBuiltInCompressors {
        @Substitute
        public static Compressor<ByteBuf> newInstance(String name, DriverContext context) {
            switch (name.toLowerCase(Locale.ROOT)) {
                case "lz4": {
                    throw new UnsupportedOperationException("This native image was not built with support for LZ4 compression");
                }
                case "snappy": {
                    throw new UnsupportedOperationException("Snappy compression is not supported for native images");
                }
                case "none": {
                    return Compressor.none();
                }
            }
            throw new IllegalArgumentException(String.format("Unsupported compression algorithm '%s' (from configuration option %s)", name, DefaultDriverOption.PROTOCOL_COMPRESSION.getPath()));
        }
    }

    @TargetClass(value=BuiltInCompressors.class, onlyWith={Lz4Present.class})
    public static final class BuiltInCompressorsLz4Only {
        @Substitute
        public static Compressor<ByteBuf> newInstance(String name, DriverContext context) {
            switch (name.toLowerCase(Locale.ROOT)) {
                case "lz4": {
                    return new Lz4Compressor(context);
                }
                case "snappy": {
                    throw new UnsupportedOperationException("Snappy compression is not supported for native images");
                }
                case "none": {
                    return Compressor.none();
                }
            }
            throw new IllegalArgumentException(String.format("Unsupported compression algorithm '%s' (from configuration option %s)", name, DefaultDriverOption.PROTOCOL_COMPRESSION.getPath()));
        }
    }
}

