/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util.concurrent;

import com.datastax.oss.driver.shaded.netty.util.concurrent.Future;
import com.datastax.oss.driver.shaded.netty.util.concurrent.GenericFutureListener;
import com.datastax.oss.driver.shaded.netty.util.concurrent.Promise;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class PromiseCombiner {
    public static void combine(@NonNull Promise<Void> aggregatePromise, Future<?> ... parents) {
        PromiseCombinerListener listener = new PromiseCombinerListener(aggregatePromise, parents.length);
        for (Future<?> parent : parents) {
            parent.addListener(listener);
        }
    }

    private static class PromiseCombinerListener
    implements GenericFutureListener<Future<Object>> {
        private final Promise<Void> aggregatePromise;
        private final AtomicInteger remainingCount;
        private final AtomicReference<Throwable> aggregateFailureRef = new AtomicReference();

        private PromiseCombinerListener(Promise<Void> aggregatePromise, int numberOfParents) {
            this.aggregatePromise = aggregatePromise;
            this.remainingCount = new AtomicInteger(numberOfParents);
        }

        @Override
        public void operationComplete(Future<Object> future) {
            if (!future.isSuccess()) {
                this.aggregateFailureRef.updateAndGet(aggregateFailure -> {
                    if (aggregateFailure == null) {
                        aggregateFailure = future.cause();
                    } else {
                        aggregateFailure.addSuppressed(future.cause());
                    }
                    return aggregateFailure;
                });
            }
            if (this.remainingCount.decrementAndGet() == 0) {
                Throwable aggregateFailure2 = this.aggregateFailureRef.get();
                if (aggregateFailure2 != null) {
                    this.aggregatePromise.tryFailure(aggregateFailure2);
                } else {
                    this.aggregatePromise.trySuccess(null);
                }
            }
        }
    }
}

