/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metrics;

import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metrics.Metrics;
import com.datastax.oss.driver.internal.core.metrics.DropwizardMetricsFactory;
import com.datastax.oss.driver.internal.core.metrics.MetricsFactory;
import com.datastax.oss.driver.internal.core.metrics.NodeMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.NoopMetricsFactory;
import com.datastax.oss.driver.internal.core.metrics.SessionMetricUpdater;
import com.datastax.oss.driver.internal.core.util.DependencyCheck;
import java.util.Optional;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DefaultMetricsFactory
implements MetricsFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMetricsFactory.class);
    private final MetricsFactory delegate;

    public DefaultMetricsFactory(DriverContext context) {
        this.delegate = DependencyCheck.DROPWIZARD.isPresent() ? new DropwizardMetricsFactory(context) : new NoopMetricsFactory(context);
        LOG.debug("[{}] Using {}", (Object)context.getSessionName(), (Object)this.delegate.getClass().getSimpleName());
    }

    @Override
    public Optional<Metrics> getMetrics() {
        return this.delegate.getMetrics();
    }

    @Override
    public SessionMetricUpdater getSessionUpdater() {
        return this.delegate.getSessionUpdater();
    }

    @Override
    public NodeMetricUpdater newNodeUpdater(Node node) {
        return this.delegate.newNodeUpdater(node);
    }
}

