/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.datastax.dse.driver.internal.core.cql.continuous.reactive;

import com.datastax.dse.driver.api.core.cql.continuous.ContinuousAsyncResultSet;
import com.datastax.dse.driver.api.core.cql.continuous.reactive.ContinuousReactiveResultSet;
import com.datastax.dse.driver.internal.core.cql.reactive.ReactiveResultSetBase;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DefaultContinuousReactiveResultSet
    extends ReactiveResultSetBase<ContinuousAsyncResultSet> implements ContinuousReactiveResultSet {

  public DefaultContinuousReactiveResultSet(
      Callable<CompletionStage<ContinuousAsyncResultSet>> firstPage) {
    super(firstPage);
  }
}
