/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.cql;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.RelationMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.ViewMetadata;
import com.datastax.spark.connector.cql.ClusteringColumn;
import com.datastax.spark.connector.cql.ClusteringColumn$;
import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.cql.ColumnDef$;
import com.datastax.spark.connector.cql.IndexDef;
import com.datastax.spark.connector.cql.KeyspaceDef;
import com.datastax.spark.connector.cql.PartitionKeyColumn$;
import com.datastax.spark.connector.cql.RegularColumn$;
import com.datastax.spark.connector.cql.Schema;
import com.datastax.spark.connector.cql.StaticColumn$;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.cql.TableDef$;
import com.datastax.spark.connector.types.UserDefinedType;
import com.datastax.spark.connector.types.UserDefinedType$;
import com.datastax.spark.connector.util.DriverUtil$;
import com.datastax.spark.connector.util.Logging;
import com.datastax.spark.connector.util.NameTools;
import com.datastax.spark.connector.util.NameTools$;
import java.io.IOException;
import java.io.Serializable;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.runtime.BoxesRunTime;

public final class Schema$
implements Logging,
scala.Serializable {
    public static Schema$ MODULE$;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;

    static {
        new Schema$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    @Override
    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    private Seq<ColumnDef> fetchPartitionKey(RelationMetadata table) {
        return (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(table.getPartitionKey()).asScala()).map((Function1 & Serializable & scala.Serializable)column -> ColumnDef$.MODULE$.apply((ColumnMetadata)column, PartitionKeyColumn$.MODULE$), Buffer$.MODULE$.canBuildFrom());
    }

    private Seq<ColumnDef> fetchClusteringColumns(RelationMetadata table) {
        return (Seq)((TraversableLike)((scala.collection.mutable.MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(table.getClusteringColumns()).asScala()).toSeq().zipWithIndex(Seq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Schema$.$anonfun$fetchClusteringColumns$1(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Tuple2 column = (Tuple2)tuple2._1();
            int index = tuple2._2$mcI$sp();
            ColumnDef columnDef = ColumnDef$.MODULE$.apply((ColumnMetadata)column._1(), new ClusteringColumn(index, ClusteringColumn$.MODULE$.apply$default$2()));
            return columnDef;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Seq<ColumnDef> fetchRegularColumns(RelationMetadata table) {
        Set primaryKey = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(table.getPrimaryKey()).asScala()).toSet();
        Seq regularColumns = (Seq)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(table.getColumns()).asScala()).values().toSeq().filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)primaryKey.contains((Object)elem)));
        return (Seq)regularColumns.map((Function1 & Serializable & scala.Serializable)column -> column.isStatic() ? ColumnDef$.MODULE$.apply((ColumnMetadata)column, StaticColumn$.MODULE$) : ColumnDef$.MODULE$.apply((ColumnMetadata)column, RegularColumn$.MODULE$), Seq$.MODULE$.canBuildFrom());
    }

    private String handleId(TableMetadata table, String columnName) {
        return (String)Option$.MODULE$.apply((Object)table.getColumn(CqlIdentifier.fromInternal((String)columnName))).flatMap((Function1 & Serializable & scala.Serializable)optional -> DriverUtil$.MODULE$.toOption(optional)).map((Function1 & Serializable & scala.Serializable)c -> DriverUtil$.MODULE$.toName(c.getName())).getOrElse((Function0 & Serializable & scala.Serializable)() -> columnName);
    }

    private Seq<IndexDef> getIndexDefs(RelationMetadata tableOrView) {
        Seq seq;
        RelationMetadata relationMetadata = tableOrView;
        if (relationMetadata instanceof TableMetadata) {
            TableMetadata tableMetadata = (TableMetadata)relationMetadata;
            seq = (Seq)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(tableMetadata.getIndexes()).asScala()).values().toSeq().map((Function1 & Serializable & scala.Serializable)index -> {
                Option className = DriverUtil$.MODULE$.toOption(index.getClassName());
                String target = MODULE$.handleId(tableMetadata, index.getTarget());
                return new IndexDef(className, target, DriverUtil$.MODULE$.toName(index.getName()), (Map<String, String>)Predef$.MODULE$.Map().empty());
            }, Seq$.MODULE$.canBuildFrom());
        } else if (relationMetadata instanceof ViewMetadata) {
            seq = (Seq)Seq$.MODULE$.empty();
        } else {
            throw new MatchError((Object)relationMetadata);
        }
        return seq;
    }

    public TableDef fetchTable(CqlIdentifier keyspace, RelationMetadata table) {
        Seq<ColumnDef> partitionKey = this.fetchPartitionKey(table);
        Seq<ColumnDef> clusteringColumns = this.fetchClusteringColumns(table);
        Seq<ColumnDef> regularColumns = this.fetchRegularColumns(table);
        Seq<IndexDef> indexDefs = this.getIndexDefs(table);
        RelationMetadata relationMetadata = table;
        boolean bl = relationMetadata instanceof ViewMetadata;
        boolean isView = bl;
        return new TableDef(DriverUtil$.MODULE$.toName(keyspace), DriverUtil$.MODULE$.toName(table.getName()), partitionKey, clusteringColumns, regularColumns, indexDefs, isView, TableDef$.MODULE$.apply$default$8(), TableDef$.MODULE$.apply$default$9());
    }

    private boolean isTableSelected(RelationMetadata table, Option<String> selected) {
        boolean bl;
        Option<String> option = selected;
        if (None$.MODULE$.equals(option)) {
            bl = true;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String name = (String)some.value();
            String string = DriverUtil$.MODULE$.toName(table.getName());
            String string2 = name;
            bl = !(string != null ? !string.equals(string2) : string2 != null);
        } else {
            throw new MatchError(option);
        }
        return bl;
    }

    private Set<TableDef> fetchTables(KeyspaceMetadata keyspace, Option<String> selected) {
        return (Set)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(keyspace.getTables()).asScala()).toSet().$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(keyspace.getViews()).asScala()).toSet()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)Schema$.$anonfun$fetchTables$1(check$ifrefutable$2))).withFilter((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)Schema$.$anonfun$fetchTables$2(selected, x$13))).map((Function1 & Serializable & scala.Serializable)x$14 -> {
            Tuple2 tuple2 = x$14;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            RelationMetadata table = (RelationMetadata)tuple2._2();
            TableDef tableDef = MODULE$.fetchTable(keyspace.getName(), table);
            return tableDef;
        }, Set$.MODULE$.canBuildFrom());
    }

    private Option<String> fetchTables$default$2() {
        return None$.MODULE$;
    }

    public UserDefinedType fetchUserType(com.datastax.oss.driver.api.core.type.UserDefinedType driverUserType) {
        return UserDefinedType$.MODULE$.apply(driverUserType);
    }

    private Set<UserDefinedType> fetchUserTypes(KeyspaceMetadata metadata) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(metadata.getUserDefinedTypes()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            com.datastax.oss.driver.api.core.type.UserDefinedType driverUserType = (com.datastax.oss.driver.api.core.type.UserDefinedType)tuple2._2();
            UserDefinedType userDefinedType = MODULE$.fetchUserType(driverUserType);
            return userDefinedType;
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    private Set<String> systemKeyspaces() {
        return Predef$.MODULE$.Set().empty();
    }

    public KeyspaceDef fetchKeyspace(KeyspaceMetadata keyspace, Option<String> selectedTable) {
        return new KeyspaceDef(DriverUtil$.MODULE$.toName(keyspace.getName()), this.fetchTables(keyspace, selectedTable), this.fetchUserTypes(keyspace), this.systemKeyspaces().contains((Object)DriverUtil$.MODULE$.toName(keyspace.getName())));
    }

    public Option<String> fetchKeyspace$default$2() {
        return None$.MODULE$;
    }

    public Schema fromCassandra(CqlSession session, Option<String> keyspaceName, Option<String> tableName) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Retrieving database schema");
        Schema scheme = Schema$.fetchSchema$1((Function0 & Serializable & scala.Serializable)() -> session.refreshSchema(), tableName, keyspaceName);
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append(scheme.keyspaces().size()).append(" keyspaces fetched: ").append(((TraversableOnce)scheme.keyspaces().map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.keyspaceName(), Set$.MODULE$.canBuildFrom())).mkString("{", ",", "}")).toString());
        return scheme;
    }

    public Option<String> fromCassandra$default$2() {
        return None$.MODULE$;
    }

    public Option<String> fromCassandra$default$3() {
        return None$.MODULE$;
    }

    public TableDef tableFromCassandra(CqlSession session, String keyspaceName, String tableName) {
        TableDef t;
        Option option = this.fromCassandra(session, (Option<String>)new Some((Object)keyspaceName), (Option<String>)new Some((Object)tableName)).tables().headOption();
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                Metadata metadata = session.getMetadata();
                Option<NameTools.Suggestions> suggestions = NameTools$.MODULE$.getSuggestions(metadata, keyspaceName, tableName);
                String errorMessage = NameTools$.MODULE$.getErrorString(keyspaceName, (Option<String>)new Some((Object)tableName), suggestions);
                throw new IOException(errorMessage);
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        TableDef tableDef = t = (TableDef)some.value();
        return tableDef;
    }

    public Schema apply(Set<KeyspaceDef> keyspaces) {
        return new Schema(keyspaces);
    }

    public Option<Set<KeyspaceDef>> unapply(Schema x$0) {
        return x$0 == null ? None$.MODULE$ : new Some(x$0.keyspaces());
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$fetchClusteringColumns$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$fetchTables$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$fetchTables$2(Option selected$1, Tuple2 x$13) {
        Tuple2 tuple2 = x$13;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RelationMetadata table = (RelationMetadata)tuple2._2();
        boolean bl = MODULE$.isTableSelected(table, (Option<String>)selected$1);
        return bl;
    }

    private static final boolean isKeyspaceSelected$1(KeyspaceMetadata keyspace, Option keyspaceName$1) {
        boolean bl;
        Option option = keyspaceName$1;
        if (None$.MODULE$.equals(option)) {
            bl = true;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String name = (String)some.value();
            String string = DriverUtil$.MODULE$.toName(keyspace.getName());
            String string2 = name;
            bl = !(string != null ? !string.equals(string2) : string2 != null);
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$fromCassandra$1(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$fromCassandra$2(Option keyspaceName$1, Tuple2 x$15) {
        Tuple2 tuple2 = x$15;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        KeyspaceMetadata keyspace = (KeyspaceMetadata)tuple2._2();
        boolean bl = Schema$.isKeyspaceSelected$1(keyspace, keyspaceName$1);
        return bl;
    }

    private static final Set fetchKeyspaces$1(Metadata metadata, Option tableName$1, Option keyspaceName$1) {
        return (Set)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(metadata.getKeyspaces()).asScala()).toSet().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)Schema$.$anonfun$fromCassandra$1(check$ifrefutable$3))).withFilter((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)Schema$.$anonfun$fromCassandra$2(keyspaceName$1, x$15))).map((Function1 & Serializable & scala.Serializable)x$16 -> {
            Tuple2 tuple2 = x$16;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            KeyspaceMetadata keyspace = (KeyspaceMetadata)tuple2._2();
            KeyspaceDef keyspaceDef = MODULE$.fetchKeyspace(keyspace, (Option<String>)tableName$1);
            return keyspaceDef;
        }, Set$.MODULE$.canBuildFrom());
    }

    private static final Schema fetchSchema$1(Function0 metadata, Option tableName$1, Option keyspaceName$1) {
        return new Schema((Set<KeyspaceDef>)Schema$.fetchKeyspaces$1((Metadata)metadata.apply(), tableName$1, keyspaceName$1));
    }

    private Schema$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

