/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.rdd.partitioner;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.rdd.partitioner.DataSizeEstimates$;
import com.datastax.spark.connector.rdd.partitioner.DataSizeEstimates$TokenRangeSizeEstimate$;
import com.datastax.spark.connector.rdd.partitioner.dht.Token;
import com.datastax.spark.connector.rdd.partitioner.dht.TokenFactory;
import org.apache.spark.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\t-c\u0001B\u0001\u0003\u0001=\u0011\u0011\u0003R1uCNK'0Z#ti&l\u0017\r^3t\u0015\t\u0019A!A\u0006qCJ$\u0018\u000e^5p]\u0016\u0014(BA\u0003\u0007\u0003\r\u0011H\r\u001a\u0006\u0003\u000f!\t\u0011bY8o]\u0016\u001cGo\u001c:\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003!!\u0017\r^1ti\u0006D(\"A\u0007\u0002\u0007\r|Wn\u0001\u0001\u0016\u0007AitiE\u0002\u0001#]\u0001\"AE\u000b\u000e\u0003MQ\u0011\u0001F\u0001\u0006g\u000e\fG.Y\u0005\u0003-M\u0011a!\u00118z%\u00164\u0007C\u0001\r\u001f\u001b\u0005I\"BA\u0005\u001b\u0015\tYB$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002;\u0005\u0019qN]4\n\u0005}I\"a\u0002'pO\u001eLgn\u001a\u0005\tC\u0001\u0011\t\u0011)A\u0005E\u0005!1m\u001c8o!\t\u0019c%D\u0001%\u0015\t)c!A\u0002dc2L!a\n\u0013\u0003%\r\u000b7o]1oIJ\f7i\u001c8oK\u000e$xN\u001d\u0005\tS\u0001\u0011\t\u0011)A\u0005U\u0005a1.Z=ta\u0006\u001cWMT1nKB\u00111F\f\b\u0003%1J!!L\n\u0002\rA\u0013X\rZ3g\u0013\ty\u0003G\u0001\u0004TiJLgn\u001a\u0006\u0003[MA\u0001B\r\u0001\u0003\u0002\u0003\u0006IAK\u0001\ni\u0006\u0014G.\u001a(b[\u0016D\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006Y!N\u0001\ri>\\WM\u001c$bGR|'/\u001f\t\u0005meZd)D\u00018\u0015\tA$!A\u0002eQRL!AO\u001c\u0003\u0019Q{7.\u001a8GC\u000e$xN]=\u0011\u0005qjD\u0002\u0001\u0003\u0006}\u0001\u0011\ra\u0010\u0002\u0002-F\u0011\u0001i\u0011\t\u0003%\u0005K!AQ\n\u0003\u000f9{G\u000f[5oOB\u0011!\u0003R\u0005\u0003\u000bN\u00111!\u00118z!\tat\tB\u0003I\u0001\t\u0007\u0011JA\u0001U#\t\u0001%\nE\u00027\u0017nJ!\u0001T\u001c\u0003\u000bQ{7.\u001a8\t\u000b9\u0003A\u0011A(\u0002\rqJg.\u001b;?)\u0011\u0001F+\u0016,\u0015\u0005E\u001b\u0006\u0003\u0002*\u0001w\u0019k\u0011A\u0001\u0005\u0006i5\u0003\u001d!\u000e\u0005\u0006C5\u0003\rA\t\u0005\u0006S5\u0003\rA\u000b\u0005\u0006e5\u0003\rA\u000b\u0004\u00051\u0002!\u0015L\u0001\fU_.,gNU1oO\u0016\u001c\u0016N_3FgRLW.\u0019;f'\u00119\u0016CW/\u0011\u0005IY\u0016B\u0001/\u0014\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\u00050\n\u0005}\u001b\"\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002C1X\u0005+\u0007I\u0011\u00012\u0002\u0015I\fgnZ3Ti\u0006\u0014H/F\u0001G\u0011!!wK!E!\u0002\u00131\u0015a\u0003:b]\u001e,7\u000b^1si\u0002B\u0001BZ,\u0003\u0016\u0004%\tAY\u0001\te\u0006tw-Z#oI\"A\u0001n\u0016B\tB\u0003%a)A\u0005sC:<W-\u00128eA!A!n\u0016BK\u0002\u0013\u00051.A\bqCJ$\u0018\u000e^5p]N\u001cu.\u001e8u+\u0005a\u0007C\u0001\nn\u0013\tq7C\u0001\u0003M_:<\u0007\u0002\u00039X\u0005#\u0005\u000b\u0011\u00027\u0002!A\f'\u000f^5uS>t7oQ8v]R\u0004\u0003\u0002\u0003:X\u0005+\u0007I\u0011A6\u0002#5,\u0017M\u001c)beRLG/[8o'&TX\r\u0003\u0005u/\nE\t\u0015!\u0003m\u0003IiW-\u00198QCJ$\u0018\u000e^5p]NK'0\u001a\u0011\t\u000b9;F\u0011\u0001<\u0015\u000b]L(p\u001f?\u0011\u0005a<V\"\u0001\u0001\t\u000b\u0005,\b\u0019\u0001$\t\u000b\u0019,\b\u0019\u0001$\t\u000b),\b\u0019\u00017\t\u000bI,\b\u0019\u00017\t\u000by<F\u0011A@\u0002\u0019ILgn\u001a$sC\u000e$\u0018n\u001c8\u0016\u0005\u0005\u0005\u0001c\u0001\n\u0002\u0004%\u0019\u0011QA\n\u0003\r\u0011{WO\u00197f\u0011\u0019\tIa\u0016C\u0001W\u0006\u0001Bo\u001c;bYNK'0Z%o\u0005f$Xm\u001d\u0005\n\u0003\u001b9\u0016\u0011!C\u0001\u0003\u001f\tAaY8qsRIq/!\u0005\u0002\u0014\u0005U\u0011q\u0003\u0005\tC\u0006-\u0001\u0013!a\u0001\r\"Aa-a\u0003\u0011\u0002\u0003\u0007a\t\u0003\u0005k\u0003\u0017\u0001\n\u00111\u0001m\u0011!\u0011\u00181\u0002I\u0001\u0002\u0004a\u0007\"CA\u000e/F\u0005I\u0011AA\u000f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\b+\u0007\u0019\u000b\tc\u000b\u0002\u0002$A!\u0011QEA\u0018\u001b\t\t9C\u0003\u0003\u0002*\u0005-\u0012!C;oG\",7m[3e\u0015\r\ticE\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0019\u0003O\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\t)dVI\u0001\n\u0003\ti\"\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\t\u0013\u0005er+%A\u0005\u0002\u0005m\u0012AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003{Q3\u0001\\A\u0011\u0011%\t\teVI\u0001\n\u0003\tY$\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\t\u0013\u0005\u0015s+!A\u0005B\u0005\u001d\u0013!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002JA!\u00111JA+\u001b\t\tiE\u0003\u0003\u0002P\u0005E\u0013\u0001\u00027b]\u001eT!!a\u0015\u0002\t)\fg/Y\u0005\u0004_\u00055\u0003\"CA-/\u0006\u0005I\u0011AA.\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ti\u0006E\u0002\u0013\u0003?J1!!\u0019\u0014\u0005\rIe\u000e\u001e\u0005\n\u0003K:\u0016\u0011!C\u0001\u0003O\na\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002D\u0003SB!\"a\u001b\u0002d\u0005\u0005\t\u0019AA/\u0003\rAH%\r\u0005\n\u0003_:\u0016\u0011!C!\u0003c\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003g\u0002R!!\u001e\u0002|\rk!!a\u001e\u000b\u0007\u0005e4#\u0001\u0006d_2dWm\u0019;j_:LA!! \u0002x\tA\u0011\n^3sCR|'\u000fC\u0005\u0002\u0002^\u000b\t\u0011\"\u0001\u0002\u0004\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u0006\u0006-\u0005c\u0001\n\u0002\b&\u0019\u0011\u0011R\n\u0003\u000f\t{w\u000e\\3b]\"I\u00111NA@\u0003\u0003\u0005\ra\u0011\u0005\n\u0003\u001f;\u0016\u0011!C!\u0003#\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003;B\u0011\"!&X\u0003\u0003%\t%a&\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0013\t\u0013\u0005mu+!A\u0005B\u0005u\u0015AB3rk\u0006d7\u000f\u0006\u0003\u0002\u0006\u0006}\u0005\"CA6\u00033\u000b\t\u00111\u0001D\u000f%\t\u0019\u000bAA\u0001\u0012\u0013\t)+\u0001\fU_.,gNU1oO\u0016\u001c\u0016N_3FgRLW.\u0019;f!\rA\u0018q\u0015\u0004\t1\u0002\t\t\u0011#\u0003\u0002*N)\u0011qUAV;BI\u0011QVAZ\r\u001acGn^\u0007\u0003\u0003_S1!!-\u0014\u0003\u001d\u0011XO\u001c;j[\u0016LA!!.\u00020\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001b\t\u000f9\u000b9\u000b\"\u0001\u0002:R\u0011\u0011Q\u0015\u0005\u000b\u0003+\u000b9+!A\u0005F\u0005]\u0005BCA`\u0003O\u000b\t\u0011\"!\u0002B\u0006)\u0011\r\u001d9msRIq/a1\u0002F\u0006\u001d\u0017\u0011\u001a\u0005\u0007C\u0006u\u0006\u0019\u0001$\t\r\u0019\fi\f1\u0001G\u0011\u0019Q\u0017Q\u0018a\u0001Y\"1!/!0A\u00021D!\"!4\u0002(\u0006\u0005I\u0011QAh\u0003\u001d)h.\u00199qYf$B!!5\u0002^B)!#a5\u0002X&\u0019\u0011Q[\n\u0003\r=\u0003H/[8o!\u001d\u0011\u0012\u0011\u001c$GY2L1!a7\u0014\u0005\u0019!V\u000f\u001d7fi!I\u0011q\\Af\u0003\u0003\u0005\ra^\u0001\u0004q\u0012\u0002\u0004BCAr\u0003O\u000b\t\u0011\"\u0003\u0002f\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t9\u000f\u0005\u0003\u0002L\u0005%\u0018\u0002BAv\u0003\u001b\u0012aa\u00142kK\u000e$\bBCAx\u0001!\u0015\r\u0011\"\u0003\u0002r\u0006YAo\\6f]J\u000bgnZ3t+\t\t\u0019\u0010E\u0003\u0002v\n\u0015qO\u0004\u0003\u0002x\n\u0005a\u0002BA}\u0003\u007fl!!a?\u000b\u0007\u0005uh\"\u0001\u0004=e>|GOP\u0005\u0002)%\u0019!1A\n\u0002\u000fA\f7m[1hK&!!q\u0001B\u0005\u0005\r\u0019V-\u001d\u0006\u0004\u0005\u0007\u0019\u0002B\u0003B\u0007\u0001!\u0005\t\u0015)\u0003\u0002t\u0006aAo\\6f]J\u000bgnZ3tA!Aa\u0010\u0001EC\u0002\u0013%q\u0010\u0003\u0006\u0003\u0014\u0001A\t\u0011)Q\u0005\u0003\u0003\tQB]5oO\u001a\u0013\u0018m\u0019;j_:\u0004\u0003\"\u0003B\f\u0001!\u0015\r\u0011\"\u0001l\u00039\u0001\u0018M\u001d;ji&|gnQ8v]RD\u0011Ba\u0007\u0001\u0011\u0003\u0005\u000b\u0015\u00027\u0002\u001fA\f'\u000f^5uS>t7i\\;oi\u0002B\u0011Ba\b\u0001\u0011\u000b\u0007I\u0011A6\u0002\u001f\u0011\fG/Y*ju\u0016LeNQ=uKND\u0011Ba\t\u0001\u0011\u0003\u0005\u000b\u0015\u00027\u0002!\u0011\fG/Y*ju\u0016LeNQ=uKN\u0004\u0003\"\u0003B\u0014\u0001!\u0015\r\u0011\"\u0001l\u0003Q!x\u000e^1m\t\u0006$\u0018mU5{K&s')\u001f;fg\"I!1\u0006\u0001\t\u0002\u0003\u0006K\u0001\\\u0001\u0016i>$\u0018\r\u001c#bi\u0006\u001c\u0016N_3J]\nKH/Z:!\u000f\u001d\u0011yC\u0001E\u0001\u0005c\t\u0011\u0003R1uCNK'0Z#ti&l\u0017\r^3t!\r\u0011&1\u0007\u0004\u0007\u0003\tA\tA!\u000e\u0014\u0007\tM\u0012\u0003C\u0004O\u0005g!\tA!\u000f\u0015\u0005\tE\u0002\u0002\u0003B\u001f\u0005g!\tAa\u0010\u00021]\f\u0017\u000e\u001e$pe\u0012\u000bG/Y*ju\u0016,5\u000f^5nCR,7\u000f\u0006\u0006\u0002\u0006\n\u0005#1\tB#\u0005\u000fBa!\tB\u001e\u0001\u0004\u0011\u0003BB\u0015\u0003<\u0001\u0007!\u0006\u0003\u00043\u0005w\u0001\rA\u000b\u0005\t\u0005\u0013\u0012Y\u00041\u0001\u0002^\u0005YA/[7f_V$\u0018J\\'t\u0001")
public class DataSizeEstimates<V, T extends Token<V>>
implements Logging {
    private final CassandraConnector conn;
    public final String com$datastax$spark$connector$rdd$partitioner$DataSizeEstimates$$keyspaceName;
    public final String com$datastax$spark$connector$rdd$partitioner$DataSizeEstimates$$tableName;
    public final TokenFactory<V, T> com$datastax$spark$connector$rdd$partitioner$DataSizeEstimates$$tokenFactory;
    private Seq<TokenRangeSizeEstimate> tokenRanges;
    private double ringFraction;
    private long partitionCount;
    private long dataSizeInBytes;
    private long totalDataSizeInBytes;
    private volatile DataSizeEstimates$TokenRangeSizeEstimate$ TokenRangeSizeEstimate$module;
    private transient Logger org$apache$spark$Logging$$log_;
    private volatile byte bitmap$0;

    public static boolean waitForDataSizeEstimates(CassandraConnector cassandraConnector, String string, String string2, int n) {
        return DataSizeEstimates$.MODULE$.waitForDataSizeEstimates(cassandraConnector, string, string2, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DataSizeEstimates$TokenRangeSizeEstimate$ com$datastax$spark$connector$rdd$partitioner$DataSizeEstimates$$TokenRangeSizeEstimate$lzycompute() {
        DataSizeEstimates dataSizeEstimates = this;
        synchronized (dataSizeEstimates) {
            if (this.TokenRangeSizeEstimate$module != null) return this.TokenRangeSizeEstimate$module;
            this.TokenRangeSizeEstimate$module = new DataSizeEstimates$TokenRangeSizeEstimate$(this);
            return this.TokenRangeSizeEstimate$module;
        }
    }

    private Seq tokenRanges$lzycompute() {
        DataSizeEstimates dataSizeEstimates = this;
        synchronized (dataSizeEstimates) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.tokenRanges = (Seq)this.conn.withSessionDo(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ DataSizeEstimates $outer;

                    public final Seq<TokenRangeSizeEstimate> apply(Session session) {
                        Seq seq;
                        try {
                            ResultSet rs = session.execute("SELECT range_start, range_end, partitions_count, mean_partition_size FROM system.size_estimates WHERE keyspace_name = ? AND table_name = ?", new Object[]{this.$outer.com$datastax$spark$connector$rdd$partitioner$DataSizeEstimates$$keyspaceName, this.$outer.com$datastax$spark$connector$rdd$partitioner$DataSizeEstimates$$tableName});
                            seq = (Seq)JavaConversions$.MODULE$.asScalaBuffer(rs.all()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$tokenRanges$1 $outer;

                                public final TokenRangeSizeEstimate apply(Row row) {
                                    return new TokenRangeSizeEstimate(this.$outer.com$datastax$spark$connector$rdd$partitioner$DataSizeEstimates$$anonfun$$$outer(), this.$outer.com$datastax$spark$connector$rdd$partitioner$DataSizeEstimates$$anonfun$$$outer().com$datastax$spark$connector$rdd$partitioner$DataSizeEstimates$$tokenFactory.tokenFromString(row.getString("range_start")), this.$outer.com$datastax$spark$connector$rdd$partitioner$DataSizeEstimates$$anonfun$$$outer().com$datastax$spark$connector$rdd$partitioner$DataSizeEstimates$$tokenFactory.tokenFromString(row.getString("range_end")), row.getLong("partitions_count"), row.getLong("mean_partition_size"));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, Buffer$.MODULE$.canBuildFrom());
                        }
                        catch (InvalidQueryException invalidQueryException) {
                            this.$outer.logError((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$tokenRanges$1 $outer;

                                public final String apply() {
                                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to fetch size estimates for ", ".", " from system.size_estimates "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.com$datastax$spark$connector$rdd$partitioner$DataSizeEstimates$$anonfun$$$outer().com$datastax$spark$connector$rdd$partitioner$DataSizeEstimates$$keyspaceName, this.$outer.com$datastax$spark$connector$rdd$partitioner$DataSizeEstimates$$anonfun$$$outer().com$datastax$spark$connector$rdd$partitioner$DataSizeEstimates$$tableName}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table. The number of created Spark partitions may be inaccurate. "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please make sure you use Cassandra 2.1.5 or newer."})).s((Seq)Nil$.MODULE$)).toString();
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, invalidQueryException);
                            seq = (Seq)Seq$.MODULE$.empty();
                        }
                        return seq;
                    }

                    public /* synthetic */ DataSizeEstimates com$datastax$spark$connector$rdd$partitioner$DataSizeEstimates$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : var1_1
            this.conn = null;
            return this.tokenRanges;
        }
    }

    private double ringFraction$lzycompute() {
        DataSizeEstimates dataSizeEstimates = this;
        synchronized (dataSizeEstimates) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.ringFraction = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)this.tokenRanges().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(TokenRangeSizeEstimate x$1) {
                        return x$1.ringFraction();
                    }
                }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.ringFraction;
        }
    }

    private long partitionCount$lzycompute() {
        DataSizeEstimates dataSizeEstimates = this;
        synchronized (dataSizeEstimates) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                long partitionsCount = BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.tokenRanges().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(TokenRangeSizeEstimate x$2) {
                        return x$2.partitionsCount();
                    }
                }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                long normalizedCount = (long)((double)partitionsCount / this.ringFraction());
                this.logDebug((Function0<String>)new Serializable(this, normalizedCount){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ DataSizeEstimates $outer;
                    private final long normalizedCount$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Estimated partition count of ", ".", " is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.com$datastax$spark$connector$rdd$partitioner$DataSizeEstimates$$keyspaceName, this.$outer.com$datastax$spark$connector$rdd$partitioner$DataSizeEstimates$$tableName, BoxesRunTime.boxToLong((long)this.normalizedCount$1)}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.normalizedCount$1 = normalizedCount$1;
                    }
                });
                this.partitionCount = normalizedCount;
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.partitionCount;
        }
    }

    /*
     * WARNING - void declaration
     */
    private long dataSizeInBytes$lzycompute() {
        DataSizeEstimates dataSizeEstimates = this;
        synchronized (dataSizeEstimates) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                void var2_2;
                long tokenRangeSizeInBytes = (long)((double)this.totalDataSizeInBytes() / this.ringFraction());
                this.logDebug((Function0<String>)new Serializable(this, tokenRangeSizeInBytes){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ DataSizeEstimates $outer;
                    private final long tokenRangeSizeInBytes$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Estimated size of ", ".", " is ", " bytes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.com$datastax$spark$connector$rdd$partitioner$DataSizeEstimates$$keyspaceName, this.$outer.com$datastax$spark$connector$rdd$partitioner$DataSizeEstimates$$tableName, BoxesRunTime.boxToLong((long)this.tokenRangeSizeInBytes$1)}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.tokenRangeSizeInBytes$1 = tokenRangeSizeInBytes$1;
                    }
                });
                this.dataSizeInBytes = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.dataSizeInBytes;
        }
    }

    private long totalDataSizeInBytes$lzycompute() {
        DataSizeEstimates dataSizeEstimates = this;
        synchronized (dataSizeEstimates) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.totalDataSizeInBytes = BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.tokenRanges().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(TokenRangeSizeEstimate x$3) {
                        return x$3.totalSizeInBytes();
                    }
                }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
            return this.totalDataSizeInBytes;
        }
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public DataSizeEstimates$TokenRangeSizeEstimate$ com$datastax$spark$connector$rdd$partitioner$DataSizeEstimates$$TokenRangeSizeEstimate() {
        return this.TokenRangeSizeEstimate$module == null ? this.com$datastax$spark$connector$rdd$partitioner$DataSizeEstimates$$TokenRangeSizeEstimate$lzycompute() : this.TokenRangeSizeEstimate$module;
    }

    private Seq<TokenRangeSizeEstimate> tokenRanges() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.tokenRanges$lzycompute() : this.tokenRanges;
    }

    private double ringFraction() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.ringFraction$lzycompute() : this.ringFraction;
    }

    public long partitionCount() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.partitionCount$lzycompute() : this.partitionCount;
    }

    public long dataSizeInBytes() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.dataSizeInBytes$lzycompute() : this.dataSizeInBytes;
    }

    public long totalDataSizeInBytes() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.totalDataSizeInBytes$lzycompute() : this.totalDataSizeInBytes;
    }

    public DataSizeEstimates(CassandraConnector conn, String keyspaceName, String tableName, TokenFactory<V, T> tokenFactory) {
        this.conn = conn;
        this.com$datastax$spark$connector$rdd$partitioner$DataSizeEstimates$$keyspaceName = keyspaceName;
        this.com$datastax$spark$connector$rdd$partitioner$DataSizeEstimates$$tableName = tableName;
        this.com$datastax$spark$connector$rdd$partitioner$DataSizeEstimates$$tokenFactory = tokenFactory;
        Logging.class.$init$((Logging)this);
    }

    public class TokenRangeSizeEstimate
    implements Product,
    Serializable {
        private final T rangeStart;
        private final T rangeEnd;
        private final long partitionsCount;
        private final long meanPartitionSize;
        public final /* synthetic */ DataSizeEstimates $outer;

        public T rangeStart() {
            return this.rangeStart;
        }

        public T rangeEnd() {
            return this.rangeEnd;
        }

        public long partitionsCount() {
            return this.partitionsCount;
        }

        public long meanPartitionSize() {
            return this.meanPartitionSize;
        }

        public double ringFraction() {
            return this.com$datastax$spark$connector$rdd$partitioner$DataSizeEstimates$TokenRangeSizeEstimate$$$outer().com$datastax$spark$connector$rdd$partitioner$DataSizeEstimates$$tokenFactory.ringFraction(this.rangeStart(), this.rangeEnd());
        }

        public long totalSizeInBytes() {
            return this.partitionsCount() * this.meanPartitionSize();
        }

        public TokenRangeSizeEstimate copy(T rangeStart, T rangeEnd, long partitionsCount, long meanPartitionSize) {
            return new TokenRangeSizeEstimate(this.com$datastax$spark$connector$rdd$partitioner$DataSizeEstimates$TokenRangeSizeEstimate$$$outer(), rangeStart, rangeEnd, partitionsCount, meanPartitionSize);
        }

        public T copy$default$1() {
            return this.rangeStart();
        }

        public T copy$default$2() {
            return this.rangeEnd();
        }

        public long copy$default$3() {
            return this.partitionsCount();
        }

        public long copy$default$4() {
            return this.meanPartitionSize();
        }

        public String productPrefix() {
            return "TokenRangeSizeEstimate";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 3: {
                    object = BoxesRunTime.boxToLong((long)this.meanPartitionSize());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToLong((long)this.partitionsCount());
                    break;
                }
                case 1: {
                    object = this.rangeEnd();
                    break;
                }
                case 0: {
                    object = this.rangeStart();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof TokenRangeSizeEstimate;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.rangeStart()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.rangeEnd()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.partitionsCount()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.meanPartitionSize()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof TokenRangeSizeEstimate)) return false;
            boolean bl = true;
            if (!bl) return false;
            TokenRangeSizeEstimate tokenRangeSizeEstimate = (TokenRangeSizeEstimate)x$1;
            Object t = this.rangeStart();
            Object t2 = tokenRangeSizeEstimate.rangeStart();
            if (t == null) {
                if (t2 != null) {
                    return false;
                }
            } else if (!t.equals(t2)) return false;
            Object t3 = this.rangeEnd();
            Object t4 = tokenRangeSizeEstimate.rangeEnd();
            if (t3 == null) {
                if (t4 != null) {
                    return false;
                }
            } else if (!t3.equals(t4)) return false;
            if (this.partitionsCount() != tokenRangeSizeEstimate.partitionsCount()) return false;
            if (this.meanPartitionSize() != tokenRangeSizeEstimate.meanPartitionSize()) return false;
            if (!tokenRangeSizeEstimate.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ DataSizeEstimates com$datastax$spark$connector$rdd$partitioner$DataSizeEstimates$TokenRangeSizeEstimate$$$outer() {
            return this.$outer;
        }

        public TokenRangeSizeEstimate(DataSizeEstimates<V, T> $outer, T rangeStart, T rangeEnd, long partitionsCount, long meanPartitionSize) {
            this.rangeStart = rangeStart;
            this.rangeEnd = rangeEnd;
            this.partitionsCount = partitionsCount;
            this.meanPartitionSize = meanPartitionSize;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
        }
    }
}

