/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.rdd.partitioner;

import com.datastax.spark.connector.rdd.CassandraRDD;
import com.datastax.spark.connector.rdd.partitioner.DataSizeEstimates;
import com.datastax.spark.connector.rdd.partitioner.SplitSizeEstimator;
import com.datastax.spark.connector.rdd.partitioner.dht.Token;
import com.datastax.spark.connector.rdd.partitioner.dht.TokenFactory;
import com.datastax.spark.connector.rdd.partitioner.dht.TokenFactory$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;

public abstract class SplitSizeEstimator$class {
    public static TokenFactory tokenFactory(CassandraRDD $this) {
        return TokenFactory$.MODULE$.forSystemLocalPartitioner($this.connector());
    }

    private static long estimateDataSize(CassandraRDD $this) {
        return new DataSizeEstimates<Object, Token>($this.connector(), $this.keyspaceName(), $this.tableName(), ((SplitSizeEstimator)((Object)$this)).tokenFactory()).dataSizeInBytes();
    }

    public static int minimalSplitCount(CassandraRDD $this) {
        int coreCount = $this.context().defaultParallelism();
        return 1 + coreCount * 2;
    }

    public static int estimateSplitCount(CassandraRDD $this, int splitSize) {
        Predef$.MODULE$.require(splitSize > 0, (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Split size must be greater than zero.";
            }
        });
        long splitCountEstimate = SplitSizeEstimator$class.estimateDataSize((CassandraRDD)((Object)((SplitSizeEstimator)((Object)$this)))) / (long)splitSize;
        return Math.max((int)splitCountEstimate, ((SplitSizeEstimator)((Object)$this)).minimalSplitCount());
    }

    public static void $init$(CassandraRDD $this) {
    }
}

