/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.ThrowingEx;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.Serializable;
import java.util.Objects;
import java.util.Random;

@SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
abstract class FormatterStepImpl<State extends Serializable>
extends FormatterStep.Strict<State> {
    private static final long serialVersionUID = 1L;
    final transient String name;
    final transient ThrowingEx.Supplier<State> stateSupplier;
    static final File SENTINEL = new File("");

    FormatterStepImpl(String name, ThrowingEx.Supplier<State> stateSupplier) {
        this.name = Objects.requireNonNull(name);
        this.stateSupplier = Objects.requireNonNull(stateSupplier);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    protected State calculateState() throws Exception {
        return (State)((Serializable)this.stateSupplier.get());
    }

    static class NeverUpToDate
    extends FormatterStepImpl<Integer> {
        private static final long serialVersionUID = 1L;
        private static final Random RANDOM = new Random();
        final transient ThrowingEx.Supplier<FormatterFunc> formatterSupplier;
        transient FormatterFunc formatter;

        NeverUpToDate(String name, ThrowingEx.Supplier<FormatterFunc> formatterSupplier) {
            super(name, RANDOM::nextInt);
            this.formatterSupplier = Objects.requireNonNull(formatterSupplier, "formatterSupplier");
        }

        @Override
        protected String format(Integer state, String rawUnix, File file) throws Exception {
            if (this.formatter == null) {
                this.formatter = this.formatterSupplier.get();
                if (this.formatter instanceof FormatterFunc.Closeable) {
                    throw new AssertionError((Object)"NeverUpToDate does not support FormatterFunc.Closeable.  See https://github.com/diffplug/spotless/pull/284");
                }
            }
            return this.formatter.apply(rawUnix, file);
        }
    }

    static final class Standard<State extends Serializable>
    extends FormatterStepImpl<State> {
        private static final long serialVersionUID = 1L;
        final transient ThrowingEx.Function<State, FormatterFunc> stateToFormatter;
        transient FormatterFunc formatter;

        Standard(String name, ThrowingEx.Supplier<State> stateSupplier, ThrowingEx.Function<State, FormatterFunc> stateToFormatter) {
            super(name, stateSupplier);
            this.stateToFormatter = Objects.requireNonNull(stateToFormatter);
        }

        @Override
        protected String format(State state, String rawUnix, File file) throws Exception {
            Objects.requireNonNull(state, "state");
            Objects.requireNonNull(rawUnix, "rawUnix");
            Objects.requireNonNull(file, "file");
            if (this.formatter == null) {
                this.formatter = this.stateToFormatter.apply(this.state());
            }
            return this.formatter.apply(rawUnix, file);
        }

        void cleanupFormatterFunc() {
            if (this.formatter instanceof FormatterFunc.Closeable) {
                ((FormatterFunc.Closeable)this.formatter).close();
            }
        }
    }
}

