/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven;

import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.LineEnding;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.maven.ArtifactResolver;
import com.diffplug.spotless.maven.FileLocator;
import com.diffplug.spotless.maven.FormatterConfig;
import com.diffplug.spotless.maven.FormatterFactory;
import com.diffplug.spotless.maven.FormatterStepFactory;
import com.diffplug.spotless.maven.MavenProvisioner;
import com.diffplug.spotless.maven.cpp.Cpp;
import com.diffplug.spotless.maven.generic.Format;
import com.diffplug.spotless.maven.generic.LicenseHeader;
import com.diffplug.spotless.maven.java.Java;
import com.diffplug.spotless.maven.kotlin.Kotlin;
import com.diffplug.spotless.maven.scala.Scala;
import com.diffplug.spotless.maven.xml.Xml;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

public abstract class AbstractSpotlessMojo
extends AbstractMojo {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String DEFAULT_LINE_ENDINGS = "GIT_ATTRIBUTES";
    @Component
    private RepositorySystem repositorySystem;
    @Component
    private ResourceManager resourceManager;
    @Parameter(defaultValue="${repositorySystemSession}", required=true, readonly=true)
    private RepositorySystemSession repositorySystemSession;
    @Parameter(defaultValue="${project.remotePluginRepositories}", required=true, readonly=true)
    private List<RemoteRepository> repositories;
    @Parameter(defaultValue="${project.basedir}", required=true, readonly=true)
    private File baseDir;
    @Parameter(defaultValue="${project.build.directory}", required=true, readonly=true)
    private File targetDir;
    @Parameter(defaultValue="UTF-8")
    private String encoding;
    @Parameter(defaultValue="GIT_ATTRIBUTES")
    private LineEnding lineEndings;
    @Parameter
    private LicenseHeader licenseHeader;
    @Parameter
    private List<Format> formats = Collections.emptyList();
    @Parameter
    private Java java;
    @Parameter
    private Scala scala;
    @Parameter
    private Kotlin kotlin;
    @Parameter
    private Xml xml;
    @Parameter
    private Cpp cpp;

    protected abstract void process(List<File> var1, Formatter var2) throws MojoExecutionException;

    public final void execute() throws MojoExecutionException {
        List<FormatterFactory> formatterFactories = this.getFormatterFactories();
        for (FormatterFactory formatterFactory : formatterFactories) {
            this.execute(formatterFactory);
        }
    }

    private void execute(FormatterFactory formatterFactory) throws MojoExecutionException {
        List<File> files = this.collectFiles(formatterFactory);
        try (Formatter formatter = formatterFactory.newFormatter(files, this.getFormatterConfig());){
            this.process(files, formatter);
        }
    }

    private List<File> collectFiles(FormatterFactory formatterFactory) throws MojoExecutionException {
        Set<String> configuredIncludes = formatterFactory.includes();
        Set<String> configuredExcludes = formatterFactory.excludes();
        Set<String> includes = configuredIncludes.isEmpty() ? formatterFactory.defaultIncludes() : configuredIncludes;
        HashSet<String> excludes = new HashSet<String>(FileUtils.getDefaultExcludesAsList());
        excludes.add(AbstractSpotlessMojo.withTrailingSeparator(this.targetDir.toString()));
        excludes.addAll(configuredExcludes);
        String includesString = String.join((CharSequence)",", includes);
        String excludesString = String.join((CharSequence)",", excludes);
        try {
            return FileUtils.getFiles((File)this.baseDir, (String)includesString, (String)excludesString);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to scan file tree rooted at " + this.baseDir, (Exception)e);
        }
    }

    private static String withTrailingSeparator(String path) {
        return path.endsWith(File.separator) ? path : path + File.separator;
    }

    private FormatterConfig getFormatterConfig() {
        ArtifactResolver resolver = new ArtifactResolver(this.repositorySystem, this.repositorySystemSession, this.repositories, this.getLog());
        Provisioner provisioner = MavenProvisioner.create(resolver);
        List<FormatterStepFactory> formatterStepFactories = this.getFormatterStepFactories();
        FileLocator fileLocator = this.getFileLocator();
        return new FormatterConfig(this.baseDir, this.encoding, this.lineEndings, provisioner, fileLocator, formatterStepFactories);
    }

    private FileLocator getFileLocator() {
        this.resourceManager.addSearchPath("file", this.baseDir.getAbsolutePath());
        this.resourceManager.addSearchPath("url", "");
        this.resourceManager.setOutputDirectory(this.targetDir);
        return new FileLocator(this.resourceManager);
    }

    private List<FormatterFactory> getFormatterFactories() {
        return Stream.concat(this.formats.stream(), Stream.of(this.java, this.scala, this.kotlin, this.cpp, this.xml)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<FormatterStepFactory> getFormatterStepFactories() {
        return Stream.of(this.licenseHeader).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

