/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven.generic;

import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.maven.FormatterStepConfig;
import com.diffplug.spotless.maven.FormatterStepFactory;
import com.diffplug.spotless.npm.PrettierConfig;
import com.diffplug.spotless.npm.PrettierFormatterStep;
import java.io.File;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.maven.plugins.annotations.Parameter;

public class Prettier
implements FormatterStepFactory {
    public static final String ERROR_MESSAGE_ONLY_ONE_CONFIG = "must specify exactly one prettierVersion, devDependencies or devDependencyProperties";
    @Parameter
    private String prettierVersion;
    @Parameter
    private Map<String, String> devDependencies;
    @Parameter
    private Properties devDependencyProperties;
    @Parameter
    private Map<String, String> config;
    @Parameter
    private String configFile;
    @Parameter
    private String npmExecutable;

    @Override
    public FormatterStep newFormatterStep(FormatterStepConfig stepConfig) {
        if (this.moreThanOneNonNull(this.prettierVersion, this.devDependencies, this.devDependencyProperties)) {
            throw Prettier.onlyOneConfig();
        }
        if (this.devDependencies == null) {
            this.devDependencies = PrettierFormatterStep.defaultDevDependencies();
        }
        if (this.prettierVersion != null && !this.prettierVersion.isEmpty()) {
            this.devDependencies = PrettierFormatterStep.defaultDevDependenciesWithPrettier((String)this.prettierVersion);
        } else if (this.devDependencyProperties != null) {
            this.devDependencies = this.dependencyPropertiesAsMap();
        }
        File npm = this.npmExecutable != null ? stepConfig.getFileLocator().locateFile(this.npmExecutable) : null;
        File configFileHandler = this.configFile != null ? stepConfig.getFileLocator().locateFile(this.configFile) : null;
        Map configInline = this.config != null ? (Map)this.config.entrySet().stream().map(entry -> {
            try {
                Integer value = Integer.parseInt((String)entry.getValue());
                return new AbstractMap.SimpleEntry(entry.getKey(), value);
            }
            catch (NumberFormatException numberFormatException) {
                if (Boolean.TRUE.toString().equalsIgnoreCase((String)entry.getValue()) || Boolean.FALSE.toString().equalsIgnoreCase((String)entry.getValue())) {
                    return new AbstractMap.SimpleEntry(entry.getKey(), Boolean.parseBoolean((String)entry.getValue()));
                }
                return entry;
            }
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a, LinkedHashMap::new)) : null;
        PrettierConfig prettierConfig = new PrettierConfig(configFileHandler, configInline);
        File buildDir = stepConfig.getFileLocator().getBuildDir();
        return PrettierFormatterStep.create(this.devDependencies, (Provisioner)stepConfig.getProvisioner(), (File)buildDir, (File)npm, (PrettierConfig)prettierConfig);
    }

    private boolean moreThanOneNonNull(Object ... objects) {
        return Arrays.stream(objects).filter(Objects::nonNull).filter(o -> !(o instanceof String) || !((String)o).isEmpty()).count() > 1L;
    }

    private Map<String, String> dependencyPropertiesAsMap() {
        return this.devDependencyProperties.stringPropertyNames().stream().map(name -> new AbstractMap.SimpleEntry<String, String>((String)name, this.devDependencyProperties.getProperty((String)name))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static IllegalArgumentException onlyOneConfig() {
        return new IllegalArgumentException(ERROR_MESSAGE_ONLY_ONE_CONFIG);
    }
}

