/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.modbus;

import java.util.Optional;

public enum ExceptionCode {
    IllegalFunction(1),
    IllegalDataAddress(2),
    IllegalDataValue(3),
    SlaveDeviceFailure(4),
    Acknowledge(5),
    SlaveDeviceBusy(6),
    MemoryParityError(8),
    GatewayPathUnavailable(10),
    GatewayTargetDeviceFailedToResponse(11);

    private final int code;

    private ExceptionCode(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static Optional<ExceptionCode> fromCode(int code) {
        switch (code) {
            case 1: {
                return Optional.of(IllegalFunction);
            }
            case 2: {
                return Optional.of(IllegalDataAddress);
            }
            case 3: {
                return Optional.of(IllegalDataValue);
            }
            case 4: {
                return Optional.of(SlaveDeviceFailure);
            }
            case 5: {
                return Optional.of(Acknowledge);
            }
            case 6: {
                return Optional.of(SlaveDeviceBusy);
            }
            case 8: {
                return Optional.of(MemoryParityError);
            }
            case 10: {
                return Optional.of(GatewayPathUnavailable);
            }
            case 11: {
                return Optional.of(GatewayTargetDeviceFailedToResponse);
            }
        }
        return Optional.empty();
    }
}

